/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.ui.DropDownButtonStateful;
import edu.ku.brc.ui.DropDownMenuInfo;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class MenuSwitcherPanel
extends JPanel {
    protected CardLayout cardLayout = null;
    protected Hashtable<String, Vector<AltViewIFace>> selectorValHash = null;
    protected Hashtable<String, DropDownButtonStateful> switcherHash = null;
    protected boolean isSelector;
    protected SwitcherAL switcherAL = null;

    public MenuSwitcherPanel(MultiView mvParent, AltViewIFace altView, Vector<AltViewIFace> altViewsList) {
        this.setOpaque(false);
        this.switcherHash = new Hashtable();
        this.selectorValHash = new Hashtable();
        this.isSelector = StringUtils.isNotEmpty((String)altView.getSelectorName());
        if (this.isSelector) {
            Vector<AltViewIFace> avList;
            this.cardLayout = new CardLayout();
            this.setLayout(this.cardLayout);
            for (AltViewIFace av : altViewsList) {
                avList = this.selectorValHash.get(av.getSelectorValue());
                if (avList == null) {
                    avList = new Vector();
                    this.selectorValHash.put(av.getSelectorValue(), avList);
                }
                avList.add(av);
            }
            for (String selectorVal : this.selectorValHash.keySet()) {
                avList = this.selectorValHash.get(selectorVal);
                DropDownButtonStateful switcherUI = this.createSwitcher(mvParent, avList);
                switcherUI.setOpaque(false);
                this.add((Component)switcherUI, selectorVal);
                this.switcherHash.put(selectorVal, switcherUI);
            }
        } else {
            this.setLayout(new BorderLayout());
            DropDownButtonStateful switcherUI = this.createSwitcher(mvParent, altViewsList);
            switcherUI.setOpaque(false);
            this.add((Component)switcherUI, "Center");
            this.switcherHash.put("0", switcherUI);
            this.selectorValHash.put("0", altViewsList);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (DropDownButtonStateful ddbs : this.switcherHash.values()) {
            ddbs.setEnabled(enabled);
        }
    }

    public void set(AltViewIFace altView) {
        if (this.cardLayout != null) {
            this.cardLayout.show(this, altView.getSelectorValue());
        }
        String value = this.isSelector ? altView.getSelectorValue() : "0";
        Vector<AltViewIFace> avList = this.selectorValHash.get(value);
        DropDownButtonStateful dds = this.switcherHash.get(value);
        if (dds != null && avList != null) {
            dds.setCurrentIndex(avList.indexOf(altView));
        }
    }

    public SwitcherAL getSwitcherAL() {
        return this.switcherAL;
    }

    protected DropDownButtonStateful createSwitcher(MultiView mvParentArg, Vector<AltViewIFace> altViewsListArg) {
        DropDownButtonStateful switcher = null;
        ArrayList<DropDownMenuInfo> items = new ArrayList<DropDownMenuInfo>(altViewsListArg.size());
        if (altViewsListArg.size() > 0) {
            for (AltViewIFace av : altViewsListArg) {
                boolean isEdit;
                String label = null;
                ImageIcon imgIcon = null;
                String toolTip = null;
                ViewDefIFace viewDef = av.getViewDef();
                boolean bl = isEdit = av.getMode() == AltViewIFace.CreationMode.EDIT;
                if (viewDef != null) {
                    if (viewDef.getType() == ViewDefIFace.ViewType.form) {
                        label = UIRegistry.getResourceString("Form");
                        imgIcon = IconManager.getImage(isEdit ? "EditForm" : "ViewForm", IconManager.IconSize.Std16);
                        toolTip = UIRegistry.getResourceString(isEdit ? "ShowEditViewTT" : "ShowViewTT");
                    } else if (viewDef.getType() == ViewDefIFace.ViewType.table || viewDef.getType() == ViewDefIFace.ViewType.formtable) {
                        label = UIRegistry.getResourceString("Grid");
                        imgIcon = IconManager.getImage(isEdit ? "SpreadsheetEdit" : "Spreadsheet", IconManager.IconSize.Std16);
                        toolTip = UIRegistry.getResourceString("ShowSpreadsheetTT");
                    } else {
                        label = UIRegistry.getResourceString("Icon");
                        imgIcon = IconManager.getImage("image", IconManager.IconSize.Std16);
                        toolTip = UIRegistry.getResourceString("ShowViewTT");
                    }
                }
                if (mvParentArg.isTopLevel()) {
                    label = UIRegistry.getResourceString(isEdit ? "EDIT" : "View");
                }
                items.add(new DropDownMenuInfo(label, imgIcon, toolTip));
            }
            switcher = new DropDownButtonStateful(items);
            switcher.setToolTipText(UIRegistry.getResourceString("SwitchViewsTT"));
            switcher.addActionListener(new SwitcherAL(switcher, mvParentArg, altViewsListArg, false));
            switcher.validate();
            switcher.doLayout();
            switcher.setOpaque(false);
            this.switcherAL = new SwitcherAL(switcher, mvParentArg, altViewsListArg, true);
        }
        return switcher;
    }

    public class SwitcherAL
    implements ActionListener {
        protected DropDownButtonStateful switcherComp;
        protected MultiView mvParent;
        protected Vector<AltViewIFace> altViewsList;
        protected boolean doIncrement;

        public SwitcherAL(DropDownButtonStateful switcherComp, MultiView mvParent, Vector<AltViewIFace> altViewsList, boolean doIncrement) {
            this.switcherComp = switcherComp;
            this.mvParent = mvParent;
            this.altViewsList = altViewsList;
            this.doIncrement = doIncrement;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.doIncrement) {
                this.switcherComp.doAdvance(ae);
            } else {
                this.mvParent.showView(this.altViewsList.get(this.switcherComp.getCurrentIndex()));
            }
        }
    }
}

