/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.IconViewObj;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class IconViewTransferHandler
extends TransferHandler {
    protected IconViewObj iconViewObj;

    public IconViewTransferHandler(IconViewObj iconViewObj) {
        this.iconViewObj = iconViewObj;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        DataFlavor[] dataFlavorArray = transferFlavors;
        int n = transferFlavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            if (df.equals(DataFlavor.javaFileListFlavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        boolean result = false;
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
            List fileList = (List)data;
            for (File f : fileList) {
                boolean response = this.iconViewObj.addRecord(f);
                if (!response) continue;
                result = response;
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(IconViewTransferHandler.class, e);
            e.printStackTrace();
        }
        return result;
    }
}

