/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.FileImportProcessor;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.IconViewTransferHandler;
import edu.ku.brc.af.ui.forms.MenuSwitcherPanel;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.RestrictablePanel;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.DefaultClassActionHandler;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.OrderedIconTray;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Orderable;
import edu.ku.brc.util.OrderableComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IconViewObj
implements Viewable {
    protected static final Logger log = Logger.getLogger(IconViewObj.class);
    protected DataProviderSessionIFace session;
    protected MultiView mvParent;
    protected ViewIFace view;
    protected AltViewIFace altView;
    protected ViewDefIFace viewDef;
    protected String cellName;
    protected Vector<AltViewIFace> altViewsList;
    protected int viewOptions;
    protected Class<?> classToCreate = null;
    protected boolean ignoreChanges = false;
    protected boolean isSkippingAttach = false;
    protected FormDataObjIFace parentDataObj;
    protected Set<Object> dataSet;
    protected String dataClassName;
    protected String dataSetFieldName;
    protected boolean dataTypeError;
    protected OrderedIconTray iconTray;
    protected RestrictablePanel mainComp;
    protected JPanel southPanel;
    protected JButton viewBtn = null;
    protected JButton editBtn = null;
    protected JButton newBtn = null;
    protected JButton delBtn = null;
    protected JPanel sepController = null;
    protected MenuSwitcherPanel switcherUI;
    protected JButton validationInfoBtn = null;
    protected FormValidator validator = null;
    protected FormValidator parentValidator = null;
    protected boolean isEditing;
    protected BusinessRulesIFace businessRules;
    protected Class<?> dataClass;
    protected boolean orderableDataClass;
    private PermissionSettings perm = null;

    public IconViewObj(ViewIFace view, AltViewIFace altView, MultiView mvParent, int options, String cellName, Class<?> dataClass) {
        this.view = view;
        this.altView = altView;
        this.mvParent = mvParent;
        this.viewOptions = options;
        this.viewDef = altView.getViewDef();
        this.dataTypeError = false;
        this.businessRules = view.createBusinessRule();
        this.cellName = cellName;
        this.dataClass = dataClass;
        if (this.businessRules != null) {
            this.businessRules.initialize(this);
        }
        boolean bl = this.isEditing = MultiView.isOptionOn(options, 16) || MultiView.isOptionOn(options, 4);
        if (this.isEditing && mvParent.getMultiViewParent() != null) {
            this.parentValidator = mvParent.getMultiViewParent().getCurrentValidator();
            this.validator = new FormValidator(null){

                @Override
                public boolean isFormValid() {
                    return true;
                }
            };
        }
        this.checkOrderableness();
    }

    @Override
    public MultiView getMVParent() {
        return this.mvParent;
    }

    @Override
    public void setClassToCreate(Class<?> classToCreate) {
        this.classToCreate = classToCreate;
    }

    public String getDataClassName() {
        return this.dataClassName;
    }

    protected void initMainComp() {
        if (this.isEditing) {
            String delTTStr = ResultSetController.createTooltip("DeleteRecordTT", this.view.getObjTitle());
            String edtTTStr = ResultSetController.createTooltip("EditRecordTT", this.view.getObjTitle());
            String newTTStr = ResultSetController.createTooltip("NewRecordTT", this.view.getObjTitle());
            this.editBtn = UIHelper.createIconBtnTT("EditForm", IconManager.IconSize.Std16, edtTTStr, false, null);
            this.newBtn = UIHelper.createIconBtnTT("CreateObj", IconManager.IconSize.Std16, newTTStr, false, null);
            this.delBtn = UIHelper.createIconBtnTT("DeleteRecord", IconManager.IconSize.Std16, delTTStr, false, null);
            this.validationInfoBtn = FormViewObj.createValidationIndicator(this.mainComp, this.getValidator());
            this.editBtn.setEnabled(false);
            this.delBtn.setEnabled(false);
            this.newBtn.setEnabled(true);
        } else {
            String srchTTStr = ResultSetController.createTooltip("ShowRecordInfoTT", this.view.getObjTitle());
            this.viewBtn = UIHelper.createIconBtnTT("InfoIcon", IconManager.IconSize.Std16, srchTTStr, false, null);
            this.viewBtn.setEnabled(false);
        }
        this.altViewsList = new Vector();
        this.switcherUI = FormViewObj.createMenuSwitcherPanel(this.mvParent, this.view, this.altView, this.altViewsList, this.mainComp, this.cellName, this.dataClass);
        this.iconTray = new OrderedIconTray(1);
        this.iconTray.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("item order")) {
                    IconViewObj.this.rootHasChanged();
                }
            }
        });
        this.iconTray.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    IconViewObj.this.updateEnableUI();
                } else if (e.getClickCount() > 1) {
                    IconViewObj.this.doDoubleClick();
                }
            }
        });
        this.iconTray.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    IconViewObj.this.updateEnableUI();
                }
            }
        });
        if (this.isEditing) {
            this.addActionListenerToEditButton();
            this.addActionListenerToNewButton();
            this.addActionListenerToDeleteButton();
            IconViewTransferHandler ivth = new IconViewTransferHandler(this);
            this.iconTray.setTransferHandler(ivth);
        } else {
            this.addActionListenerToViewButton();
        }
        this.mainComp = new RestrictablePanel();
        this.mainComp.setLayout(new BorderLayout());
        if (this.mvParent == null) {
            this.mainComp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }
        boolean isAbove = this.mvParent.getSeparator() != null;
        int defCnt = (this.isEditing ? 3 : 1) + (this.switcherUI != null ? 1 : 0) + (this.validationInfoBtn != null ? 1 : 0);
        String colDef = String.valueOf(isAbove ? "1px," : "f:1px:g,") + UIHelper.createDuplicateJGoodiesDef("p", "1px", defCnt);
        PanelBuilder builder = new PanelBuilder(new FormLayout(colDef, "p"));
        CellConstraints cc = new CellConstraints();
        int x = 2;
        if (this.isEditing) {
            builder.add((Component)this.editBtn, cc.xy(x, 1));
            builder.add((Component)this.newBtn, cc.xy(x += 2, 1));
            builder.add((Component)this.delBtn, cc.xy(x += 2, 1));
            x += 2;
            if (this.validationInfoBtn != null) {
                builder.add((Component)this.validationInfoBtn, cc.xy(x, 1));
                x += 2;
            }
        } else {
            builder.add((Component)this.viewBtn, cc.xy(x, 1));
            x += 2;
        }
        if (this.switcherUI != null) {
            builder.add((Component)this.switcherUI, cc.xy(x, 1));
            x += 2;
        }
        if (isAbove) {
            this.sepController = builder.getPanel();
        } else {
            this.southPanel = builder.getPanel();
            this.mainComp.add((Component)this.southPanel, "South");
        }
        this.mainComp.add((Component)this.iconTray, "Center");
    }

    @Override
    public boolean isDataCompleteAndValid(boolean throwAwayOnDiscard) {
        return true;
    }

    protected void checkOrderableness() {
        try {
            Class<?> dataClss = Class.forName(this.dataClassName != null ? this.dataClassName : this.view.getClassName());
            if (Orderable.class.isAssignableFrom(dataClss)) {
                this.orderableDataClass = true;
                return;
            }
        }
        catch (ClassNotFoundException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(IconViewObj.class, e);
            log.error((Object)"Data class of view cannot be found", (Throwable)e);
        }
        if (this.iconTray != null) {
            this.iconTray.setOrderable(false);
        }
    }

    protected void updateEnableUI() {
        boolean enabled;
        boolean bl = enabled = this.iconTray.getSelectedValue() != null;
        if (this.editBtn != null) {
            this.editBtn.setEnabled(enabled);
        }
        if (this.delBtn != null) {
            this.delBtn.setEnabled(enabled);
        }
        if (this.viewBtn != null) {
            this.viewBtn.setEnabled(enabled);
        }
    }

    protected void doDoubleClick() {
        FormDataObjIFace selection = this.iconTray.getSelectedValue();
        ActionListener listener = DefaultClassActionHandler.getInstance().getDefaultClassActionHandler(selection.getClass());
        if (listener != null) {
            listener.actionPerformed(new IconViewActionEvent(selection, 0, "double-click", this));
        } else {
            ViewBasedDisplayIFace dialog = FormHelper.createDataObjectDialog(this.mainComp, selection, MultiView.isOptionOn(this.viewOptions, 16), false);
            if (dialog != null) {
                dialog.setData(selection);
                dialog.showDisplay(true);
                dialog.dispose();
            }
        }
    }

    protected void addActionListenerToViewButton() {
        if (this.viewBtn != null) {
            this.viewBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IconViewObj.this.doDoubleClick();
                }
            });
        }
    }

    protected void addActionListenerToEditButton() {
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FormDataObjIFace selection = IconViewObj.this.iconTray.getSelection();
                if (selection == null) {
                    return;
                }
                ViewBasedDisplayIFace dialog = FormHelper.createDataObjectDialog(IconViewObj.this.mainComp, selection, MultiView.isOptionOn(IconViewObj.this.viewOptions, 16), false);
                if (dialog != null) {
                    dialog.setData(selection);
                    dialog.showDisplay(true);
                    if (dialog.getBtnPressed() == 1) {
                        dialog.getMultiView().getDataFromUI();
                        IconViewObj.this.rootHasChanged();
                        IconViewObj.this.iconTray.validate();
                        IconViewObj.this.iconTray.repaint();
                    }
                    dialog.dispose();
                }
            }
        });
    }

    public boolean addRecord(File f) {
        FormDataObjIFace newObject = this.classToCreate != null ? FormHelper.createAndNewDataObj(this.classToCreate, this.businessRules) : FormHelper.createAndNewDataObj(this.view.getClassName(), this.businessRules);
        FileImportProcessor importer = FileImportProcessor.getInstance();
        if (!importer.importFileIntoRecord(newObject, f)) {
            return false;
        }
        this.parentDataObj.addReference(newObject, this.dataSetFieldName);
        this.iconTray.addItem(newObject);
        this.rootHasChanged();
        return true;
    }

    protected void rootHasChanged() {
        if (!this.ignoreChanges) {
            MultiView realParent;
            if (this.validator != null) {
                this.validator.setHasChanged(true);
                this.validator.validateForm();
            }
            if ((realParent = this.mvParent.getMultiViewParent()) != null) {
                realParent.getCurrentValidator().setHasChanged(true);
                realParent.getCurrentValidator().validateForm();
            }
        }
    }

    protected void createNewDataObject() {
        if (this.businessRules != null && this.businessRules.canCreateNewDataObject()) {
            this.businessRules.createNewObj(true, null);
        } else {
            FormDataObjIFace newObject = this.classToCreate != null ? FormHelper.createAndNewDataObj(this.classToCreate, this.businessRules) : FormHelper.createAndNewDataObj(this.view.getClassName(), this.businessRules);
            this.setNewObject(newObject);
        }
    }

    @Override
    public void setNewObject(FormDataObjIFace newDataObj) {
        ViewBasedDisplayIFace dialog = FormHelper.createDataObjectDialog(this.mainComp, newDataObj, true, true);
        if (dialog == null) {
            log.error((Object)("Unable to create a dialog for data entry.  [" + newDataObj.getClass().getName() + "]"));
            return;
        }
        if (this.mvParent != null) {
            this.mvParent.registerDisplayFrame(dialog);
        }
        dialog.setData(newDataObj);
        dialog.showDisplay(true);
        if (dialog.getBtnPressed() == 1) {
            dialog.getMultiView().getDataFromUI();
            log.warn((Object)("User clicked OK.  Adding " + newDataObj.getIdentityTitle() + " into " + this.dataSetFieldName + "."));
            this.parentDataObj.addReference(newDataObj, this.dataSetFieldName);
            this.iconTray.addItem(newDataObj);
            this.rootHasChanged();
        } else if (dialog.isCancelled() && this.mvParent.getMultiViewParent() != null && this.mvParent.getMultiViewParent().getCurrentValidator() != null) {
            this.mvParent.getMultiViewParent().getCurrentValidator().validateForm();
        }
        dialog.dispose();
    }

    protected void addActionListenerToNewButton() {
        this.newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IconViewObj.this.createNewDataObject();
            }
        });
    }

    protected void doDelete() {
        FormDataObjIFace dataObj = this.iconTray.getSelection();
        if (dataObj != null) {
            Object[] delBtnLabels = new Object[]{UIRegistry.getResourceString("Delete"), UIRegistry.getResourceString("CANCEL")};
            int rv = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("ASK_DELETE", dataObj.getIdentityTitle()), UIRegistry.getResourceString("Delete"), 0, 3, null, delBtnLabels, delBtnLabels[1]);
            if (rv == 0) {
                this.iconTray.removeItem(dataObj);
                this.parentDataObj.removeReference(dataObj, this.cellName);
                if (this.mvParent != null) {
                    MultiView topLvl = this.mvParent.getTopLevel();
                    topLvl.addDeletedItem(dataObj);
                    this.rootHasChanged();
                }
                this.iconTray.repaint();
                this.updateEnableUI();
                this.rootHasChanged();
            }
        }
    }

    protected void addActionListenerToDeleteButton() {
        this.delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IconViewObj.this.doDelete();
            }
        });
    }

    public int getViewOptions() {
        return this.viewOptions;
    }

    @Override
    public String getName() {
        return "Icon View";
    }

    public int getId() {
        return -1;
    }

    @Override
    public ViewDefIFace.ViewType getType() {
        return this.viewDef.getType();
    }

    @Override
    public synchronized Component getUIComponent() {
        if (this.mainComp == null) {
            this.initMainComp();
        }
        return this.mainComp;
    }

    @Override
    public boolean isSubform() {
        return false;
    }

    @Override
    public <T> T getCompById(String id) {
        return null;
    }

    @Override
    public JLabel getLabelFor(String id) {
        return null;
    }

    @Override
    public Map<String, Component> getControlMapping() {
        return null;
    }

    @Override
    public FormValidator getValidator() {
        return this.validator;
    }

    @Override
    public void setDataObj(Object dataObj) {
        if (AppContextMgr.isSecurityOn() && dataObj != null) {
            if (this.perm == null) {
                String shortClassName = MultiView.getClassNameFromParentMV(this.dataClass, this.mvParent, this.cellName);
                if (StringUtils.isEmpty((String)shortClassName)) {
                    if (this.classToCreate == null) {
                        try {
                            shortClassName = Class.forName(this.view.getClassName()).getSimpleName();
                        }
                        catch (Exception ex) {
                            shortClassName = dataObj.getClass().getSimpleName();
                        }
                    } else {
                        shortClassName = this.classToCreate.getSimpleName();
                    }
                }
                this.perm = SecurityMgr.getInstance().getPermission("DO." + shortClassName.toLowerCase());
            }
            if (this.isEditing && this.perm.isViewOnly() || !this.isEditing && !this.perm.canView()) {
                return;
            }
        }
        if (dataObj instanceof Set) {
            this.dataSet = (Set)dataObj;
        } else {
            if (this.dataSet == null) {
                this.dataSet = new HashSet<Object>();
            } else {
                this.dataSet.clear();
            }
            if (dataObj != null) {
                if (dataObj instanceof List) {
                    this.dataSet.addAll((List)dataObj);
                } else {
                    this.dataSet.add(dataObj);
                }
            }
        }
        this.setDataIntoUI();
    }

    @Override
    public void setRecordSet(RecordSetIFace recordSet) {
    }

    @Override
    public Object getDataObj() {
        return this.dataSet;
    }

    @Override
    public void setParentDataObj(Object parentDataObj) {
        if (parentDataObj != null && !(parentDataObj instanceof FormDataObjIFace)) {
            this.dataTypeError = true;
            return;
        }
        this.parentDataObj = (FormDataObjIFace)parentDataObj;
        this.adjustDataClassName();
    }

    @Override
    public Object getParentDataObj() {
        return this.parentDataObj;
    }

    @Override
    public synchronized void setDataIntoUI() {
        this.ignoreChanges = true;
        if (this.mainComp == null) {
            this.initMainComp();
        }
        this.iconTray.removeAllItems();
        Vector<Object> dataObjects = new Vector<Object>();
        dataObjects.addAll(this.dataSet);
        if (this.orderableDataClass) {
            Vector<Orderable> vector = new Vector<Orderable>();
            for (Object e : dataObjects) {
                if (!(e instanceof Orderable)) continue;
                vector.add((Orderable)e);
            }
            Collections.sort(vector, new OrderableComparator());
            dataObjects.clear();
            dataObjects.addAll(vector);
        }
        for (Object e : dataObjects) {
            if (!(e instanceof FormDataObjIFace)) {
                log.error((Object)"Icon view data set contains non-FormDataObjIFace objects.  Item being ignored.");
                this.mainComp.removeAll();
                JLabel lbl = UIHelper.createLabel(UIRegistry.getResourceString("Error"));
                this.mainComp.add(lbl);
                this.dataTypeError = true;
                return;
            }
            FormDataObjIFace formDataObj = (FormDataObjIFace)e;
            this.iconTray.addItem(formDataObj);
        }
        this.ignoreChanges = false;
    }

    @Override
    public JComponent getControllerPanel() {
        return this.sepController;
    }

    @Override
    public void getDataFromUI() {
        if (this.dataTypeError) {
            return;
        }
        this.dataSet.clear();
        Set<Object> iconTrayItems = this.iconTray.getItems();
        for (Object fdo : iconTrayItems) {
            this.dataSet.add(fdo);
        }
    }

    @Override
    public Object getDataFromUIComp(String name) {
        return null;
    }

    @Override
    public void setDataIntoUIComp(String name, Object data) {
    }

    @Override
    public MultiView getSubView(String name) {
        return null;
    }

    @Override
    public void getFieldIds(List<String> fieldIds) {
    }

    @Override
    public void getFieldNames(List<String> fieldNames) {
    }

    @Override
    public void aboutToShow(boolean show) {
        if (this.switcherUI != null) {
            this.switcherUI.set(this.altView);
        }
        if (!show) {
            this.iconTray.setSelectedIndex(-1);
        }
    }

    @Override
    public ViewIFace getView() {
        return this.view;
    }

    @Override
    public FormViewDef getViewDef() {
        return (FormViewDef)this.altView.getViewDef();
    }

    @Override
    public AltViewIFace getAltView() {
        return this.altView;
    }

    @Override
    public void hideMultiViewSwitch(boolean hide) {
    }

    @Override
    public void enableMultiViewSwitch(boolean enabled) {
        if (this.switcherUI != null) {
            this.switcherUI.setEnabled(enabled);
        }
    }

    @Override
    public void validationWasOK(boolean wasOK) {
    }

    @Override
    public void setSession(DataProviderSessionIFace session) {
        this.session = session;
    }

    @Override
    public void setHasNewData(boolean isNewForm) {
    }

    protected void adjustDataClassName() {
        if (this.parentDataObj == null) {
            this.dataClassName = this.viewDef.getClassName();
        } else {
            DBTableInfo parentTI = DBTableIdMgr.getInstance().getByClassName(this.parentDataObj.getClass().getName());
            DBRelationshipInfo rel = parentTI.getRelationshipByName(this.cellName);
            this.dataClassName = rel.getClassName();
        }
        this.checkOrderableness();
    }

    @Override
    public void setCellName(String cellName) {
        this.cellName = cellName;
        this.dataSetFieldName = cellName;
        this.adjustDataClassName();
    }

    @Override
    public void registerSaveBtn(JButton saveBtn) {
    }

    @Override
    public void updateSaveBtn() {
    }

    @Override
    public void focus() {
    }

    @Override
    public void aboutToShutdown() {
        if (this.businessRules != null) {
            this.businessRules.aboutToShutdown();
        }
    }

    @Override
    public void shutdown() {
        this.mvParent = null;
        this.mainComp = null;
        if (this.businessRules != null) {
            this.businessRules.formShutdown();
            this.businessRules = null;
        }
    }

    @Override
    public JComponent getSaveComponent() {
        return null;
    }

    @Override
    public void setSkippingAttach(boolean isSkippingAttach) {
        this.isSkippingAttach = isSkippingAttach;
    }

    public class IconViewActionEvent
    extends ActionEvent {
        protected IconViewObj icIconViewObj;

        public IconViewActionEvent(Object source, int id, String command, IconViewObj icIconViewObj) {
            super(source, id, command);
            this.icIconViewObj = icIconViewObj;
        }

        public AltViewIFace getAltView() {
            return this.icIconViewObj.getAltView();
        }

        public IconViewObj getIconViewObj() {
            return this.icIconViewObj;
        }

        public ViewIFace getView() {
            return this.icIconViewObj.getView();
        }

        public ViewDefIFace getViewDef() {
            return this.icIconViewObj.getViewDef();
        }
    }
}

