/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectGettableFactory;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.DataObjectSettableFactory;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.FieldNotebook;
import edu.ku.brc.specify.datamodel.FieldNotebookPage;
import edu.ku.brc.specify.datamodel.FieldNotebookPageSet;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class FormHelper {
    private static final Logger log = Logger.getLogger(FormHelper.class);
    private static String currentUserEditStr = "";
    public static final String DATA_OBJ_SETTER = "edu.ku.brc.af.ui.forms.DataSetterForObj";
    public static final String DATA_OBJ_GETTER = "edu.ku.brc.af.ui.forms.DataGetterForObj";

    public static boolean updateLastEdittedInfo(Object dataObj) {
        return FormHelper.updateLastEdittedInfo(dataObj, false);
    }

    public static boolean updateLastEdittedInfo(Object dataObj, boolean doCreatedTime) {
        log.debug((Object)("updateLastEdittedInfo for [" + (dataObj != null ? dataObj.getClass() : "dataObj was null") + "]"));
        if (dataObj != null) {
            if (dataObj instanceof Collection) {
                boolean retVal = false;
                for (Object o : (Collection)dataObj) {
                    if (!FormHelper.updateLastEdittedInfo(o)) continue;
                    retVal = true;
                }
                return retVal;
            }
            try {
                DataObjectSettable setter = DataObjectSettableFactory.get(dataObj.getClass().getName(), DATA_OBJ_SETTER);
                if (setter != null) {
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    boolean foundOne = false;
                    PropertyDescriptor descr = PropertyUtils.getPropertyDescriptor((Object)dataObj, (String)"timestampModified");
                    if (descr != null) {
                        setter.setFieldValue(dataObj, "timestampModified", timestamp);
                        foundOne = true;
                    }
                    if (doCreatedTime && (descr = PropertyUtils.getPropertyDescriptor((Object)dataObj, (String)"timestampCreated")) != null) {
                        setter.setFieldValue(dataObj, "timestampCreated", timestamp);
                        foundOne = true;
                    }
                    if ((descr = PropertyUtils.getPropertyDescriptor((Object)dataObj, (String)"modifiedByAgent")) != null) {
                        setter.setFieldValue(dataObj, "modifiedByAgent", Agent.getUserAgent());
                        foundOne = true;
                    }
                    return foundOne;
                }
            }
            catch (NoSuchMethodException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormHelper.class, ex);
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormHelper.class, ex);
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormHelper.class, ex);
                ex.printStackTrace();
            }
        }
        log.debug((Object)"updateLastEdittedInfo object is NULL");
        return false;
    }

    public static FormDataObjIFace createAndNewDataObj(Class<?> newDataClass) {
        return FormHelper.createAndNewDataObj(newDataClass, null);
    }

    public static FormDataObjIFace createAndNewDataObj(Class<?> newDataClass, BusinessRulesIFace busRules) {
        return FormHelper.createAndNewDataObj(newDataClass, null, busRules);
    }

    public static FormDataObjIFace createAndNewDataObj(Class<?> newDataClass, Boolean overrideAddKids, BusinessRulesIFace busRules) {
        try {
            BusinessRulesIFace br;
            FormDataObjIFace formDataObj = (FormDataObjIFace)newDataClass.newInstance();
            formDataObj.initialize();
            BusinessRulesIFace businessRulesIFace = br = busRules != null ? busRules : DBTableIdMgr.getInstance().getBusinessRule(newDataClass);
            if ((overrideAddKids != null && overrideAddKids.booleanValue() || overrideAddKids == null) && br != null) {
                br.addChildrenToNewDataObjects(formDataObj);
            }
            CommandDispatcher.dispatch(new CommandAction("Data", "NewObjDataCreated", formDataObj));
            return formDataObj;
        }
        catch (IllegalAccessException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
            ex.printStackTrace();
        }
        return null;
    }

    public static FormDataObjIFace createAndNewDataObj(String newDataClassName) {
        return FormHelper.createAndNewDataObj(newDataClassName, null);
    }

    public static FormDataObjIFace createAndNewDataObj(String newDataClassName, BusinessRulesIFace busRules) {
        return FormHelper.createAndNewDataObj(newDataClassName, null, busRules);
    }

    public static FormDataObjIFace createAndNewDataObj(String newDataClassName, Boolean overrideAddKids, BusinessRulesIFace busRules) {
        try {
            return FormHelper.createAndNewDataObj(Class.forName(newDataClassName).asSubclass(FormDataObjIFace.class), overrideAddKids, busRules);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
            return null;
        }
    }

    public static boolean initForSearch(Object dataObj) {
        try {
            Method method = dataObj.getClass().getMethod("initForSearch", new Class[0]);
            method.invoke(dataObj, new Object[0]);
            return true;
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
        }
        return false;
    }

    public static boolean initAndAddToParent(Object parentDataObj, FormDataObjIFace newDataObj) {
        newDataObj.initialize();
        if (parentDataObj != null) {
            return FormHelper.addToParent(parentDataObj, newDataObj);
        }
        return true;
    }

    public static boolean addToParent(Object parentDataObj, Object newDataObj) {
        if (parentDataObj != null) {
            try {
                String methodName = "add" + newDataObj.getClass().getSimpleName();
                log.debug((Object)("Invoking method[" + methodName + "] on Object " + parentDataObj.getClass().getSimpleName()));
                Method method = parentDataObj.getClass().getMethod(methodName, newDataObj.getClass());
                method.invoke(parentDataObj, newDataObj);
                log.debug((Object)("Adding [" + newDataObj + "] to parent Set[" + parentDataObj + "]"));
                return true;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormHelper.class, ex);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormHelper.class, ex);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormHelper.class, ex);
            }
        } else {
            log.error((Object)"parentDataObj was null");
        }
        return false;
    }

    public static Integer getId(Object dbDataObj) {
        try {
            Method method = dbDataObj.getClass().getMethod("getId", new Class[0]);
            return (Integer)method.invoke(dbDataObj, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormHelper.class, ex);
        }
        return null;
    }

    public static String getCurrentUserEditStr() {
        return currentUserEditStr;
    }

    public static void setCurrentUserEditStr(String currentUserEditStr) {
        FormHelper.currentUserEditStr = currentUserEditStr;
    }

    public static void setFieldValue(String fieldNames, Object dataObj, Object newData, DataObjectGettable getter, DataObjectSettable setter) {
        if (StringUtils.isNotEmpty((String)fieldNames)) {
            if (setter.usesDotNotation()) {
                int inx = fieldNames.indexOf(".");
                if (inx > -1) {
                    String[] fileNameArray = StringUtils.split((String)fieldNames, (char)'.');
                    Object data = dataObj;
                    int i = 0;
                    while (i < fileNameArray.length) {
                        String fieldName = fileNameArray[i];
                        if (i < fileNameArray.length - 1) {
                            if ((data = getter.getFieldValue(data, fieldName)) == null) {
                                try {
                                    PropertyDescriptor descr = PropertyUtils.getPropertyDescriptor((Object)dataObj, (String)fieldName.trim());
                                    Class<?> classObj = descr.getPropertyType();
                                    Object newObj = classObj.newInstance();
                                    if (newObj != null) {
                                        Method method = newObj.getClass().getMethod("initialize", new Class[0]);
                                        method.invoke(newObj, new Object[0]);
                                        setter.setFieldValue(dataObj, fieldName, newObj);
                                        data = newObj;
                                    }
                                }
                                catch (NoSuchMethodException ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(FormHelper.class, ex);
                                }
                                catch (IllegalAccessException ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(FormHelper.class, ex);
                                }
                                catch (InvocationTargetException ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(FormHelper.class, ex);
                                }
                                catch (InstantiationException ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(FormHelper.class, ex);
                                }
                            }
                        } else {
                            setter.setFieldValue(data, fieldName, newData);
                        }
                        ++i;
                    }
                } else {
                    setter.setFieldValue(dataObj, fieldNames, newData);
                }
            } else {
                setter.setFieldValue(dataObj, fieldNames, newData);
            }
        }
    }

    public static Object getValue(FormDataObjIFace dataObj, String fieldName) {
        if (dataObj != null) {
            DataObjectGettable getter = DataObjectGettableFactory.get(dataObj.getDataClass().getName(), DATA_OBJ_GETTER);
            if (getter != null) {
                return getter.getFieldValue(dataObj, fieldName);
            }
            throw new RuntimeException("Could get a getter for FormDataObjIFace [" + dataObj.getDataClass().getName() + "]");
        }
        return null;
    }

    public static void setValue(FormDataObjIFace dataObj, String fieldName, Object value) {
        if (dataObj != null) {
            DataObjectSettable setter = DataObjectSettableFactory.get(dataObj.getDataClass().getName(), DATA_OBJ_SETTER);
            if (setter != null) {
                setter.setFieldValue(dataObj, fieldName, value);
            } else {
                throw new RuntimeException("Could get a setter for FormDataObjIFace [" + dataObj.getDataClass().getName() + "]");
            }
        }
    }

    public static DBTableChildIFace getChildInfoFromPath(String fieldName, DBTableInfo tblInfo) {
        String[] names = StringUtils.split((String)fieldName, (char)'.');
        DBTableInfo curTblInfo = tblInfo;
        int cnt = 0;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (cnt == 0 && name.equals(tblInfo.getName())) {
                ++cnt;
            } else {
                DBTableInfo nxtTbl;
                DBTableChildIFace item = curTblInfo.getItemByName(name);
                if (item == null) {
                    return null;
                }
                if (cnt == names.length - 1) {
                    return item;
                }
                if (item instanceof DBRelationshipInfo) {
                    DBRelationshipInfo rel = (DBRelationshipInfo)item;
                    nxtTbl = DBTableIdMgr.getInstance().getByClassName(rel.getClassName());
                    if (nxtTbl == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                curTblInfo = nxtTbl;
                ++cnt;
            }
            ++n2;
        }
        return null;
    }

    public static ViewBasedDisplayIFace createDataObjectDialog(JComponent mainComp, FormDataObjIFace dataObj, boolean isEditMode, boolean isNewObject) {
        DBTableInfo setTI = DBTableIdMgr.getInstance().getByClassName(dataObj.getClass().getName());
        String defFormName = setTI.getEditObjDialog();
        if (StringUtils.isNotEmpty((String)defFormName)) {
            int opts = (isNewObject ? 4 : 0) | 8;
            String title = isNewObject && isEditMode ? UIRegistry.getResourceString("EDIT") : dataObj.getIdentityTitle();
            ViewBasedDisplayIFace dialog = UIRegistry.getViewbasedFactory().createDisplay(UIHelper.getWindow(mainComp), defFormName, title, UIRegistry.getResourceString(isEditMode ? "ACCEPT" : "CLOSE"), isEditMode, opts &= 0xFFFFFFFE, null, ViewBasedDialogFactoryIFace.FRAME_TYPE.DIALOG);
            return dialog;
        }
        log.error((Object)("The Default Form Name is empty for Object type [" + dataObj.getClass().getName() + "] (Check the 'newobjdlg' value in the 'display' node in the file specify_tableid_listing.xml (and specify_datamodel.xml))"));
        return null;
    }

    public static String checkForRestrictedValue(Object dataObj) {
        if (AppContextMgr.isSecurityOn() && dataObj != null && dataObj instanceof FormDataObjIFace) {
            return FormHelper.checkForRestrictedValue(DBTableIdMgr.getInstance().getByShortClassName(dataObj.getClass().getSimpleName()));
        }
        return null;
    }

    public static String checkForRestrictedValue(int tableId) {
        if (AppContextMgr.isSecurityOn()) {
            return FormHelper.checkForRestrictedValue(DBTableIdMgr.getInstance().getInfoById(tableId));
        }
        return null;
    }

    public static String checkForRestrictedValue(DBTableInfo tblInfo) {
        PermissionSettings perm;
        if (tblInfo != null && (perm = tblInfo.getPermissions()) != null && !perm.canView()) {
            return UIRegistry.getResourceString("RESTRICTED");
        }
        return null;
    }

    public static void dumpDataObj(DataProviderSessionIFace session, Object dataObj, Hashtable<Class<?>, Boolean> clsHash, int level) {
        if (dataObj == null || clsHash.get(dataObj.getClass()) != null) {
            return;
        }
        String clsName = dataObj.getClass().toString();
        if (clsName.indexOf("CGLIB") > -1) {
            return;
        }
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < level) {
            indent.append("  ");
            ++i;
        }
        Method[] methodArray = dataObj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.startsWith("get") && method.getModifiers() != 9) {
                String fieldName = String.valueOf(methodName.substring(3, 4).toLowerCase()) + methodName.substring(4, methodName.length());
                Object kidData = null;
                try {
                    kidData = FormHelper.getValue((FormDataObjIFace)dataObj, fieldName);
                }
                catch (Exception ex) {
                    System.out.println(indent + fieldName + " = <no data>");
                }
                if (kidData != null) {
                    if (kidData instanceof Set) {
                        for (Object obj : (Set)kidData) {
                            System.out.println(indent + fieldName + " = " + obj);
                            if (!(obj instanceof FormDataObjIFace)) continue;
                            FormHelper.dumpDataObj(session, obj, clsHash, level + 1);
                        }
                    } else {
                        System.out.println(indent + fieldName + " = " + kidData);
                        if (kidData instanceof FormDataObjIFace) {
                            session.attach(kidData);
                            FormHelper.dumpDataObj(session, kidData, clsHash, level + 1);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static void dumpFieldNotebook(String msg, FieldNotebook fn) {
        System.out.println("-----------" + msg + "---------------\n" + fn.getName());
        for (FieldNotebookPageSet ps : fn.getPageSets()) {
            System.out.println("    " + ps.getStartDate());
            for (FieldNotebookPage p : ps.getPages()) {
                System.out.println("        " + p.getPageNumber());
            }
        }
    }
}

