/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellSubViewIFace;
import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValidationListener;
import edu.ku.brc.ui.GetSetValueIFace;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang.NotImplementedException;

public class EditViewCompSwitcherPanel
extends JPanel
implements GetSetValueIFace,
UIValidatable,
DataChangeListener,
ValidationListener {
    protected Component editComp;
    protected Component viewComp;
    protected Component currentComp;
    protected FormCellIFace formCell;
    protected String currentCard;
    protected Object dataObj;
    protected UIValidatable uiVal;
    protected DataChangeNotifier dataChangeNotifier;
    protected CardLayout cardLayout = new CardLayout();
    protected FormValidator validator = null;
    protected FormValidator parentValidator = null;

    public EditViewCompSwitcherPanel(FormCellIFace formCell) {
        this.formCell = formCell;
        this.setLayout(this.cardLayout);
        this.validator = new FormValidator(null);
        this.validator.addValidationListener(this);
        this.validator.setName(formCell.getType().name());
    }

    public void setParentValidator(FormValidator parentValidator) {
        this.parentValidator = parentValidator;
    }

    public void setDataChangeNotifier(DataChangeNotifier dataChangeNotifier) {
        this.dataChangeNotifier = dataChangeNotifier;
    }

    public FormValidator getValidator() {
        return this.validator;
    }

    @Override
    public boolean isNotEmpty() {
        throw new NotImplementedException("isNotEmpty not implement!");
    }

    public void putIntoEditMode() {
        this.currentCard = "Edit";
        this.cardLayout.show(this, this.currentCard);
        this.currentComp = this.editComp;
        this.repaint();
    }

    public void putIntoViewMode() {
        this.currentCard = "View";
        this.cardLayout.show(this, this.currentCard);
        this.currentComp = this.viewComp;
        this.repaint();
    }

    public void set(Component editCmpReg, Component editCmpAdd, Component viewCmpReg, Component viewCmpAdd) {
        this.editComp = this.register("Edit", editCmpAdd, editCmpReg);
        this.viewComp = this.register("View", viewCmpAdd, viewCmpReg);
        this.uiVal = this.editComp instanceof UIValidatable ? (UIValidatable)((Object)this.editComp) : null;
        this.currentComp = this.editComp;
    }

    protected Component register(String name, Component compToAdd, Component compToReg) {
        Component comp;
        Component control;
        this.add(name, compToAdd);
        Component component = control = compToReg == null ? compToAdd : compToReg;
        if (control instanceof JScrollPane) {
            JScrollPane scrPane = (JScrollPane)control;
            comp = scrPane.getViewport().getView();
        } else {
            Object scrPane = null;
            comp = control;
        }
        return comp;
    }

    public Component getCurrentComp() {
        return this.currentComp;
    }

    public Component getComp(boolean isEditComp) {
        return isEditComp ? this.editComp : this.viewComp;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setEnabled(enabled);
            ++i;
        }
        this.validator.setEnabled(enabled);
    }

    @Override
    public Object getValue() {
        if (this.currentComp == this.viewComp) {
            return this.dataObj;
        }
        boolean isSingleValueFromSet = false;
        if (this.formCell instanceof FormCellSubViewIFace) {
            isSingleValueFromSet = ((FormCellSubViewIFace)this.formCell).isSingleValueFromSet();
        }
        return FormViewObj.getValueFromComponent(this.editComp, isSingleValueFromSet, this.formCell.getType() == FormCellIFace.CellType.command, this.currentCard);
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.dataObj = value;
        FormViewObj.setDataIntoUIComp(this.editComp, value, defaultValue);
        FormViewObj.setDataIntoUIComp(this.viewComp, value, defaultValue);
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void cleanUp() {
        this.dataObj = null;
        if (this.dataChangeNotifier != null) {
            this.dataChangeNotifier.cleanUp();
            this.dataChangeNotifier = null;
        }
        if (this.validator != null) {
            this.validator.removeValidationListener(this);
            this.validator = null;
        }
        this.parentValidator = null;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        if (this.currentComp == this.viewComp) {
            return UIValidatable.ErrorType.Valid;
        }
        return this.uiVal != null ? this.uiVal.getState() : UIValidatable.ErrorType.Valid;
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public boolean isChanged() {
        if (this.currentComp == this.viewComp) {
            return false;
        }
        return this.uiVal != null ? this.uiVal.isChanged() : false;
    }

    @Override
    public boolean isInError() {
        if (this.currentComp == this.viewComp) {
            return false;
        }
        return this.uiVal != null ? this.uiVal.isInError() : false;
    }

    @Override
    public boolean isRequired() {
        if (this.currentComp == this.viewComp) {
            return false;
        }
        return this.uiVal != null ? this.uiVal.isRequired() : false;
    }

    @Override
    public void reset() {
        if (this.uiVal != null) {
            this.uiVal.reset();
        }
    }

    @Override
    public void setAsNew(boolean isNew) {
        if (this.currentComp == this.editComp && this.uiVal != null) {
            this.uiVal.setAsNew(isNew);
        }
    }

    @Override
    public void setChanged(boolean isChanged) {
        if (this.currentComp == this.editComp && this.uiVal != null) {
            this.uiVal.setChanged(isChanged);
        }
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (this.currentComp == this.editComp && this.uiVal != null) {
            this.uiVal.setRequired(isRequired);
        }
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        if (this.currentComp == this.editComp && this.uiVal != null) {
            this.uiVal.setState(state);
        }
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        if (this.currentComp == this.viewComp) {
            return UIValidatable.ErrorType.Valid;
        }
        return this.uiVal != null ? this.uiVal.validateState() : UIValidatable.ErrorType.Valid;
    }

    @Override
    public void dataChanged(String name, Component comp, DataChangeNotifier dcn) {
        if (dcn != null) {
            dcn.actionPerformed(null);
        }
    }

    @Override
    public void wasValidated(UIValidator validatorArg) {
        if (this.parentValidator != null) {
            this.dataChangeNotifier.actionPerformed(null);
        }
    }
}

