/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class DraggableRecordIdentifierFactory {
    private static final Logger log = Logger.getLogger(DraggableRecordIdentifierFactory.class);
    private static final String className = "edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory";
    protected static DraggableRecordIdentifierFactory instance = null;

    protected DraggableRecordIdentifierFactory() {
    }

    public DraggableRecordIdentifier createDraggableRecordIdentifier(ImageIcon icon) {
        return new DraggableRecordIdentifier(icon);
    }

    public static DraggableRecordIdentifierFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(DraggableRecordIdentifierFactory.className);
            }
        });
        if (factoryName != null && !className.equals(factoryName)) {
            try {
                instance = (DraggableRecordIdentifierFactory)Class.forName(factoryName).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DraggableRecordIdentifierFactory.class, e);
                log.error((Object)e);
                InternalError error = new InternalError("Can't instantiate DraggableRecordIdentifierFactory factory " + factoryName);
                error.initCause(e);
                throw error;
            }
        }
        instance = new DraggableRecordIdentifierFactory();
        return null;
    }
}

