/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import edu.ku.brc.ui.dnd.ShadowFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class DraggableRecordIdentifier
extends JComponent
implements GhostActionable {
    public static final DataFlavor DATAOBJREP_FLAVOR = new DataFlavor(DraggableRecordIdentifier.class, "DraggableRecordIdentifier");
    protected static final int SHADOW_SIZE = 10;
    protected ImageIcon imgIcon;
    protected String label = "";
    protected BufferedImage sizeBufImg = null;
    protected Dimension preferredSize = new Dimension(0, 0);
    protected GhostMouseInputAdapter mouseInputAdapter = null;
    protected RenderingHints hints = UIHelper.createTextRenderingHints();
    protected BufferedImage shadowBuffer = null;
    protected BufferedImage buffer = null;
    protected boolean generateImgBuf = true;
    protected Dimension prefferedRenderSize = new Dimension(0, 0);
    protected boolean verticalLayout = false;
    protected Color textColor = new Color(0, 0, 0, 90);
    protected Font textFont = null;
    protected Object data = null;
    protected FormDataObjIFace formDataObj = null;
    protected List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();
    protected List<DataFlavor> dragFlavors = new ArrayList<DataFlavor>();

    public DraggableRecordIdentifier(ImageIcon icon, String label) {
        this.imgIcon = icon;
        this.label = label;
        this.createMouseInputAdapter();
        this.setData(null);
    }

    public DraggableRecordIdentifier(ImageIcon icon) {
        this(icon, null);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.imgIcon != null && this.imgIcon.getImage() != null) {
            g.drawImage(this.imgIcon.getImage(), 0, 0, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.calcPreferredSize();
        return new Dimension(this.preferredSize);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label == null || this.label == null || !this.label.equals(label)) {
            this.generateImgBuf = true;
        }
        this.label = label;
    }

    protected void calcPreferredSize() {
        if (this.sizeBufImg == null || this.generateImgBuf) {
            int strHeight;
            Insets ins = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
            this.sizeBufImg = new BufferedImage(1, 1, 2);
            Graphics2D g = this.sizeBufImg.createGraphics();
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            int strWidth = this.label != null ? fm.stringWidth(this.label) : 0;
            int n = strHeight = this.label != null ? fm.getHeight() : 0;
            if (this.verticalLayout) {
                this.preferredSize.width = ins.left + ins.right + insets.left + insets.right + Math.max(strWidth, this.imgIcon != null ? this.imgIcon.getIconWidth() + 2 : 0);
                this.preferredSize.height = ins.top + ins.bottom + insets.top + insets.bottom + strHeight + (this.imgIcon != null ? this.imgIcon.getIconHeight() + 2 : 0);
            } else {
                this.preferredSize.width = ins.left + ins.right + insets.left + insets.right + (strWidth + 2) + (this.imgIcon != null ? this.imgIcon.getIconWidth() : 0);
                this.preferredSize.height = ins.top + ins.bottom + insets.top + insets.bottom + Math.max(fm.getHeight(), this.imgIcon != null ? this.imgIcon.getIconHeight() + 2 : 0);
            }
        }
    }

    public FormDataObjIFace getFormDataObj() {
        return this.formDataObj;
    }

    public void setFormDataObj(FormDataObjIFace formDataObj) {
        if (this.formDataObj != formDataObj) {
            this.formDataObj = formDataObj;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.formDataObj != null && super.isEnabled();
    }

    @Override
    public void doAction(GhostActionable src) {
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return UIHelper.getDataForClass(this.data, classObj);
    }

    @Override
    public void createMouseInputAdapter() {
        this.mouseInputAdapter = new GhostMouseInputAdapter(UIRegistry.getGlassPane(), "action", this);
        this.addMouseListener(this.mouseInputAdapter);
        this.addMouseMotionListener(this.mouseInputAdapter);
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return this.mouseInputAdapter;
    }

    @Override
    public void setActive(boolean isActive) {
    }

    public int getItemWidth() {
        return this.getPreferredSize().width + 10;
    }

    public int getItemHeight() {
        return this.getPreferredSize().height;
    }

    private void renderOffscreen() {
        BufferedImage bgBufImg = this.getBackgroundImageBuffer();
        this.buffer = new BufferedImage(bgBufImg.getWidth(), bgBufImg.getHeight(), 2);
        int shadowWidth = bgBufImg.getWidth() - this.getItemWidth();
        int shadowHeight = bgBufImg.getHeight() - this.getItemHeight();
        int left = (int)((double)shadowWidth * 0.5);
        int top = (int)((double)shadowHeight * 0.4);
        int width = this.getItemWidth() - 2;
        int height = this.getItemHeight() - 2;
        Graphics2D g2 = this.buffer.createGraphics();
        g2.setRenderingHints(this.hints);
        g2.drawImage(bgBufImg, 0, 0, bgBufImg.getWidth(), bgBufImg.getHeight(), null);
        g2.fillRect(left, top, width, height);
        g2.setClip(left, top, width, height);
        g2.drawImage(this.imgIcon.getImage(), left + 1, top + (height - this.imgIcon.getIconHeight()) / 2, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
        g2.setFont(this.getFont());
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(Color.BLACK);
        g2.drawString(this.label, left + 1 + this.imgIcon.getIconWidth() + 1, top + (height - fm.getHeight()) / 2 + fm.getAscent());
        g2.dispose();
        this.generateImgBuf = false;
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.buffer == null || this.generateImgBuf) {
            this.renderOffscreen();
        }
        return this.buffer;
    }

    private BufferedImage getBackgroundImageBuffer() {
        if (this.shadowBuffer == null || this.generateImgBuf) {
            ShadowFactory factory = new ShadowFactory(10, 0.17f, Color.BLACK);
            BufferedImage image = new BufferedImage(this.getItemWidth(), this.getItemHeight(), 2);
            Graphics2D g2 = image.createGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.dispose();
            this.shadowBuffer = factory.createShadow(image);
        }
        return this.shadowBuffer;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return this.dragFlavors;
    }
}

