/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class DefaultFormFieldValueFactory {
    public static final String factoryName = "edu.ku.brc.ui.forms.DefaultFormFieldValueFactory";
    protected static DefaultFormFieldValueFactory instance = null;

    public abstract Object getValueFor(DBFieldInfo var1);

    public static DefaultFormFieldValueFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(DefaultFormFieldValueFactory.factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = (DefaultFormFieldValueFactory)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DefaultFormFieldValueFactory.class, e);
                InternalError error = new InternalError("Can't instantiate DefaultFormFieldValueFactory factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }
}

