/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.util.Hashtable;

public class DataObjectSettableFactory {
    protected static final DataObjectSettableFactory instance = new DataObjectSettableFactory();
    protected Hashtable<String, Hashtable<String, DataObjectSettable>> hashTable = new Hashtable();

    protected DataObjectSettableFactory() {
    }

    public static DataObjectSettable get(String settableClassName, String className) {
        DataObjectSettable dataSettable;
        if (className == null || className.length() == 0) {
            return null;
        }
        Hashtable<String, DataObjectSettable> settableHash = DataObjectSettableFactory.instance.hashTable.get(settableClassName);
        if (settableHash == null) {
            settableHash = new Hashtable();
            DataObjectSettableFactory.instance.hashTable.put(settableClassName, settableHash);
        }
        if ((dataSettable = settableHash.get(className)) == null) {
            try {
                dataSettable = (DataObjectSettable)Class.forName(className).newInstance();
                settableHash.put(className, dataSettable);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataObjectSettableFactory.class, ex);
                System.err.println("Unable to create class[" + className + "]");
                ex.printStackTrace();
            }
        }
        return dataSettable;
    }
}

