/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.hibernate.LazyInitializationException;
import org.hibernate.collection.PersistentSet;

public class DataGetterForObj
implements DataObjectGettable {
    private static final Logger log = Logger.getLogger(DataGetterForObj.class);
    private boolean showErrors = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getFieldValue(Object dataObjArg, String fieldName) {
        Object dataObj = dataObjArg;
        Object value = null;
        if (dataObj == null) return value;
        try {
            Iterator iter = null;
            if (dataObj instanceof Set) {
                iter = ((Set)dataObj).iterator();
            } else if (dataObj instanceof PersistentSet) {
                iter = ((PersistentSet)dataObj).iterator();
            }
            if (iter != null) {
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof AttributeIFace) {
                        boolean bl;
                        AttributeIFace asg = (AttributeIFace)obj;
                        if (!asg.getDefinition().getFieldName().equals(fieldName)) continue;
                        if (asg.getDefinition().getDataType().shortValue() == AttributeIFace.FieldType.StringType.getType()) {
                            return asg.getStrValue();
                        }
                        if (asg.getDefinition().getDataType().shortValue() == AttributeIFace.FieldType.IntegerType.getType()) {
                            return asg.getDblValue().intValue();
                        }
                        if (asg.getDefinition().getDataType().shortValue() == AttributeIFace.FieldType.FloatType.getType()) {
                            return Float.valueOf(asg.getDblValue().floatValue());
                        }
                        if (asg.getDefinition().getDataType().shortValue() == AttributeIFace.FieldType.DoubleType.getType()) {
                            return asg.getDblValue();
                        }
                        if (asg.getDefinition().getDataType().shortValue() != AttributeIFace.FieldType.BooleanType.getType()) continue;
                        if (asg.getDblValue() != 0.0) {
                            bl = true;
                            return new Boolean(bl);
                        }
                        bl = false;
                        return new Boolean(bl);
                    }
                    if (!(obj instanceof FormDataObjIFace)) return null;
                    dataObj = obj;
                    break;
                }
            }
            if (fieldName.startsWith("@get")) {
                try {
                    String methodName = fieldName.substring(1, fieldName.length()).trim();
                    Method method = dataObj.getClass().getMethod(methodName, new Class[0]);
                    if (method == null) return value;
                    return method.invoke(dataObj, new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DataGetterForObj.class, ex);
                    return value;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DataGetterForObj.class, ex);
                    return value;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DataGetterForObj.class, ex);
                    return value;
                }
            }
            PropertyDescriptor descr = PropertyUtils.getPropertyDescriptor((Object)dataObj, (String)fieldName.trim());
            if (descr != null) {
                Method getter = PropertyUtils.getReadMethod((PropertyDescriptor)descr);
                if (getter == null) return value;
                return getter.invoke(dataObj, null);
            }
            if (!this.showErrors) return value;
            log.error((Object)("We could not find a field named[" + fieldName.trim() + "] in data object [" + dataObj.getClass().toString() + "]"));
            return value;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            if (ex instanceof LazyInitializationException) return value;
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataGetterForObj.class, ex);
        }
        return value;
    }

    @Override
    public boolean usesDotNotation() {
        return true;
    }

    public String makeToString(Object obj) {
        this.showErrors = false;
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = obj.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Object val = this.getFieldValue(obj, field.getName());
            sb.append(field.getName());
            sb.append("=");
            sb.append(val);
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }
}

