/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ControlBarPanel
extends JPanel {
    protected PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,f:p:g,2px,p", "p"), (JPanel)this);
    protected JPanel leftSidePanel = null;
    protected JPanel rightSidePanel = null;
    protected ResultSetController recordSetController;

    public ControlBarPanel(Color bgColor) {
        this.setBackground(bgColor);
        this.setOpaque(false);
    }

    public void setRecordSetController(ResultSetController recordSetController) {
        this.recordSetController = recordSetController;
    }

    public void addController(JComponent comp) {
        CellConstraints cc = new CellConstraints();
        this.builder.add((Component)comp, cc.xy(3, 1));
    }

    public void addButtons(JButton[] btns, boolean onLeftSide) {
        CellConstraints cc = new CellConstraints();
        JPanel panel = ButtonBarFactory.buildGrowingBar((JButton[])btns);
        panel.setBackground(this.getBackground());
        panel.setOpaque(false);
        if (onLeftSide) {
            if (this.leftSidePanel != null) {
                this.remove(this.leftSidePanel);
            }
            this.leftSidePanel = panel;
            this.builder.add((Component)this.leftSidePanel, cc.xy(1, 1));
            if (this.rightSidePanel == null) {
                this.rightSidePanel = new JPanel();
                this.rightSidePanel.setLayout(new BoxLayout(this.rightSidePanel, 0));
                this.rightSidePanel.add(Box.createRigidArea(this.leftSidePanel.getPreferredSize()));
                this.builder.add((Component)this.rightSidePanel, cc.xy(5, 1));
                this.rightSidePanel.setOpaque(false);
            }
        } else {
            if (this.rightSidePanel != null) {
                this.remove(this.rightSidePanel);
            }
            this.rightSidePanel = panel;
            this.builder.add((Component)this.rightSidePanel, cc.xy(5, 1));
            if (this.leftSidePanel == null) {
                this.leftSidePanel = new JPanel();
                this.leftSidePanel.setLayout(new BoxLayout(this.leftSidePanel, 0));
                this.leftSidePanel.add(Box.createRigidArea(this.rightSidePanel.getPreferredSize()));
                this.builder.add((Component)this.leftSidePanel, cc.xy(1, 1));
                this.leftSidePanel.setOpaque(false);
            }
        }
    }

    public void addComponents(List<JComponent> compsList, boolean onLeftSide) {
        if (compsList != null && compsList.size() > 0) {
            CellConstraints cc = new CellConstraints();
            String colsDef = compsList.size() == 1 ? "p" : UIHelper.createDuplicateJGoodiesDef("p", "2px", compsList.size());
            PanelBuilder pBuilder = new PanelBuilder(new FormLayout(colsDef, "p"));
            int i = 0;
            while (i < compsList.size()) {
                pBuilder.add((Component)compsList.get(i), cc.xy(i * 2 + 1, 1));
                ++i;
            }
            if (onLeftSide) {
                if (this.leftSidePanel != null) {
                    this.remove(this.leftSidePanel);
                }
                this.leftSidePanel = pBuilder.getPanel();
                this.builder.add((Component)this.leftSidePanel, cc.xy(1, 1));
                if (this.rightSidePanel == null) {
                    this.rightSidePanel = new JPanel();
                    this.rightSidePanel.setLayout(new BoxLayout(this.rightSidePanel, 0));
                    this.rightSidePanel.add(Box.createRigidArea(this.leftSidePanel.getPreferredSize()));
                    this.builder.add((Component)this.rightSidePanel, cc.xy(5, 1));
                }
            } else {
                if (this.rightSidePanel != null) {
                    this.remove(this.rightSidePanel);
                }
                this.rightSidePanel = pBuilder.getPanel();
                this.rightSidePanel.validate();
                this.rightSidePanel.doLayout();
                this.builder.add((Component)this.rightSidePanel, cc.xy(5, 1));
                if (this.leftSidePanel == null) {
                    this.leftSidePanel = new JPanel();
                    this.leftSidePanel.setLayout(new BoxLayout(this.leftSidePanel, 0));
                    this.leftSidePanel.add(Box.createRigidArea(this.rightSidePanel.getPreferredSize()));
                    this.builder.add((Component)this.leftSidePanel, cc.xy(1, 1));
                }
            }
        }
        if (this.leftSidePanel != null) {
            this.leftSidePanel.setBackground(this.getBackground());
        }
        if (this.rightSidePanel != null) {
            this.rightSidePanel.setBackground(this.getBackground());
        }
    }

    public void setRSCVisibility(boolean vis) {
        if (this.recordSetController != null) {
            this.recordSetController.getPanel().setVisible(vis);
        }
    }
}

