/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CollapsableSeparator
extends JPanel {
    protected Component innerComp = null;
    protected JCheckBox moreBtn;
    protected JComponent extraComp;
    protected ImageIcon forwardImgIcon;
    protected ImageIcon downImgIcon;
    protected JPanel subPanel = null;
    protected CardLayout cardLayout = new CardLayout();
    protected PanelBuilder panelBldr;
    protected boolean includeMore;
    protected Hashtable<String, Component> compsHash = new Hashtable();

    public CollapsableSeparator(Component separator, boolean includeMore, JComponent extraComp) {
        this.includeMore = includeMore;
        this.extraComp = extraComp;
        this.init();
        String rowDef = String.valueOf(includeMore ? "p," : "") + "p,f:p:g" + (extraComp != null ? ",p" : "");
        this.panelBldr = new PanelBuilder(new FormLayout(rowDef, "b:p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        int x = 1;
        if (includeMore) {
            this.panelBldr.add((Component)this.moreBtn, cc.xy(x, 1));
            ++x;
        }
        this.panelBldr.add(separator, cc.xy(x, 1));
        if (extraComp != null) {
            this.panelBldr.add((Component)extraComp, cc.xy(x, 1));
            ++x;
        }
    }

    public CollapsableSeparator(String title, boolean includeMore, JComponent extraComp) {
        this.includeMore = includeMore;
        this.extraComp = extraComp;
        this.init();
        String rowDef = String.valueOf(includeMore ? "p," : "") + "p,p,f:p:g" + (extraComp != null ? ",p" : "");
        this.panelBldr = new PanelBuilder(new FormLayout(rowDef, "c:p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        this.subPanel = new JPanel(this.cardLayout);
        this.subPanel.setBorder(null);
        this.subPanel.setOpaque(false);
        int x = 1;
        if (includeMore) {
            this.panelBldr.add((Component)this.moreBtn, cc.xy(x, 1));
            ++x;
        }
        JLabel titleLbl = UIHelper.createLabel(title);
        if (!UIHelper.isMacOS()) {
            titleLbl.setFont(UIManager.getFont("TitledBorder.font"));
            titleLbl.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        }
        this.panelBldr.add((Component)titleLbl, cc.xy(x, 1));
        this.panelBldr.addSeparator(" ", cc.xy(x += 2, 1));
        ++x;
        if (extraComp != null) {
            this.panelBldr.add((Component)extraComp, cc.xy(x, 1));
            ++x;
        }
    }

    protected void init() {
        if (this.includeMore) {
            this.forwardImgIcon = IconManager.getIcon("Forward");
            this.downImgIcon = IconManager.getIcon("Down");
            this.moreBtn = new JCheckBox("", this.forwardImgIcon);
            this.moreBtn.setOpaque(false);
            this.moreBtn.setFocusable(false);
        }
        UIHelper.setControlSize(this.moreBtn);
        this.setOpaque(false);
    }

    public void addToSubPanel(JComponent comp, String key) {
        if (this.subPanel != null && this.subPanel.getComponentCount() == 0) {
            CellConstraints cc = new CellConstraints();
            this.panelBldr.add((Component)this.subPanel, cc.xy(this.includeMore ? 3 : 2, 1));
            if (comp.getComponentCount() > 0) {
                this.subPanel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            }
        }
        this.subPanel.add((Component)comp, key);
        this.compsHash.put(key, comp);
    }

    public void showSubPanel(String key) {
        this.cardLayout.show(this.subPanel, key);
        this.subPanel.setVisible(((Container)this.compsHash.get(key)).getComponentCount() > 0);
    }

    public void setInnerComp(final Component innerComp) {
        if (innerComp != null && this.innerComp == null) {
            this.innerComp = innerComp;
            if (this.moreBtn != null) {
                this.moreBtn.setIcon(innerComp.isVisible() ? this.downImgIcon : this.forwardImgIcon);
                this.moreBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (innerComp.isVisible()) {
                            innerComp.setVisible(false);
                            CollapsableSeparator.this.moreBtn.setIcon(CollapsableSeparator.this.forwardImgIcon);
                        } else {
                            innerComp.setVisible(true);
                            CollapsableSeparator.this.moreBtn.setIcon(CollapsableSeparator.this.downImgIcon);
                        }
                        CollapsableSeparator.this.invalidate();
                        CollapsableSeparator.this.doLayout();
                        CollapsableSeparator.this.repaint();
                    }
                });
            }
        }
    }

    public JCheckBox getMoreBtn() {
        return this.moreBtn;
    }
}

