/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.ui.forms.CollapseLinkEntryInfo;
import edu.ku.brc.af.ui.forms.CollapseLinkInfo;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class CollapsableSepExtraCompFactory {
    public static final String factoryName = "edu.ku.brc.af.core.CollapsableSepExtraBtnFactory";
    protected static CollapsableSepExtraCompFactory instance = new CollapsableSepExtraCompFactory();
    protected HashMap<String, CollapseLinkInfo> collLinkHash = new HashMap();

    protected CollapsableSepExtraCompFactory() {
        this.loadConfig();
    }

    private String mkKey(String name, String subName) {
        return String.format("%s__%s", name, subName);
    }

    public JComponent getComponent(String categoryName, String name) {
        return this.createBtn(this.mkKey(categoryName, name));
    }

    private JButton createBtn(String key) {
        CollapseLinkInfo lnkInfo = this.collLinkHash.get(key);
        if (lnkInfo != null) {
            ActionListener al = lnkInfo instanceof CollapseLinkEntryInfo && ((CollapseLinkEntryInfo)lnkInfo).hasItems() ? this.createChoosehLink((CollapseLinkEntryInfo)lnkInfo) : this.createLaunchLink(lnkInfo.getUrl());
            JButton btn = UIHelper.createIconBtn("video", IconManager.IconSize.Std16, UIRegistry.getResourceString("CHSE_VIDEO_TT"), al);
            btn.setEnabled(true);
            return btn;
        }
        return null;
    }

    private ActionListener createChoosehLink(final CollapseLinkEntryInfo clei) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JList<CollapseLinkInfo> list = new JList<CollapseLinkInfo>(new Vector<CollapseLinkInfo>(clei.getItems()));
                    list.setSelectionMode(0);
                    JScrollPane sc = UIHelper.createScrollPane(list);
                    PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
                    pb.add((Component)sc, new CellConstraints().xy(1, 1));
                    pb.setDefaultDialogBorder();
                    final CustomDialog dlg = new CustomDialog(null, UIRegistry.getResourceString("CHSE_VIDEO"), true, 3, (Component)pb.getPanel());
                    list.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() == 2) {
                                dlg.getOkBtn().doClick();
                            }
                        }
                    });
                    UIHelper.centerAndShow(dlg);
                    if (!dlg.isCancelled()) {
                        CollapseLinkInfo cli = list.getSelectedValue();
                        try {
                            Desktop.getDesktop().browse(new URI(cli.getUrl()));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
    }

    private ActionListener createLaunchLink(final String url) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
    }

    protected void loadConfig() {
        XStream xstream = new XStream();
        CollapseLinkEntryInfo.configXStream(xstream);
        CollapseLinkInfo.configXStream(xstream);
        File file = new File(XMLHelper.getConfigDirPath("colextrabtn.xml"));
        if (file.exists()) {
            try {
                HashMap xsHash = (HashMap)xstream.fromXML((InputStream)new FileInputStream(file));
                for (Object keyObj : xsHash.keySet()) {
                    String key = (String)keyObj;
                    ArrayList items = (ArrayList)xsHash.get(key);
                    for (CollapseLinkEntryInfo lei : items) {
                        System.out.println("[" + this.mkKey(key, lei.getName()) + "]");
                        this.collLinkHash.put(this.mkKey(key, lei.getName()), lei);
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static CollapsableSepExtraCompFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(CollapsableSepExtraCompFactory.factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = (CollapsableSepExtraCompFactory)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                InternalError error = new InternalError("Can't instantiate CollapsableSepExtraBtnFactory factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }
}

