/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectGettableFactory;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.DataObjectSettableFactory;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.persist.FormCellField;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellSubViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDefIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CarryForwardInfo {
    protected List<FormViewObj.FVOFieldInfo> fieldList = new ArrayList<FormViewObj.FVOFieldInfo>();
    protected DataObjectGettable getter;
    protected DataObjectSettable setter;
    protected FormViewDefIFace formViewDef;
    protected FormViewObj formViewObj;

    public CarryForwardInfo(Class<?> classObj, FormViewObj formViewObj, FormViewDefIFace formViewDef) {
        this.formViewObj = formViewObj;
        this.formViewDef = formViewDef;
        this.getter = DataObjectGettableFactory.get(classObj.getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
        this.setter = DataObjectSettableFactory.get(classObj.getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
    }

    public void add(List<FormViewObj.FVOFieldInfo> items) {
        this.fieldList.clear();
        this.fieldList.addAll(items);
        this.formViewObj.setDoCarryForward(true);
    }

    public void add(String id) {
        FormViewObj.FVOFieldInfo fvoFieldInfo = this.formViewObj.getFieldInfoForId(id);
        if (fvoFieldInfo != null && fvoFieldInfo.getFormCell() instanceof FormCellField) {
            this.fieldList.add(fvoFieldInfo);
            this.formViewObj.setDoCarryForward(true);
        }
    }

    public void remove(String id) {
        FormViewObj.FVOFieldInfo fvoFieldInfo = this.formViewObj.getFieldInfoForId(id);
        if (fvoFieldInfo != null && fvoFieldInfo.getFormCell() instanceof FormCellField) {
            this.fieldList.remove(fvoFieldInfo);
            this.formViewObj.setDoCarryForward(this.fieldList.size() > 0);
        }
    }

    public List<FormViewObj.FVOFieldInfo> getFieldList() {
        return this.fieldList;
    }

    public boolean contains(String id) {
        for (FormViewObj.FVOFieldInfo fvoFieldInfo : this.fieldList) {
            if (!fvoFieldInfo.getFormCell().getIdent().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConfiguredFields() {
        return this.fieldList.size() > 0;
    }

    public void clear() {
        this.fieldList.clear();
    }

    private boolean isClonable(Object obj) {
        try {
            Method method = obj.getClass().getMethod("clone", new Class[0]);
            return method.getDeclaringClass() == obj.getClass();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CarryForwardInfo.class, ex);
            return false;
        }
    }

    private void cloneCFField(String fieldName, Object fieldDataValue, Object newData) {
        try {
            Object data = ((FormDataObjIFace)fieldDataValue).clone();
            this.setter.setFieldValue(newData, fieldName, data);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CarryForwardInfo.class, ex);
            ex.printStackTrace();
        }
    }

    private boolean isFieldClonable(BusinessRulesIFace businessRules, String fieldName, Object fieldDataValue) {
        if (fieldDataValue != null && businessRules != null && businessRules.shouldCloneField(fieldName)) {
            if (this.isClonable(fieldDataValue)) {
                return true;
            }
            UIRegistry.showError("A request has been made to Clone an object [" + fieldDataValue.getClass().getSimpleName() + "] and it doesn't implement Clone\nPlease ask engineering to do that.");
        }
        return false;
    }

    protected void setOrCloneDataValue(BusinessRulesIFace businessRules, Object carryFwdData, FormViewObj.FVOFieldInfo fvoFieldInfo, Object newData) {
        String fieldName = fvoFieldInfo.getFormCell().getName();
        if (fieldName.equals("this") && fvoFieldInfo.getComp() instanceof UIPluginable && ((UIPluginable)((Object)fvoFieldInfo.getComp())).canCarryForward()) {
            String[] fieldNames = ((UIPluginable)((Object)fvoFieldInfo.getComp())).getCarryForwardFields();
            if (fieldNames != null) {
                String[] stringArray = fieldNames;
                int n = fieldNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fldName = stringArray[n2];
                    Object fieldDataValue = this.getter.getFieldValue(carryFwdData, fldName);
                    if (this.isFieldClonable(businessRules, fldName, fieldDataValue)) {
                        this.cloneCFField(fldName, fieldDataValue, newData);
                    } else {
                        this.setter.setFieldValue(newData, fldName, fieldDataValue);
                    }
                    ++n2;
                }
            }
            return;
        }
        Object fieldDataValue = this.getter.getFieldValue(carryFwdData, fieldName);
        if (this.isFieldClonable(businessRules, fieldName, fieldDataValue)) {
            this.cloneCFField(fieldName, fieldDataValue, newData);
        } else {
            this.setter.setFieldValue(newData, fieldName, fieldDataValue);
        }
    }

    public void carryForward(BusinessRulesIFace businessRules, Object carryFwdData, Object newData) {
        for (FormViewObj.FVOFieldInfo fvoFieldInfo : this.fieldList) {
            DBRelationshipInfo ri;
            if (fvoFieldInfo.getFormCell() instanceof FormCellFieldIFace) {
                this.setOrCloneDataValue(businessRules, carryFwdData, fvoFieldInfo, newData);
                continue;
            }
            if (!(fvoFieldInfo.getFormCell() instanceof FormCellSubViewIFace)) continue;
            FormCellSubViewIFace subViewFormCell = (FormCellSubViewIFace)fvoFieldInfo.getFormCell();
            Object fromData = this.getter.getFieldValue(carryFwdData, subViewFormCell.getName());
            Object toData = this.getter.getFieldValue(newData, subViewFormCell.getName());
            if (fromData instanceof Set && toData instanceof Set) {
                Set fromSet = (Set)fromData;
                for (Object dObj : fromSet) {
                    if (!(dObj instanceof FormDataObjIFace)) continue;
                    try {
                        Object newObj = ((FormDataObjIFace)dObj).clone();
                        ((FormDataObjIFace)newData).addReference((FormDataObjIFace)newObj, subViewFormCell.getName());
                    }
                    catch (CloneNotSupportedException ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(CarryForwardInfo.class, ex);
                        ex.printStackTrace();
                    }
                }
                continue;
            }
            if (!(fvoFieldInfo.getFieldInfo() instanceof DBRelationshipInfo) || (ri = (DBRelationshipInfo)fvoFieldInfo.getFieldInfo()).getType() != DBRelationshipInfo.RelationshipType.ManyToOne) continue;
            this.setOrCloneDataValue(businessRules, carryFwdData, fvoFieldInfo, newData);
        }
    }

    public void cleanUp() {
        this.fieldList.clear();
        this.getter = null;
        this.setter = null;
        this.formViewDef = null;
        this.formViewObj = null;
    }
}

