/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellLabel;
import edu.ku.brc.af.ui.forms.persist.FormCellSubView;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CarryForwardConfigDlg
extends CustomDialog {
    private static final Logger log = Logger.getLogger(CarryForwardConfigDlg.class);
    protected Color[] toggleColors = new Color[]{Color.WHITE, new Color(230, 230, 230)};
    protected int togInx = 0;
    protected String togTableName = "";
    protected MultiView mvParent;
    protected JTable table;
    protected CFTableModel model;
    protected Vector<CFWItem> items = new Vector();

    public CarryForwardConfigDlg(MultiView mvParent) {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("MV_CFW_CONFIG_TITLE"), true, (Component)null);
        this.mvParent = mvParent;
    }

    @Override
    public void createUI() {
        super.createUI();
        this.buildTableModel(this.mvParent);
        this.model = new CFTableModel();
        this.table = new JTable(this.model){

            @Override
            public Class<?> getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!c.getBackground().equals(this.getSelectionBackground())) {
                    CFWItem item = CarryForwardConfigDlg.this.items.get(row);
                    c.setBackground(item.getColor());
                }
                return c;
            }
        };
        UIHelper.makeTableHeadersCentered(this.table, false);
        JScrollPane sp = new JScrollPane(this.table, 20, 31);
        this.contentPanel = sp;
        this.mainPanel.add(this.contentPanel, "Center");
    }

    protected void buildTableModel(MultiView mvp) {
        for (Viewable viewable : mvp.getViewables()) {
            if (!(viewable instanceof FormViewObj) || !((FormViewObj)viewable).isEditing) continue;
            Vector<String> ids = new Vector<String>();
            FormViewObj fvo = (FormViewObj)viewable;
            fvo.getFieldIds(ids, true);
            for (String id : ids) {
                FormViewObj.FVOFieldInfo fieldInfo = fvo.getFieldInfoForId(id);
                boolean isOK = true;
                if (fieldInfo.getFormCell() instanceof FormCellFieldIFace) {
                    FormCellFieldIFace.FieldType type = ((FormCellFieldIFace)fieldInfo.getFormCell()).getUiType();
                    if (type == FormCellFieldIFace.FieldType.dsptextfield || type == FormCellFieldIFace.FieldType.dsptextarea || type == FormCellFieldIFace.FieldType.label) {
                        isOK = false;
                    }
                } else if (fieldInfo.getFormCell() instanceof FormCellSubView && fieldInfo.getSubView() != null) continue;
                if (!isOK) continue;
                FormViewObj.FVOFieldInfo labelInfo = fvo.getLabelInfoFor(id);
                if (labelInfo != null) {
                    if (fieldInfo.getFormCell() instanceof FormCellLabel) continue;
                    String lbl = ((FormCellLabel)labelInfo.getFormCell()).getLabel();
                    fieldInfo.setLabel(lbl);
                    CFWItem item = new CFWItem(mvp, fvo, fieldInfo);
                    if (!item.getTableTitle().equals(this.togTableName)) {
                        this.togTableName = item.getTableTitle();
                        ++this.togInx;
                    }
                    item.setColor(this.toggleColors[this.togInx % 2]);
                    this.items.add(item);
                    continue;
                }
                String fieldName = fieldInfo.getFormCell().getName();
                DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(mvp.getView().getClassName());
                if (ti == null) continue;
                DBFieldInfo fi = ti.getFieldByName(fieldName);
                if (fi != null) {
                    fieldInfo.setLabel(fi.getTitle());
                    CFWItem item = new CFWItem(mvp, fvo, fieldInfo);
                    if (!item.getTableTitle().equals(this.togTableName)) {
                        this.togTableName = item.getTableTitle();
                        ++this.togInx;
                    }
                    item.setColor(this.toggleColors[this.togInx % 2]);
                    this.items.add(item);
                    continue;
                }
                log.error((Object)("Couldn't find field [" + fieldName + "] in [" + ti.getTitle() + "]"));
            }
        }
    }

    class CFTableModel
    extends DefaultTableModel {
        protected String[] colTitles = new String[]{"Field Name", "Form", "Carry Forward"};

        @Override
        public Class<?> getColumnClass(int col) {
            return col == 2 ? Boolean.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return this.colTitles != null ? this.colTitles.length : 0;
        }

        @Override
        public String getColumnName(int index) {
            return this.colTitles[index];
        }

        @Override
        public int getRowCount() {
            return CarryForwardConfigDlg.this.items.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CFWItem item = CarryForwardConfigDlg.this.items.get(row);
            if (col == 0) {
                String title = item.getFieldInfo().getLabel();
                if (StringUtils.isNotEmpty((String)title)) {
                    title = item.getFieldInfo().getName();
                }
                return item.getFieldInfo().getLabel();
            }
            if (col == 2) {
                return item.isChecked();
            }
            return item.getTableTitle();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 2;
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            CFWItem item = CarryForwardConfigDlg.this.items.get(row);
            if (col == 2) {
                item.setChecked((Boolean)val);
            }
        }
    }

    class CFWItem {
        protected MultiView mv;
        protected FormViewObj fvo;
        protected FormViewObj.FVOFieldInfo fieldInfo;
        protected DBTableInfo ti;
        protected boolean isChecked = false;
        protected boolean isRequired = false;
        protected Color color;

        public CFWItem(MultiView mv, FormViewObj fvo, FormViewObj.FVOFieldInfo fieldInfo) {
            this.mv = mv;
            this.fvo = fvo;
            this.fieldInfo = fieldInfo;
            this.ti = DBTableIdMgr.getInstance().getByClassName(mv.getView().getClassName());
        }

        public MultiView getMv() {
            return this.mv;
        }

        public FormViewObj getFvo() {
            return this.fvo;
        }

        public FormViewObj.FVOFieldInfo getFieldInfo() {
            return this.fieldInfo;
        }

        public String getTableTitle() {
            return this.ti.getTitle();
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public void setChecked(boolean isChecked) {
            this.isChecked = isChecked;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public void setRequired(boolean isRequired) {
            this.isRequired = isRequired;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

