/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.JButton;
import org.apache.commons.lang.StringUtils;

public class BrowserLauncherBtn
extends JButton
implements GetSetValueIFace {
    protected String url = null;
    protected Object dataObj = null;
    protected ActionListener action = null;

    public BrowserLauncherBtn(String text) {
        super(text);
        UIHelper.setControlSize(this);
        this.setEnabled(false);
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value != null) {
            this.url = value.toString();
            this.setText(this.url);
            this.dataObj = value;
            if (this.action != null) {
                this.removeActionListener(this.action);
            }
            if (StringUtils.isNotEmpty((String)this.url)) {
                this.action = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        BrowserLauncherBtn.this.buildAndOpenURL();
                    }
                };
                this.addActionListener(this.action);
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected void buildAndOpenURL() {
        StringBuilder urlBuilder = new StringBuilder(this.url);
        if (this.url.startsWith("[")) {
            int endingBracketIndex;
            String urlPrefix;
            AppPreferences remotePrefs = AppPreferences.getRemote();
            String urlPrefixValue = remotePrefs.get("URL_Prefix." + (urlPrefix = urlBuilder.substring(1, endingBracketIndex = urlBuilder.indexOf("]"))), null);
            if (urlPrefixValue == null) {
                String errorMsg = String.format(UIRegistry.getResourceString("WLLB_CANNOT_BUILD_URL"), urlPrefix);
                UIRegistry.getStatusBar().setErrorMessage(errorMsg);
                return;
            }
            urlBuilder.replace(0, endingBracketIndex + 1, urlPrefixValue);
        }
        try {
            AttachmentUtils.openURI(new URI(urlBuilder.toString()));
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BrowserLauncherBtn.class, e);
            String errorMsg = String.format(UIRegistry.getResourceString("ERROR_CANT_OPEN_URL"), urlBuilder.toString());
            UIRegistry.getStatusBar().setErrorMessage(errorMsg, e);
        }
    }

    @Override
    public Object getValue() {
        return this.dataObj;
    }
}

