/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.GenericLSIDGeneratorFactory;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyLSIDGeneratorFactory;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BaseBusRules
implements BusinessRulesIFace {
    private static final Logger log = Logger.getLogger(BaseBusRules.class);
    protected Viewable viewable = null;
    protected FormViewObj formViewObj = null;
    protected List<String> reasonList = new Vector<String>();
    protected Class<?>[] dataClasses;
    protected HashSet<AttachmentOwnerIFace<?>> attachOwners = new HashSet();

    public BaseBusRules(Class<?> ... dataClasses) {
        this.dataClasses = dataClasses;
    }

    @Override
    public void initialize(Viewable viewableArg) {
        this.viewable = viewableArg;
        if (this.viewable instanceof FormViewObj) {
            this.formViewObj = (FormViewObj)this.viewable;
        }
    }

    @Override
    public void beforeFormFill() {
    }

    @Override
    public void afterFillForm(Object dataObj) {
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
    }

    @Override
    public boolean shouldCreateSubViewData(String fieldName) {
        return false;
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        String title = "Object";
        if (dataObj instanceof FormDataObjIFace) {
            FormDataObjIFace dObj = (FormDataObjIFace)dataObj;
            title = dObj.getIdentityTitle();
        }
        return UIRegistry.getLocalizedMessage("GENERIC_OBJ_DELETED", title);
    }

    @Override
    public List<String> getWarningsAndErrors() {
        return this.reasonList;
    }

    @Override
    public String getMessagesAsString() {
        StringBuilder strBuf = new StringBuilder();
        for (String s : this.getWarningsAndErrors()) {
            strBuf.append(s);
            strBuf.append("\n");
        }
        return strBuf.toString();
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        return true;
    }

    @Override
    public boolean canCreateNewDataObject() {
        return false;
    }

    @Override
    public void afterCreateNewObj(Object newDataObj) {
    }

    @Override
    public void createNewObj(boolean doSetIntoAndValidateArg, Object oldDataObj) {
    }

    protected void addExtraObjectForProcessing(Object dObj) {
        if (dObj instanceof AttachmentOwnerIFace) {
            this.attachOwners.add((AttachmentOwnerIFace)dObj);
        }
    }

    protected boolean okToDelete(String tableName, String columnName, Integer ... ids) {
        return this.okToDelete(0, tableName, columnName, ids);
    }

    protected boolean okToDelete(int count, String tableName, String columnName, Integer ... ids) {
        if (ids != null) {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = DBConnection.getInstance().createConnection();
                stmt = conn.createStatement();
                boolean bl = this.okToDelete(stmt, count, tableName, columnName, ids);
                return bl;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BaseBusRules.class, ex);
                ex.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(BaseBusRules.class, ex);
                    ex.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    protected String getExtraWhereColumns(DBTableInfo tableInfo) {
        System.out.println(tableInfo != null ? Integer.valueOf(tableInfo.getTableId()) : "  is null");
        return QueryAdjusterForDomain.getInstance().getSpecialColumns(tableInfo, false, false, tableInfo.getAbbrev());
    }

    public Integer getCount(Statement stmt, String tableName, String columnName, Integer ... ids) {
        Integer count = null;
        try {
            ResultSet rs;
            StringBuilder idString = new StringBuilder();
            Integer[] integerArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Integer i = integerArray[n2];
                idString.append(i);
                idString.append(", ");
                ++n2;
            }
            idString.deleteCharAt(idString.length() - 2);
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(tableName);
            String extraColumns = this.getExtraWhereColumns(tableInfo);
            String join = QueryAdjusterForDomain.getInstance().getJoinClause(tableInfo, false, tableInfo.getAbbrev(), false);
            String queryString = "select count(*) from " + tableName + " " + tableInfo.getAbbrev() + " " + (join != null ? join : "") + "  where " + tableInfo.getAbbrev() + "." + columnName + " in (" + idString.toString() + ") ";
            if (StringUtils.isNotEmpty((String)extraColumns)) {
                queryString = String.valueOf(queryString) + " AND " + extraColumns;
            }
            if ((rs = stmt.executeQuery(queryString)).next()) {
                count = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BaseBusRules.class, ex);
            ex.printStackTrace();
        }
        return count;
    }

    protected Integer getTotalCount(String[] nameCombos, Integer ... ids) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DBConnection.getInstance().createConnection();
            stmt = conn.createStatement();
            int total = 0;
            int i = 0;
            while (i < nameCombos.length) {
                Integer count = this.getCount(stmt, nameCombos[i], nameCombos[i + 1], ids);
                if (count != null) {
                    total += count.intValue();
                }
                ++i;
                ++i;
            }
            Integer n = total;
            return n;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BaseBusRules.class, ex);
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BaseBusRules.class, ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected boolean okToDelete(Statement stmt, int count, String tableName, String columnName, Integer ... ids) {
        Integer recCount = this.getCount(stmt, tableName, columnName, ids);
        return recCount != null && recCount <= count;
    }

    protected boolean okToDelete(String[] nameCombos, Integer ... ids) {
        return this.okToDelete(0, nameCombos, ids);
    }

    protected boolean okToDelete(int count, String[] nameCombos, Integer ... ids) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DBConnection.getInstance().createConnection();
            if (conn == null) {
                log.debug((Object)("Couldn't create connection! Reason: " + DBConnection.getInstance().getErrorMsg()));
                return false;
            }
            stmt = conn.createStatement();
            int i = 0;
            while (i < nameCombos.length) {
                if (!this.okToDelete(stmt, count, nameCombos[i], nameCombos[i + 1], ids)) {
                    DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(nameCombos[i]);
                    if (tableInfo != null) {
                        this.reasonList.add(tableInfo.getTitle());
                    }
                    return false;
                }
                try {
                    ++i;
                    ++i;
                    continue;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(BaseBusRules.class, ex);
                    ex.printStackTrace();
                }
                break;
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BaseBusRules.class, ex);
                ex.printStackTrace();
            }
        }
        return true;
    }

    protected void addDeleteReason(int tableId) {
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(tableId);
        if (tableInfo != null) {
            this.reasonList.add(tableInfo.getTitle());
        }
    }

    protected String[] gatherTableFieldsForDelete(String[] skipTableNames, String idColName, Class<?> dataClassObj) {
        boolean debug = false;
        int fieldCnt = 0;
        Hashtable<String, Vector<String>> fieldHash = new Hashtable<String, Vector<String>>();
        for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
            Hashtable<String, Boolean> skipHash = new Hashtable<String, Boolean>();
            if (skipTableNames != null) {
                String[] stringArray = skipTableNames;
                int n = skipTableNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    skipHash.put(name, true);
                    ++n2;
                }
            }
            if (dataClassObj == null) continue;
            for (DBRelationshipInfo ri : ti.getRelationships()) {
                String colName;
                if (ri.getDataClass() != dataClassObj || !StringUtils.isNotEmpty((String)(colName = ri.getColName())) || skipHash.get(ti.getName()) != null && colName.equals(idColName)) continue;
                Vector<String> fieldList = (Vector<String>)fieldHash.get(ti.getName());
                if (fieldList == null) {
                    fieldList = new Vector<String>();
                    fieldHash.put(ti.getName(), fieldList);
                }
                fieldList.add(ri.getColName());
                ++fieldCnt;
            }
        }
        if (debug) {
            System.out.println("Fields to be checked:");
            for (String tableName : fieldHash.keySet()) {
                System.out.println(" Table:" + tableName + " ");
                for (String fName : (Vector)fieldHash.get(tableName)) {
                    System.out.println("   Field:" + fName);
                }
            }
        }
        int inx = 0;
        String[] tableFieldNamePairs = new String[fieldCnt * 2];
        for (String tableName : fieldHash.keySet()) {
            for (String fName : (Vector)fieldHash.get(tableName)) {
                tableFieldNamePairs[inx++] = tableName;
                tableFieldNamePairs[inx++] = fName;
            }
        }
        return tableFieldNamePairs;
    }

    protected boolean isEditMode() {
        MultiView mvParent;
        if (this.formViewObj != null && (mvParent = this.formViewObj.getMVParent()) != null) {
            return mvParent.isEditable();
        }
        return false;
    }

    protected boolean isNewObject() {
        MultiView mvParent;
        if (this.formViewObj != null && (mvParent = this.formViewObj.getMVParent()) != null) {
            return MultiView.isOptionOn(mvParent.getOptions(), 4);
        }
        return false;
    }

    protected String[] gatherTableFieldsForDelete(String[] skipTableNames, DBTableInfo tableInfo) {
        return this.gatherTableFieldsForDelete(skipTableNames, tableInfo.getIdColumnName(), tableInfo.getClassObj());
    }

    @Override
    public void okToDelete(Object dataObj, DataProviderSessionIFace session, BusinessRulesOkDeleteIFace deletable) {
        if (deletable != null) {
            deletable.doDeleteDataObj(dataObj, session, true);
        }
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        return true;
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        return true;
    }

    @Override
    public void afterSaveFailure(Object dataObj, DataProviderSessionIFace session) {
    }

    @Override
    public void saveFinalization(Object dataObj) {
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        return true;
    }

    @Override
    public void afterDeleteCommit(Object dataObj) {
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        return dataObj;
    }

    @Override
    public boolean beforeDeleteCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        return true;
    }

    protected String getErrorMsg(String msgKey, Class<?> dataClass, String fieldName, String value) {
        DBTableChildIFace ci;
        String title = "Unknown Field";
        DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(dataClass.getName());
        if (ti != null && (ci = ti.getItemByName(fieldName)) != null) {
            title = ci.getTitle();
        }
        return String.format(UIRegistry.getResourceString(msgKey), title, value);
    }

    protected BusinessRulesIFace.STATUS isCheckDuplicateNumberOK(String fieldName, FormDataObjIFace dataObj, Class<?> dataClass, String primaryFieldName) {
        return this.isCheckDuplicateNumberOK(fieldName, dataObj, dataClass, primaryFieldName, true);
    }

    protected BusinessRulesIFace.STATUS isCheckDuplicateNumberOK(String fieldName, FormDataObjIFace dataObj, Class<?> dataClass, String primaryFieldName, boolean useSpecial) {
        return this.isCheckDuplicateNumberOK(fieldName, dataObj, dataClass, primaryFieldName, false, useSpecial);
    }

    protected BusinessRulesIFace.STATUS isCheckDuplicateNumberOK(String fieldName, FormDataObjIFace dataObj, Class<?> dataClass, String primaryFieldName, boolean isEmptyOK, boolean useSpecial) {
        String fieldValue = (String)FormHelper.getValue(dataObj, fieldName);
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            Object fmtObj;
            Integer cnt;
            Integer id = dataObj.getId();
            String colName = null;
            DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(dataClass.getName());
            DBFieldInfo fi = ti.getFieldByName(primaryFieldName);
            if (fi != null) {
                colName = fi.getColumn();
            } else if (ti.getIdFieldName().equals(primaryFieldName)) {
                colName = ti.getIdColumnName();
            }
            fi = ti.getFieldByName(fieldName);
            String special = QueryAdjusterForDomain.getInstance().getSpecialColumns(ti, false);
            String quote = fi.getDataClass() == String.class || fi.getDataClass() == Date.class ? "'" : "";
            String sql = String.format("SELECT COUNT(%s) FROM %s WHERE %s = %s%s%s", colName, ti.getName(), fi.getColumn(), quote, fieldValue, quote);
            if (id != null) {
                sql = String.valueOf(sql) + " AND " + colName + " <> " + id;
            }
            if ((cnt = BasicSQLUtils.getCount(sql = String.valueOf(sql) + (StringUtils.isNotEmpty((String)special) && useSpecial ? " AND " + special : ""))) == null || cnt == 0) {
                return BusinessRulesIFace.STATUS.OK;
            }
            if (fi != null && fi.getFormatter() != null && (fmtObj = fi.getFormatter().formatToUI(fieldValue)) != null) {
                fieldValue = fmtObj.toString();
            }
            this.reasonList.add(this.getErrorMsg("GENERIC_FIELD_IN_USE", dataClass, fieldName, fieldValue));
            return BusinessRulesIFace.STATUS.Error;
        }
        if (isEmptyOK) {
            return BusinessRulesIFace.STATUS.OK;
        }
        this.reasonList.add(this.getErrorMsg("GENERIC_FIELD_MISSING", dataClass, fieldName, ""));
        return BusinessRulesIFace.STATUS.Error;
    }

    protected JButton getNewBtn() {
        if (this.formViewObj != null) {
            JButton newBtn = this.formViewObj.getNewRecBtn();
            if (newBtn == null && this.formViewObj.getRsController() != null) {
                return this.formViewObj.getRsController().getNewRecBtn();
            }
            return newBtn;
        }
        if (this.viewable instanceof TableViewObj) {
            TableViewObj tvo = (TableViewObj)this.viewable;
            return tvo.getNewButton();
        }
        return null;
    }

    protected JButton getDelBtn() {
        if (this.formViewObj != null) {
            JButton delBtn = this.formViewObj.getDelRecBtn();
            if (delBtn == null && this.formViewObj.getRsController() != null) {
                return this.formViewObj.getRsController().getDelRecBtn();
            }
            return delBtn;
        }
        if (this.viewable instanceof TableViewObj) {
            TableViewObj tvo = (TableViewObj)this.viewable;
            return tvo.getDeleteButton();
        }
        return null;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (dataObj == null) {
            return BusinessRulesIFace.STATUS.Error;
        }
        Class<?> dataObjClass = dataObj.getClass();
        Class<?>[] classArray = this.dataClasses;
        int n = this.dataClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz.isAssignableFrom(dataObjClass)) {
                return BusinessRulesIFace.STATUS.OK;
            }
            ++n2;
        }
        return BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        return this.processBusinessRules(dataObj);
    }

    @Override
    public void startProcessingBeforeAfterRules() {
    }

    @Override
    public void endProcessingBeforeAfterRules() {
    }

    protected void setLSID(FormDataObjIFace data) {
        boolean doLSID;
        if (data != null && (doLSID = ((SpecifyLSIDGeneratorFactory)SpecifyLSIDGeneratorFactory.getInstance()).isPrefOn(data.getTableId()))) {
            String lsid;
            boolean doVersioning = true;
            UIFieldFormatterIFace formatter = null;
            if (data.getTableId() == 1) {
                DBFieldInfo fi = DBTableIdMgr.getInstance().getInfoById(1).getFieldByColumnName("CatalogNumber");
                formatter = fi.getFormatter();
            }
            if ((lsid = GenericLSIDGeneratorFactory.getInstance().setLSIDOnId(data, doVersioning, formatter)) != null) {
                FormHelper.setValue(data, "guid", lsid);
            }
        }
    }

    public static void removeById(Collection<?> collection, FormDataObjIFace dataObj) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormDataObjIFace colObj;
            Object obj = objectArray[n2];
            if (obj instanceof FormDataObjIFace && (obj == (colObj = (FormDataObjIFace)obj) || colObj.getId() != null && dataObj.getId() != null && dataObj.getId().equals(colObj.getId()))) {
                collection.remove(obj);
                break;
            }
            ++n2;
        }
    }

    public static int countDataObjectById(Collection<?> collection, FormDataObjIFace dataObj) {
        int cnt = 0;
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormDataObjIFace colObj;
            Object obj = objectArray[n2];
            if (obj instanceof FormDataObjIFace && (dataObj == (colObj = (FormDataObjIFace)obj) || colObj.getId() != null && dataObj.getId() != null && dataObj.getId().equals(colObj.getId()))) {
                ++cnt;
            }
            ++n2;
        }
        return cnt;
    }

    @Override
    public boolean doesSearchObjectRequireNewParent() {
        return false;
    }

    @Override
    public void setObjectIdentity(Object dataObj, DraggableRecordIdentifier draggableIcon) {
    }

    @Override
    public boolean isOkToAssociateSearchObject(Object newParentDataObj, Object dataObjectFromSearch) {
        return true;
    }

    @Override
    public Object processSearchObject(Object parentdataObj, Object dataObjectFromSearch) {
        return dataObjectFromSearch;
    }

    @Override
    public boolean shouldCloneField(String fieldName) {
        return false;
    }

    @Override
    public void formShutdown() {
        this.viewable = null;
        this.formViewObj = null;
    }

    @Override
    public void aboutToShutdown() {
    }
}

