/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayActionAdapter;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ViewBasedDisplayPanel
extends JPanel
implements ActionListener {
    private static final Logger log = Logger.getLogger(ViewBasedDisplayPanel.class);
    protected MultiView multiView;
    protected ViewIFace formView;
    protected List<String> fieldNames;
    protected ViewBasedDisplayActionAdapter vbdaa = null;
    protected String className;
    protected String idFieldName;
    protected String displayName;
    protected JButton okBtn;
    protected JButton cancelBtn = null;
    protected Window parentWin;
    protected boolean isCancelled = false;
    protected boolean doRegOKBtn;

    public ViewBasedDisplayPanel(String className, String idFieldName) {
        this.className = className;
        this.idFieldName = idFieldName;
    }

    public ViewBasedDisplayPanel(Window parent, String viewSetName, String viewName, String displayName, String className, String idFieldName, boolean isEdit, int options) {
        this(parent, viewSetName, viewName, displayName, className, idFieldName, isEdit, true, null, null, options);
    }

    public ViewBasedDisplayPanel(String viewSetName, String viewName, String className, boolean isEdit, int options) {
        this(null, viewSetName, viewName, null, className, null, isEdit, true, null, null, options);
    }

    public ViewBasedDisplayPanel(Window parent, String viewSetName, String viewName, String displayName, String className, String idFieldName, boolean isEdit, boolean doRegOKBtn, String cellName, MultiView mvParent, int options) {
        this.parentWin = parent;
        this.className = className;
        this.idFieldName = idFieldName;
        this.displayName = displayName;
        this.doRegOKBtn = doRegOKBtn;
        this.createUI(viewSetName, viewName, isEdit, cellName, mvParent, options);
    }

    protected void createUI(String viewSetName, String viewName, boolean isEdit, String cellName, MultiView mvParent, int options) {
        this.formView = AppContextMgr.getInstance().getView(viewSetName, viewName);
        if (this.formView == null) {
            log.error((Object)("Couldn't load form with ViewSetName [" + viewSetName + "] View Name [" + viewName + "]"));
            return;
        }
        this.multiView = new MultiView(mvParent, cellName, this.formView, isEdit ? AltViewIFace.CreationMode.EDIT : AltViewIFace.CreationMode.VIEW, options | 0x400, null);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        this.add((Component)this.multiView, "Center");
        if (this.parentWin != null && this.parentWin instanceof JDialog) {
            ((JDialog)this.parentWin).getRootPane().setDefaultButton(this.okBtn);
        }
    }

    public void setFormAdjuster(FormPane.FormPaneAdjusterIFace adjuster) {
        if (adjuster != null && this.multiView != null && this.multiView.getCurrentViewAsFormViewObj() != null) {
            adjuster.adjustForm(this.multiView.getCurrentViewAsFormViewObj());
        }
    }

    public void setOkCancelBtns(JButton okBtn, JButton cancelBtn) {
        this.okBtn = okBtn;
        this.cancelBtn = cancelBtn;
        if (this.doRegOKBtn && this.multiView != null) {
            for (Viewable v : this.multiView.getViewables()) {
                v.registerSaveBtn(okBtn);
            }
        }
        for (Viewable viewable : this.multiView.getViewables()) {
            FormValidator fv = viewable.getValidator();
            if (fv == null) continue;
            fv.setSaveComp(okBtn, FormValidator.EnableType.ValidItems);
        }
        if (okBtn != null) {
            okBtn.addActionListener(this);
        }
        if (cancelBtn != null) {
            cancelBtn.addActionListener(this);
        }
    }

    public boolean isEditMode() {
        return this.multiView.isEditable();
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isOkButton;
        boolean bl = isOkButton = e.getSource() == this.okBtn;
        if (isOkButton) {
            this.multiView.getDataFromUI();
            this.isCancelled = false;
        } else {
            this.isCancelled = true;
        }
    }

    public MultiView getMultiView() {
        return this.multiView;
    }

    public void setData(Object dataObj) {
        if (this.multiView != null) {
            this.multiView.setData(dataObj);
            if (MultiView.isOptionOn(this.multiView.getOptions(), 4)) {
                this.multiView.setIsNewForm(true, false);
            }
            if (this.multiView.getCurrentView() != null && this.multiView.getCurrentView().getValidator() != null) {
                this.multiView.getCurrentView().getValidator().validateForm();
            }
        }
    }

    public void setSession(DataProviderSessionIFace session) {
        this.multiView.setSession(session);
    }

    protected void aboutToShow(boolean show) {
        if (this.multiView != null && !show) {
            this.multiView.aboutToShow(show);
        }
    }

    public void shutdown() {
        if (this.multiView != null) {
            this.multiView.aboutToShutdown();
            this.multiView.shutdown();
        }
        this.formView = null;
        if (this.fieldNames != null) {
            this.fieldNames.clear();
        }
    }
}

