/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayActionAdapter;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayPanel;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;

public class ViewBasedDisplayFrame
extends CustomFrame
implements ViewBasedDisplayIFace,
ActionListener {
    protected ViewBasedDisplayPanel viewBasedPanel = null;
    protected ViewBasedDisplayActionAdapter vbdaa = null;
    protected Object parentDataObj = null;
    protected boolean doSave = false;

    public ViewBasedDisplayFrame(String viewSetName, String viewName, String displayName, String title, String closeBtnTitle, String className, String idFieldName, boolean isEdit, int options) {
        super(title, isEdit ? 3 : 1, null);
        this.viewBasedPanel = new ViewBasedDisplayPanel(this, viewSetName, viewName, displayName, className, idFieldName, isEdit, options | 0x40);
        if (StringUtils.isNotEmpty((String)closeBtnTitle)) {
            this.setOkLabel(closeBtnTitle);
        }
    }

    @Override
    public void createUI() {
        this.setBackground(this.viewBasedPanel.getBackground());
        JScrollPane scrollPane = UIHelper.createScrollPane(this.viewBasedPanel, true);
        scrollPane.setBorder(BorderFactory.createLineBorder(this.getBackground(), 8));
        this.contentPanel = scrollPane;
        super.createUI();
        this.viewBasedPanel.setOkCancelBtns(this.okBtn, this.cancelBtn);
        Integer width = (Integer)UIManager.get("ScrollBar.width");
        if (width == null) {
            width = new JScrollBar().getPreferredSize().width;
        }
        Dimension dim1 = this.getPreferredSize();
        dim1.height += width * 2;
        if (!UIHelper.isMacOS()) {
            dim1.width += width.intValue();
        }
        this.setSize(dim1);
        if (this.cancelBtn != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ViewBasedDisplayFrame.this.cancelBtn.doClick();
                }
            });
        } else if (this.okBtn != null) {
            this.okBtn.setEnabled(true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ViewBasedDisplayFrame.this.okBtn.doClick();
                }
            });
        }
        this.viewBasedPanel.setOkCancelBtns(this.okBtn, this.cancelBtn);
        this.addAL(this.okBtn);
        this.addAL(this.cancelBtn);
        this.addAL(this.applyBtn);
        this.addAL(this.helpBtn);
    }

    @Override
    public void setDoSave(boolean doSave) {
        this.doSave = doSave;
    }

    @Override
    public void setParentData(Object parentDataObj) {
        this.parentDataObj = parentDataObj;
    }

    protected void addAL(JButton btn) {
        if (btn != null) {
            btn.addActionListener(this);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.viewBasedPanel != null && !visible) {
            this.viewBasedPanel.aboutToShow(visible);
        }
        super.setVisible(visible);
    }

    public void setFormAdjuster(FormPane.FormPaneAdjusterIFace adjuster) {
        if (this.viewBasedPanel != null) {
            this.viewBasedPanel.setFormAdjuster(adjuster);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.vbdaa != null) {
            if (e.getSource() == this.okBtn) {
                this.vbdaa.okPressed(this);
            } else if (e.getSource() == this.cancelBtn) {
                this.vbdaa.cancelPressed(this);
            } else if (e.getSource() == this.applyBtn) {
                this.vbdaa.applyPressed(this);
            } else if (e.getSource() == this.helpBtn) {
                this.vbdaa.helpPressed(this);
            }
        }
    }

    @Override
    protected void okButtonPressed() {
        BusinessRulesIFace br;
        FormViewObj fvo;
        if (this.viewBasedPanel.isEditMode() && (fvo = this.viewBasedPanel.getMultiView().getCurrentViewAsFormViewObj()) != null && (br = fvo.getBusinessRules()) != null && fvo.getDataObj() != null) {
            boolean isNewObj = MultiView.isOptionOn(fvo.getMVParent().getOptions(), 4);
            if (this.doSave) {
                if (!fvo.saveObject()) {
                    return;
                }
            } else if (BusinessRulesIFace.STATUS.OK != br.processBusinessRules(this.parentDataObj, fvo.getDataObj(), isNewObj)) {
                UIRegistry.showError(br.getMessagesAsString());
                return;
            }
        }
        super.okButtonPressed();
    }

    @Override
    public void showDisplay(boolean show) {
        this.setVisible(show);
    }

    @Override
    public MultiView getMultiView() {
        return this.viewBasedPanel.getMultiView();
    }

    @Override
    public void setCloseListener(ViewBasedDisplayActionAdapter vbdaa) {
        this.vbdaa = vbdaa;
    }

    @Override
    public void setData(Object dataObj) {
        this.viewBasedPanel.setData(dataObj);
    }

    @Override
    public boolean isEditMode() {
        return this.viewBasedPanel.isEditMode();
    }

    @Override
    public void setSession(DataProviderSessionIFace session) {
        this.viewBasedPanel.setSession(session);
    }

    @Override
    public void shutdown() {
        this.setVisible(true);
        this.viewBasedPanel.shutdown();
        this.vbdaa = null;
    }
}

