/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.db.JAutoCompComboBox;
import edu.ku.brc.af.ui.db.ViewBasedSearchQueryBuilderIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.JPAQuery;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TextFieldWithQuery
extends JPanel
implements CustomQueryListener {
    protected static final Logger log = Logger.getLogger(TextFieldWithQuery.class);
    protected static DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    protected int popupDlgThreshold = 15;
    protected JTextField textField;
    protected Object dataObj = null;
    protected Vector<Integer> idList = new Vector();
    protected Vector<String> list = new Vector();
    protected JPopupMenu popupMenu = null;
    protected JButton dbBtn;
    protected boolean isPopupShowing = false;
    protected AtomicBoolean isDoingQuery = new AtomicBoolean(false);
    protected boolean ignoreFocusLost = false;
    protected boolean tabOutSearch = false;
    protected boolean doAdjustQuery = true;
    protected boolean doAddAddItem = false;
    protected DBTableInfo tableInfo;
    protected DBFieldInfo fieldInfo;
    protected String sql;
    protected String displayColumns;
    protected String format;
    protected String fieldFormatterName;
    protected UIFieldFormatterIFace uiFieldFormatter = null;
    protected String sqlTemplate = null;
    protected ViewBasedSearchQueryBuilderIFace builder = null;
    protected String[] keyColumns;
    protected int numColumns = -1;
    protected Object[] values;
    protected Hashtable<Integer, Object[]> duplicatehash = new Hashtable();
    protected List<ListSelectionListener> listSelectionListeners = new ArrayList<ListSelectionListener>();
    protected PopupMenuListener popupMenuListener = null;
    protected Integer selectedId = null;
    protected String currentText = "";
    protected boolean hasNewText = false;
    protected boolean wasCleared = false;
    protected boolean ignoreDocChange = false;
    protected boolean isReadOnlyMode = false;
    protected AtomicBoolean isDoingCount = new AtomicBoolean(false);
    protected Integer returnCount = null;
    protected String prevEnteredText = null;
    protected String cachedPrevText = null;
    protected String searchedForText = null;
    protected FontMetrics fontMetrics = null;
    protected ExternalQueryProviderIFace externalQueryProvider = null;

    public TextFieldWithQuery(DBTableInfo tableInfo, String keyColumn, String displayColumns, String format, String fieldFormatterName, String sqlTemplate) {
        this.tableInfo = tableInfo;
        this.fieldInfo = tableInfo.getFieldByName(keyColumn);
        this.displayColumns = displayColumns != null ? displayColumns : keyColumn;
        this.format = format;
        this.fieldFormatterName = fieldFormatterName;
        this.sqlTemplate = sqlTemplate;
        if (this.fieldInfo != null && this.fieldInfo.getFormatter() != null) {
            this.uiFieldFormatter = this.fieldInfo.getFormatter();
        } else if (StringUtils.isNotEmpty((String)fieldFormatterName)) {
            this.uiFieldFormatter = UIFieldFormatterMgr.getInstance().getFormatter(fieldFormatterName);
        }
        this.keyColumns = StringUtils.contains((String)keyColumn, (String)",") ? StringUtils.split((String)keyColumn, (String)",") : new String[]{keyColumn};
        this.popupDlgThreshold = AppPreferences.getRemote().getInt("TFQ.POPUPDLD.THRESHOLD", 15);
        this.createUI();
    }

    public void createUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.textField = new JTextField(10);
        UIHelper.setControlSize(this.textField);
        ImageIcon img = IconManager.getIcon("DropDownArrow", IconManager.IconSize.NonStd);
        this.dbBtn = UIHelper.isMacOS() ? new MacGradiantBtn(img) : new JButton(img);
        this.dbBtn.setFocusable(false);
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:d:g,p", "f:p:g"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)this.textField, cc.xy(1, 1));
        pb.add((Component)this.dbBtn, cc.xy(2, 1));
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TextFieldWithQuery.this.cbxKeyReleased(e);
                super.keyReleased(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (TextFieldWithQuery.this.popupMenu != null && TextFieldWithQuery.this.popupMenu.isVisible()) {
                    TextFieldWithQuery.this.popupMenu.setVisible(false);
                }
                super.keyReleased(e);
            }
        });
        this.textField.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                TextFieldWithQuery.this.prevEnteredText = TextFieldWithQuery.this.textField.getText();
                boolean oldWasCleared = TextFieldWithQuery.this.wasCleared;
                if (!TextFieldWithQuery.this.ignoreDocChange) {
                    TextFieldWithQuery.this.wasCleared = TextFieldWithQuery.this.wasCleared || TextFieldWithQuery.this.selectedId != null;
                    TextFieldWithQuery.this.idList.clear();
                    TextFieldWithQuery.this.list.clear();
                    TextFieldWithQuery.this.selectedId = null;
                    if (oldWasCleared != TextFieldWithQuery.this.wasCleared && TextFieldWithQuery.this.wasCleared) {
                        TextFieldWithQuery.this.notifyListenersOfChange(StringUtils.isEmpty((String)TextFieldWithQuery.this.prevEnteredText) ? null : TextFieldWithQuery.this);
                    }
                }
            }
        });
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.keyColumns;
        int n = this.keyColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String k;
            String title = k = stringArray[n2];
            DBFieldInfo fi = this.tableInfo.getFieldByName(k);
            if (fi != null) {
                title = fi.getTitle();
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(title);
            ++n2;
        }
        this.textField.setToolTipText(UIRegistry.getFormattedResStr("TFWQ_SEARCHES_FLDS", sb.toString()));
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                TextFieldWithQuery.this.ignoreFocusLost = false;
                TextFieldWithQuery.this.tabOutSearch = false;
                int len = TextFieldWithQuery.this.textField.getText().length();
                if (len > 0) {
                    TextFieldWithQuery.this.textField.setCaretPosition(0);
                    TextFieldWithQuery.this.textField.selectAll();
                }
                TextFieldWithQuery.this.wasCleared = false;
                super.focusGained(arg0);
            }

            @Override
            public void focusLost(FocusEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextFieldWithQuery.this.focusLostFromTexField();
                    }
                });
                super.focusLost(event);
            }
        });
        this.dbBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextFieldWithQuery.this.popupMenu != null && TextFieldWithQuery.this.popupMenu.isVisible()) {
                    TextFieldWithQuery.this.popupMenu.setVisible(false);
                }
                log.debug((Object)("currentText: " + TextFieldWithQuery.this.currentText));
                TextFieldWithQuery.this.doQuery(TextFieldWithQuery.this.currentText);
            }
        });
    }

    public void setReadOnlyMode() {
        this.isReadOnlyMode = true;
        ViewFactory.changeTextFieldUIForDisplay(this.textField, false);
        this.dbBtn.setVisible(false);
    }

    public void setIgnoreFocusLost(boolean ignoreFocusLost) {
        this.ignoreFocusLost = ignoreFocusLost;
    }

    protected void focusLostFromTexField() {
        if (this.selectedId == null && !this.ignoreFocusLost) {
            int len = this.textField.getText().length();
            if (len > 0) {
                this.tabOutSearch = true;
                this.doQuery(this.currentText);
            } else {
                this.setText("");
                if (this.wasCleared) {
                    this.notifyListenersOfChange(this);
                }
            }
        }
        this.textField.setCaretPosition(0);
    }

    public String getPrevEnteredText() {
        if (StringUtils.isEmpty((String)this.prevEnteredText) && StringUtils.isNotEmpty((String)this.cachedPrevText)) {
            return this.cachedPrevText;
        }
        return this.prevEnteredText;
    }

    public void setPrevEnteredText(String prevEnteredText) {
        this.prevEnteredText = prevEnteredText;
        this.cachedPrevText = prevEnteredText;
    }

    public String getCachedPrevText() {
        return this.cachedPrevText;
    }

    public void setCachedPrevText(String cachedPrevText) {
        this.cachedPrevText = cachedPrevText;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFieldFormatterName() {
        return this.fieldFormatterName;
    }

    public UIFieldFormatterIFace getUiFieldFormatter() {
        return this.uiFieldFormatter;
    }

    public void setExternalQueryProvider(ExternalQueryProviderIFace externalQueryProvider) {
        this.externalQueryProvider = externalQueryProvider;
    }

    public void setSqlTemplate(String sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.dbBtn.setEnabled(enabled);
    }

    public void setPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.popupMenuListener = popupMenuListener;
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listSelectionListeners.add(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listSelectionListeners.remove(l);
    }

    public void setAddAddItem(boolean addAddItem) {
        this.doAddAddItem = addAddItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void cbxKeyReleased(KeyEvent ev) {
        block9: {
            block8: {
                if (this.isReadOnlyMode) {
                    return;
                }
                if (ev.getKeyCode() == 9 || ev.getKeyCode() == 16 || ev.getKeyCode() == 37 || ev.getKeyCode() == 39 || ev.getKeyCode() == 17 || ev.getKeyCode() == 157) {
                    return;
                }
                this.currentText = this.textField.getText();
                if (this.uiFieldFormatter != null) {
                    this.currentText = this.uiFieldFormatter.formatFromUI(this.currentText).toString();
                }
                if (this.currentText.length() != 0 && this.hasNewText) break block8;
                if (ev.getKeyCode() != JAutoCompComboBox.SEARCH_KEY && ev.getKeyCode() != 40) {
                    if (ev.getKeyCode() != 10) {
                        this.wasCleared = this.selectedId != null;
                        this.idList.clear();
                        this.list.clear();
                        this.selectedId = null;
                        this.hasNewText = true;
                    }
                    break block9;
                } else {
                    this.showPopup();
                    return;
                }
            }
            this.hasNewText = true;
        }
        if (ev.getKeyCode() == JAutoCompComboBox.SEARCH_KEY || ev.getKeyCode() == 40) {
            String text = this.textField.getText();
            if (this.uiFieldFormatter != null && !this.uiFieldFormatter.isNumeric()) {
                text = this.uiFieldFormatter.formatFromUI(text).toString();
            }
            text = StringUtils.replace((String)text, (String)"'", (String)"'");
            text = StringUtils.replace((String)text, (String)"\"", (String)"\\\"");
            this.doQuery(text);
        }
    }

    public void setText(String text) {
        this.ignoreDocChange = true;
        if (this.uiFieldFormatter != null && StringUtils.isNotEmpty((String)text)) {
            this.textField.setText(this.uiFieldFormatter.formatToUI(text).toString());
        } else {
            this.textField.setText(text);
        }
        this.ignoreDocChange = false;
    }

    protected void itemSelected(JMenuItem mi) {
        this.hasNewText = false;
        String selectedStr = mi.getText();
        int inx = this.popupMenu.getComponentIndex(mi);
        if (inx > -1) {
            if (!(this.idList.size() <= 0 || this.doAddAddItem && inx <= 0)) {
                this.selectedId = this.idList.get(this.doAddAddItem ? inx - 1 : inx);
                this.setText(selectedStr);
            }
            if (this.listSelectionListeners != null) {
                this.notifyListenersOfChange(mi);
            }
        }
    }

    protected void showPopup() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.hasNewText || this.currentText.length() == 0) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextFieldWithQuery.this.itemSelected((JMenuItem)e.getSource());
                }
            };
            this.popupMenu = new JPopupMenu();
            if (this.popupMenuListener != null) {
                this.popupMenu.addPopupMenuListener(this.popupMenuListener);
            }
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    TextFieldWithQuery.this.isPopupShowing = false;
                    TextFieldWithQuery.this.ignoreFocusLost = false;
                    TextFieldWithQuery.this.cachedPrevText = null;
                    if (TextFieldWithQuery.this.selectedId == null) {
                        TextFieldWithQuery.this.setText("");
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TextFieldWithQuery.this.isPopupShowing = false;
                    TextFieldWithQuery.this.ignoreFocusLost = false;
                    TextFieldWithQuery.this.cachedPrevText = TextFieldWithQuery.this.prevEnteredText;
                    if (TextFieldWithQuery.this.selectedId == null) {
                        TextFieldWithQuery.this.setText("");
                    }
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    TextFieldWithQuery.this.cachedPrevText = null;
                    TextFieldWithQuery.this.isPopupShowing = true;
                }
            });
            if (this.doAddAddItem) {
                JMenuItem mi = new JMenuItem(UIRegistry.getResourceString("TFWQ_ADD_LABEL"));
                UIHelper.setControlSize(mi);
                this.popupMenu.add(mi);
                mi.addActionListener(al);
            }
            Iterator<String> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                String str;
                String label = str = iterator.next();
                if (this.uiFieldFormatter != null) {
                    label = this.uiFieldFormatter.formatToUI(label).toString();
                }
                JMenuItem mi = new JMenuItem(label);
                UIHelper.setControlSize(mi);
                this.popupMenu.add(mi);
                mi.addActionListener(al);
            }
        }
        if (this.popupMenu != null) {
            if (this.list.size() > 0 || this.doAddAddItem) {
                UIHelper.addSpecialKeyListenerForPopup(this.popupMenu);
                final Point location = this.getLocation();
                final Dimension size = this.getSize();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextFieldWithQuery.this.ignoreFocusLost = true;
                        TextFieldWithQuery.this.popupMenu.setInvoker(TextFieldWithQuery.this);
                        TextFieldWithQuery.this.popupMenu.show(TextFieldWithQuery.this, location.x, location.y + size.height);
                        Dimension popupSize = TextFieldWithQuery.this.popupMenu.getPreferredSize();
                        TextFieldWithQuery.this.popupMenu.setPopupSize(Math.max(size.width, popupSize.width), popupSize.height);
                        TextFieldWithQuery.this.popupMenu.requestFocus();
                    }
                });
            } else {
                this.popupMenu = null;
            }
        }
    }

    protected void addTblAbbrev(String abbrev, String fld, StringBuilder selectSB) {
        if (!StringUtils.contains((String)fld, (char)'.')) {
            selectSB.append(this.tableInfo.getAbbrev());
            selectSB.append(".");
        }
        selectSB.append(fld.trim());
    }

    public void setDoAdjustQuery(boolean doAdjustQuery) {
        this.doAdjustQuery = doAdjustQuery;
    }

    protected String buildSQL(String newEntryStr, boolean isForCount) {
        String extraWhereClause;
        String fullSQLStr;
        if (this.externalQueryProvider != null && StringUtils.isNotEmpty((String)(fullSQLStr = this.externalQueryProvider.getFullSQL(newEntryStr, isForCount)))) {
            return fullSQLStr;
        }
        StringBuilder whereSB = new StringBuilder();
        if (this.keyColumns.length > 1) {
            whereSB.append("(");
        }
        int cnt = 0;
        String[] stringArray = this.keyColumns;
        int n = this.keyColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String keyCol = stringArray[n2];
            if (cnt > 0) {
                whereSB.append(" OR ");
            }
            whereSB.append(" LOWER(");
            whereSB.append(String.valueOf(this.tableInfo.getAbbrev()) + "." + keyCol);
            whereSB.append(") LIKE '");
            if (this.uiFieldFormatter != null && this.uiFieldFormatter.isNumeric()) {
                whereSB.append("%");
            }
            whereSB.append(newEntryStr.toLowerCase());
            whereSB.append("%' ");
            ++cnt;
            ++n2;
        }
        if (this.keyColumns.length > 1) {
            whereSB.append(")");
        }
        if (this.externalQueryProvider != null && StringUtils.isNotEmpty((String)(extraWhereClause = this.externalQueryProvider.getExtraWhereClause()))) {
            whereSB.append(' ');
            whereSB.append(extraWhereClause);
        }
        if (StringUtils.isNotEmpty((String)this.sqlTemplate)) {
            StringBuilder selectSB = new StringBuilder();
            if (isForCount) {
                selectSB.append("count(");
                this.addTblAbbrev(this.tableInfo.getAbbrev(), this.tableInfo.getIdFieldName(), selectSB);
                selectSB.append(")");
            } else {
                if (StringUtils.contains((String)this.displayColumns, (char)',')) {
                    int fCnt = 0;
                    String[] stringArray2 = StringUtils.split((String)this.displayColumns, (char)',');
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String fld = stringArray2[n4];
                        if (fCnt > 0) {
                            selectSB.append(", ");
                        }
                        this.addTblAbbrev(this.tableInfo.getAbbrev(), fld, selectSB);
                        ++fCnt;
                        ++n4;
                    }
                } else {
                    this.addTblAbbrev(this.tableInfo.getAbbrev(), this.displayColumns, selectSB);
                }
                selectSB.append(", ");
                this.addTblAbbrev(this.tableInfo.getAbbrev(), this.tableInfo.getIdFieldName(), selectSB);
            }
            this.sql = StringUtils.replace((String)this.sqlTemplate, (String)"%s1", (String)selectSB.toString());
            this.sql = StringUtils.replace((String)this.sql, (String)"%s2", (String)whereSB.toString());
            if (this.doAdjustQuery) {
                this.sql = QueryAdjusterForDomain.getInstance().adjustSQL(this.sql);
            }
            return this.sql;
        }
        if (this.sql == null) {
            StringBuilder sb = new StringBuilder();
            if (QueryAdjusterForDomain.getInstance().isUserInputNotInjectable(newEntryStr)) {
                String extraWhereClause2;
                String specialCols;
                String joinSnipet;
                sb.append("SELECT ");
                if (isForCount) {
                    sb.append("count(");
                    sb.append(String.valueOf(this.tableInfo.getAbbrev()) + "." + this.tableInfo.getIdFieldName());
                    sb.append(")");
                } else {
                    sb.append(String.valueOf(this.tableInfo.getAbbrev()) + "." + this.displayColumns);
                    sb.append(",");
                    sb.append(String.valueOf(this.tableInfo.getAbbrev()) + "." + this.tableInfo.getIdFieldName());
                }
                sb.append(" FROM ");
                sb.append(this.tableInfo.getClassName());
                sb.append(" as ");
                sb.append(this.tableInfo.getAbbrev());
                String string = joinSnipet = this.doAdjustQuery ? QueryAdjusterForDomain.getInstance().getJoinClause(this.tableInfo, true, null, false) : null;
                if (joinSnipet != null) {
                    sb.append(' ');
                    sb.append(joinSnipet);
                    sb.append(' ');
                }
                sb.append(" WHERE ");
                String string2 = specialCols = this.doAdjustQuery ? QueryAdjusterForDomain.getInstance().getSpecialColumns(this.tableInfo, true) : null;
                if (StringUtils.isNotEmpty(specialCols)) {
                    if (whereSB.length() > 0) {
                        whereSB.append(" AND ");
                    }
                    whereSB.append(specialCols);
                }
                if (this.externalQueryProvider != null && StringUtils.isNotEmpty((String)(extraWhereClause2 = this.externalQueryProvider.getExtraWhereClause()))) {
                    whereSB.append(' ');
                    whereSB.append(extraWhereClause2);
                }
                whereSB.append(" ORDER BY ");
                cnt = 0;
                String[] stringArray3 = this.keyColumns;
                int n5 = this.keyColumns.length;
                int n6 = 0;
                while (n6 < n5) {
                    String keyCol = stringArray3[n6];
                    if (cnt > 0) {
                        whereSB.append(", ");
                    }
                    whereSB.append(keyCol);
                    whereSB.append(" ASC");
                    ++cnt;
                    ++n6;
                }
                sb.append(whereSB.toString());
            }
            return sb.toString();
        }
        return this.sql;
    }

    private void processResults(CustomQueryIFace customQuery) {
        this.searchedForText = this.prevEnteredText;
        List<?> dataObjList = customQuery.getDataObjects();
        if (dataObjList == null || dataObjList.size() == 0) {
            if (this.doAddAddItem) {
                this.showPopup();
            }
        } else {
            Dimension dim = this.getSize();
            if (this.fontMetrics == null) {
                Font font = this.getFont();
                BufferedImage bi = new BufferedImage(1, 1, 1);
                this.fontMetrics = bi.getGraphics().getFontMetrics(font);
            }
            boolean isFirst = true;
            this.duplicatehash.clear();
            for (Object obj : dataObjList) {
                Object[] array = (Object[])obj;
                if (isFirst) {
                    this.numColumns = array.length - 1;
                    this.values = new Object[this.numColumns];
                    isFirst = false;
                }
                Integer id = (Integer)array[this.numColumns];
                this.idList.addElement(id);
                if (this.duplicatehash.get(id) != null) continue;
                this.duplicatehash.put(id, array);
                if (this.numColumns == 1) {
                    Object value = array[0].toString();
                    if (this.uiFieldFormatter != null) {
                        value = this.uiFieldFormatter.formatToUI(value);
                    } else if (StringUtils.isNotEmpty((String)this.format)) {
                        value = UIHelper.getFormattedValue(this.format, value);
                    }
                    this.list.addElement(value.toString());
                    continue;
                }
                try {
                    int i = 0;
                    while (i < this.numColumns) {
                        Object val = array[i];
                        if (val instanceof Calendar) {
                            val = scrDateFormat.format((Calendar)val);
                        } else if (val instanceof Date) {
                            val = scrDateFormat.format((Date)val);
                        }
                        if (val instanceof FormDataObjIFace) {
                            val = ((FormDataObjIFace)val).getIdentityTitle();
                        }
                        this.values[i] = val != null ? val : null;
                        ++i;
                    }
                    String valStr = (String)UIHelper.getFormattedValue(this.format, this.values);
                    if (this.returnCount <= this.popupDlgThreshold && this.fontMetrics.stringWidth(valStr) > dim.width) {
                        int len = valStr.length() - 5;
                        while (len > 25) {
                            if (this.fontMetrics.stringWidth(valStr = valStr.substring(0, len)) < dim.width) {
                                valStr = String.valueOf(valStr) + "...";
                                break;
                            }
                            len -= 5;
                        }
                    }
                    if (valStr.endsWith(", ")) {
                        valStr = valStr.substring(0, valStr.length() - 2);
                    }
                    this.list.addElement(valStr);
                }
                catch (IllegalFormatConversionException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TextFieldWithQuery.class, ex);
                    ex.printStackTrace();
                    this.list.addElement(this.values[0] != null ? this.values[0].toString() : "(No Value)");
                }
            }
            if (this.idList.size() > 0 && this.returnCount != null) {
                if (this.tabOutSearch && this.idList.size() == 1) {
                    this.selectedId = this.idList.elementAt(0);
                    this.setText(this.list.get(0));
                    this.notifyListenersOfChange(this.textField);
                } else if (this.returnCount > this.popupDlgThreshold) {
                    this.showDialog();
                } else {
                    this.showPopup();
                }
            } else {
                this.setText("");
            }
            this.duplicatehash.clear();
        }
    }

    public boolean hasId() {
        return this.selectedId != null;
    }

    private void notifyListenersOfChange(Object source) {
        if (this.listSelectionListeners != null) {
            ListSelectionEvent lse = source == null ? null : new ListSelectionEvent(source, 0, 0, false);
            for (ListSelectionListener l : this.listSelectionListeners) {
                l.valueChanged(lse);
            }
        }
    }

    protected void showDialog() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (this.doAddAddItem) {
            model.addElement(UIRegistry.getResourceString("TFWQ_ADD_LABEL"));
        }
        for (String val : this.list) {
            model.addElement(val);
        }
        JList listBox = new JList(model);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("TFWQ_CHOOSE_LABEL"), 0), "North");
        panel.add((Component)UIHelper.createScrollPane(listBox, true), "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.hasNewText = false;
        Window mostRecent = UIRegistry.getMostRecentWindow();
        class PopUpDialog
        extends CustomDialog {
            protected JList pListBox;
            private final /* synthetic */ JList val$listBox;

            public PopUpDialog(Frame frame, boolean isModal, Component contentPanel, JList pListBoxArg, JList jList) throws HeadlessException {
                this.val$listBox = jList;
                super(frame, UIRegistry.getResourceString("TFWQ_CHOOSE_TITLE"), isModal, contentPanel);
                this.pListBox = pListBoxArg;
                this.initialize();
            }

            public PopUpDialog(Dialog dialog, boolean isModal, Component contentPanel, JList pListBoxArg, JList jList) throws HeadlessException {
                this.val$listBox = jList;
                super(dialog, UIRegistry.getResourceString("TFWQ_CHOOSE_TITLE"), isModal, 3, contentPanel);
                this.pListBox = pListBoxArg;
                this.initialize();
            }

            protected void initialize() {
                this.pListBox.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting() && okBtn != null && pListBox != null) {
                            okBtn.setEnabled(val$listBox.getSelectedIndex() != -1);
                        }
                    }
                });
                this.pListBox.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        super.mouseClicked(e);
                        if (e.getClickCount() == 2) {
                            okBtn.setEnabled(true);
                            okBtn.doClick();
                        }
                    }
                });
            }

            @Override
            public void setVisible(boolean visible) {
                if (visible) {
                    this.val$listBox.setSelectedIndex(TextFieldWithQuery.this.doAddAddItem ? 1 : 0);
                }
                super.setVisible(visible);
            }
        }
        PopUpDialog dlg = mostRecent instanceof Dialog ? new PopUpDialog((Dialog)UIRegistry.getMostRecentWindow(), true, (Component)panel, listBox, listBox) : new PopUpDialog((Frame)UIRegistry.getMostRecentWindow(), true, (Component)panel, listBox, listBox);
        ((CustomDialog)dlg).setVisible(true);
        if (!dlg.isCancelled()) {
            int inx = listBox.getSelectedIndex();
            boolean isDoingAdd = inx == 0 && this.doAddAddItem;
            int n = inx = this.doAddAddItem ? inx - 1 : inx;
            if (!isDoingAdd && inx < this.idList.size()) {
                this.selectedId = this.idList.get(inx);
                this.setText(this.list.get(inx));
            }
            this.notifyListenersOfChange(listBox);
        } else {
            this.setText("");
        }
    }

    @Override
    public void exectionDone(CustomQueryIFace customQuery) {
        if (this.isDoingCount.get()) {
            List<?> dataObjList = customQuery.getDataObjects();
            if (dataObjList != null && dataObjList.size() > 0) {
                this.returnCount = (Integer)dataObjList.get(0);
            }
            if (this.returnCount != null && this.returnCount == 0) {
                this.processResults(new EmptyCustomQuery(customQuery));
                this.isDoingQuery.set(false);
                return;
            }
            this.list.clear();
            this.idList.clear();
            String sqlStr = null;
            if (this.builder != null) {
                sqlStr = this.builder.buildSQL(((JPAQuery)customQuery).getData().toString(), false);
            }
            if (sqlStr == null) {
                sqlStr = this.buildSQL(((JPAQuery)customQuery).getData().toString(), false);
            }
            JPAQuery jpaQuery = new JPAQuery(sqlStr, (CustomQueryListener)this);
            this.isDoingCount.set(false);
            jpaQuery.start();
        } else {
            this.processResults(customQuery);
            this.isDoingQuery.set(false);
        }
    }

    @Override
    public void executionError(CustomQueryIFace customQuery) {
        this.isDoingQuery.set(false);
    }

    protected void doQuery(String newEntryStrArg) {
        UIRegistry.getStatusBar().setText("");
        if (StringUtils.isEmpty((String)newEntryStrArg)) {
            return;
        }
        ESTermParser parser = ESTermParser.getInstance();
        if (parser.parse(newEntryStrArg, true)) {
            String newEntryStr;
            this.prevEnteredText = newEntryStr = parser.getFields().get(0).getTerm();
            if (!this.isDoingQuery.get()) {
                if (this.hasNewText) {
                    this.isDoingQuery.set(true);
                    this.isDoingCount.set(true);
                    this.list.clear();
                    this.idList.clear();
                    this.returnCount = null;
                    String newSql = null;
                    if (this.builder != null) {
                        newSql = this.builder.buildSQL(newEntryStr, true);
                    }
                    if (newSql == null) {
                        newSql = this.buildSQL(newEntryStr, true);
                    }
                    if (StringUtils.isBlank(newSql)) {
                        Toolkit.getDefaultToolkit().beep();
                        UIRegistry.displayLocalizedStatusBarError("TFWQ_InvalidEntry", newEntryStr);
                        this.isDoingQuery.set(false);
                        this.isDoingCount.set(false);
                    } else {
                        JPAQuery jpaQuery = new JPAQuery(newSql, (CustomQueryListener)this);
                        jpaQuery.setUnique(true);
                        jpaQuery.setData(newEntryStr);
                        jpaQuery.start();
                    }
                } else if (this.returnCount != null && this.returnCount > this.popupDlgThreshold) {
                    this.showDialog();
                } else {
                    this.showPopup();
                }
            }
        } else {
            this.showPopup();
        }
    }

    public List<String> getList() {
        return this.list;
    }

    public Integer getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(Integer selectedId) {
        this.selectedId = selectedId;
        this.wasCleared = true;
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void clearSelection() {
        this.list.clear();
        this.idList.clear();
        this.selectedId = null;
        this.hasNewText = false;
        this.wasCleared = true;
        this.currentText = "";
    }

    public boolean hasItem() {
        return this.selectedId != null;
    }

    public void clearSearch() {
        this.setText("");
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public ViewBasedSearchQueryBuilderIFace getBuilder() {
        return this.builder;
    }

    public void setBuilder(ViewBasedSearchQueryBuilderIFace builder) {
        this.builder = builder;
    }

    class EmptyCustomQuery
    implements CustomQueryIFace {
        private CustomQueryIFace cqi;

        public EmptyCustomQuery(CustomQueryIFace cqi) {
            this.cqi = cqi;
        }

        @Override
        public void cancel() {
        }

        @Override
        public boolean execute() {
            return false;
        }

        @Override
        public void execute(CustomQueryListener cql) {
        }

        @Override
        public List<?> getDataObjects() {
            return new ArrayList();
        }

        @Override
        public String getName() {
            return this.cqi.getName();
        }

        @Override
        public List<QueryResultsContainerIFace> getQueryDefinition() {
            return this.cqi.getQueryDefinition();
        }

        @Override
        public List<QueryResultsDataObj> getResults() {
            return new ArrayList<QueryResultsDataObj>();
        }

        @Override
        public List<Integer> getTableIds() {
            return this.cqi.getTableIds();
        }

        @Override
        public boolean isCancelled() {
            return this.cqi.isCancelled();
        }

        @Override
        public boolean isInError() {
            return this.cqi.isInError();
        }

        @Override
        public int getMaxResults() {
            return 0;
        }

        @Override
        public void setMaxResults(int maxResults) {
        }
    }

    public static interface ExternalQueryProviderIFace {
        public String getExtraWhereClause();

        public String getFullSQL(String var1, boolean var2);
    }

    class MacGradiantBtn
    extends JButton {
        protected ImageIcon imgIcon;
        protected boolean isPressed;
        protected Color top1;
        protected Color top2;
        protected Color bot1;
        protected Color bot2;
        protected Color topDarker1;
        protected Color topDarker2;
        protected Color botDarker1;
        protected Color botDarker2;

        public MacGradiantBtn(ImageIcon imgIcon) {
            super(imgIcon);
            this.isPressed = false;
            this.top1 = new Color(184, 217, 250);
            this.top2 = new Color(120, 180, 241);
            this.bot1 = new Color(74, 155, 236);
            this.bot2 = new Color(179, 248, 255);
            this.imgIcon = imgIcon;
            this.topDarker1 = UIHelper.changeColorBrightness(this.top1, 0.95);
            this.topDarker2 = UIHelper.changeColorBrightness(this.top2, 0.95);
            this.botDarker1 = UIHelper.changeColorBrightness(this.bot1, 0.95);
            this.botDarker2 = UIHelper.changeColorBrightness(this.bot2, 0.95);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    MacGradiantBtn.this.isPressed = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    MacGradiantBtn.this.isPressed = false;
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.isEnabled()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth() - 6;
                int h = this.getHeight() - 6;
                int x = 3;
                int y = 3;
                this.drawButtonBody(g2, x, y, w, h / 2 + 4, this.isPressed ? this.topDarker1 : this.top1, this.isPressed ? this.topDarker2 : this.top2);
                this.drawButtonBody(g2, x, y + h / 2, w, h / 2, this.isPressed ? this.botDarker1 : this.bot1, this.isPressed ? this.botDarker2 : this.bot2);
                x = (this.getWidth() - this.imgIcon.getIconWidth()) / 2;
                y = (this.getHeight() - this.imgIcon.getIconHeight()) / 2;
                g.drawImage(this.imgIcon.getImage(), x, y, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
            }
        }

        protected void drawButtonBody(Graphics2D g2, int x, int y, int w, int h, Color color, Color color2) {
            GradientPaint bg = new GradientPaint(new Point(x, y), color, new Point(x, y + h), color2);
            g2.setPaint(bg);
            g2.fillRoundRect(x, y, w, h, 6, 6);
        }
    }
}

