/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayActionAdapter;
import edu.ku.brc.af.ui.db.ViewBasedDisplayFrame;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.forms.DataGetterForObj;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TextFieldWithInfo
extends JPanel
implements GetSetValueIFace,
AppPrefsChangeListener {
    protected static final Logger log = Logger.getLogger(TextFieldWithInfo.class);
    protected static ColorWrapper valtextcolor = null;
    protected static ColorWrapper requiredfieldcolor = null;
    protected boolean isInError = false;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected Color bgColor = null;
    protected JTextField textField;
    protected JButton infoBtn = null;
    protected String className;
    protected String idName;
    protected String keyName;
    protected String format;
    protected String uiFieldFormatterName;
    protected String dataObjFormatterName;
    protected Class<?> classObj = null;
    protected DataGetterForObj getter = null;
    protected String displayInfoDialogName;
    protected String[] fieldNames;
    protected Object dataObj = null;
    protected String frameTitle = null;
    protected boolean isRestricted;
    protected String restrictedStr;
    protected ViewBasedDisplayIFace frame = null;
    protected MultiView multiView = null;

    public TextFieldWithInfo(String className, String idName, String keyName, String format, String uiFieldFormatterName, String dataObjFormatterName, String displayInfoDialogName, String objTitle) {
        this.className = className;
        this.idName = idName;
        this.keyName = keyName;
        this.format = format;
        this.uiFieldFormatterName = uiFieldFormatterName;
        this.displayInfoDialogName = displayInfoDialogName;
        this.dataObjFormatterName = dataObjFormatterName;
        this.textField = new JTextField();
        this.init(objTitle);
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(this.classObj.getSimpleName());
        this.restrictedStr = FormHelper.checkForRestrictedValue(tableInfo);
        if (this.restrictedStr != null) {
            this.isRestricted = true;
        }
    }

    public void setFrameTitle(String frameTitle) {
        this.frameTitle = frameTitle;
    }

    public void setMultiView(MultiView multiView) {
        this.multiView = multiView;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setDisplayInfoDialogName(String displayInfoDialogName) {
        this.displayInfoDialogName = displayInfoDialogName;
    }

    protected void createInfoFrame() {
        this.frame = UIRegistry.getViewbasedFactory().createDisplay(UIHelper.getWindow(this), this.displayInfoDialogName, this.frameTitle, UIRegistry.getResourceString("CLOSE"), false, 768, null, ViewBasedDialogFactoryIFace.FRAME_TYPE.FRAME);
        if (this.frame == null) {
            return;
        }
        if (this.multiView != null) {
            this.multiView.registerDisplayFrame(this.frame);
        }
        this.frame.setCloseListener(new ViewBasedDisplayActionAdapter(){

            @Override
            public boolean okPressed(ViewBasedDisplayIFace vbd) {
                if (TextFieldWithInfo.this.frame != null) {
                    if (TextFieldWithInfo.this.multiView != null) {
                        TextFieldWithInfo.this.multiView.unregisterDisplayFrame(TextFieldWithInfo.this.frame);
                    }
                    TextFieldWithInfo.this.frame.dispose();
                    TextFieldWithInfo.this.frame = null;
                }
                return true;
            }
        });
        this.frame.setData(this.dataObj);
        this.frame.showDisplay(true);
        if (this.frame instanceof ViewBasedDisplayFrame) {
            this.frame.getOkBtn().setEnabled(true);
        }
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnabled(enabled);
    }

    private void updateEnabled(boolean enabled) {
        boolean isEnabled = enabled;
        if (this.isRestricted) {
            isEnabled = false;
        }
        this.textField.setEnabled(isEnabled);
        if (this.infoBtn != null) {
            this.infoBtn.setEnabled(isEnabled && this.dataObj != null);
        }
    }

    public void init(String objTitle) {
        UIHelper.setControlSize(this.textField);
        this.fieldNames = StringUtils.split((String)StringUtils.deleteWhitespace((String)this.keyName), (String)",");
        try {
            this.classObj = Class.forName(this.className);
        }
        catch (ClassNotFoundException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TextFieldWithInfo.class, ex);
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        PanelBuilder builder = new PanelBuilder(new FormLayout("p:g,1px,p", "c:p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.textField, cc.xy(1, 1));
        if (StringUtils.isNotEmpty((String)this.displayInfoDialogName)) {
            this.infoBtn = new JButton(IconManager.getIcon("InfoIcon", IconManager.IconSize.Std16));
            this.infoBtn.setToolTipText(String.format(UIRegistry.getResourceString("ShowRecordInfoTT"), objTitle));
            this.infoBtn.setFocusable(false);
            this.infoBtn.setMargin(new Insets(1, 1, 1, 1));
            this.infoBtn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            builder.add((Component)this.infoBtn, cc.xy(3, 1));
            this.infoBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextFieldWithInfo.this.createInfoFrame();
                }
            });
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.bgColor = this.textField.getBackground();
        if (valtextcolor == null || requiredfieldcolor == null) {
            valtextcolor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredfieldcolor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
        }
        AppPreferences.getRemote().addChangeListener("ui.formatting.requiredfieldcolor", this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isInError && this.textField.isEnabled()) {
            Dimension dim = this.getSize();
            g.setColor(valtextcolor.getColor());
            g.drawRect(0, 0, dim.width - 1, dim.height - 1);
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.dataObj = value;
        this.updateEnabled(value != null);
        if (this.isRestricted) {
            this.textField.setText(this.restrictedStr);
            return;
        }
        if (value != null) {
            String restricted = FormHelper.checkForRestrictedValue(this.dataObj);
            if (restricted != null) {
                this.textField.setText(restricted);
                this.textField.setCaretPosition(0);
                return;
            }
            if (this.getter == null) {
                this.getter = new DataGetterForObj();
            }
            Object newVal = value;
            if (StringUtils.isEmpty((String)this.dataObjFormatterName)) {
                Object[] val = UIHelper.getFieldValues(this.fieldNames, this.dataObj, (DataObjectGettable)this.getter);
                UIFieldFormatterIFace uiFieldFormatter = UIFieldFormatterMgr.getInstance().getFormatter(this.uiFieldFormatterName);
                newVal = uiFieldFormatter != null ? uiFieldFormatter.formatFromUI(val[0]).toString() : (StringUtils.isNotEmpty((String)this.format) ? UIHelper.getFormattedValue(this.format, val) : this.dataObj);
            } else {
                newVal = DataObjFieldFormatMgr.getInstance().format(value, this.dataObjFormatterName);
            }
            this.textField.setText(newVal != null ? newVal.toString() : "");
            this.textField.setCaretPosition(0);
        } else {
            this.textField.setText("");
            this.isInError = this.isRequired;
        }
        if (this.frame != null) {
            this.frame.setData(this.dataObj);
        }
    }

    @Override
    public Object getValue() {
        return this.dataObj;
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("requiredfieldcolor")) {
            this.textField.setBackground(this.isRequired && this.isEnabled() ? requiredfieldcolor.getColor() : this.bgColor);
        }
    }
}

