/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class TextFieldFromPickListTable
extends JTextField
implements GetSetValueIFace,
AppPrefsChangeListener {
    protected Object dataObj = null;
    protected PickListDBAdapterIFace adapter;
    protected Integer nullIndex = null;

    public TextFieldFromPickListTable(PickListDBAdapterIFace adapter, int cols) {
        super(Math.max(cols, 10));
        UIHelper.setControlSize(this);
        this.adapter = adapter;
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.dataObj = value;
        if (value != null) {
            if (this.adapter == null) {
                this.setText(value.toString());
                return;
            }
            if (this.adapter.isTabledBased()) {
                String data = null;
                boolean isFormObjIFace = value instanceof FormDataObjIFace;
                Vector<PickListItemIFace> items = this.adapter.getList();
                int i = 0;
                while (i < items.size()) {
                    PickListItemIFace pli = items.get(i);
                    Object valObj = pli.getValueObject();
                    if (valObj != null) {
                        if (isFormObjIFace && valObj instanceof FormDataObjIFace) {
                            if (((FormDataObjIFace)value).getId().intValue() == ((FormDataObjIFace)valObj).getId().intValue()) {
                                data = pli.getTitle();
                                break;
                            }
                        } else if (pli.getValue().equals(value.toString())) {
                            data = pli.getTitle();
                            break;
                        }
                    }
                    ++i;
                }
                if (data == null) {
                    data = StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : "";
                }
                this.setText(data);
            } else {
                boolean fnd = false;
                this.setText("");
                for (PickListItemIFace item : this.adapter.getList()) {
                    if (item.getValue() == null && value == null) break;
                    if (item.getValue() == null || value == null || !item.getValue().equals(value.toString())) continue;
                    this.setText(item.getTitle());
                    fnd = true;
                    break;
                }
                if (!fnd && !this.adapter.isReadOnly()) {
                    this.setText(value != null ? value.toString() : defaultValue);
                }
            }
            this.repaint();
        } else if (this.nullIndex == null) {
            if (this.adapter != null) {
                int inx = 0;
                for (PickListItemIFace item : this.adapter.getList()) {
                    if (item != null && item.getValue() != null && item.getValue().equals("|null|")) {
                        this.nullIndex = inx;
                        this.setText(item.getTitle());
                        break;
                    }
                    ++inx;
                }
                if (this.nullIndex == null) {
                    this.nullIndex = -1;
                }
            }
        } else {
            if (this.nullIndex > -1) {
                PickListItemIFace item = this.adapter.getList().get(this.nullIndex);
                if (item != null) {
                    this.setText(item.getTitle());
                }
                return;
            }
            if (this.nullIndex == -1) {
                this.setText("");
            }
        }
    }

    public PickListDBAdapterIFace getAdapter() {
        return this.adapter;
    }

    public void setAdapter(PickListDBAdapterIFace adapter) {
        this.adapter = adapter;
    }

    public PickListDBAdapterIFace getPickListAdapter() {
        return this.adapter;
    }

    @Override
    public Object getValue() {
        return this.dataObj;
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        evt.getKey().equals("valtextcolor");
    }
}

