/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.specify.datamodel.PickList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PropertiesPickListAdapter
implements PickListDBAdapterIFace {
    protected static final Logger log = Logger.getLogger(PropertiesPickListAdapter.class);
    protected static PickListItemIFace searchablePLI = null;
    protected String prefName;
    protected String prefSelectedName;
    protected ValComboBox comboBox;
    protected boolean savePickList = true;
    protected Vector<PickListItemIFace> items = new Vector();
    protected PickListIFace pickList = null;
    protected boolean doAutoSaveOnAdd = true;
    protected Vector<ChangeListener> changeListeners = new Vector();

    public PropertiesPickListAdapter(String prefName) {
        this.prefName = prefName;
        this.prefSelectedName = String.valueOf(prefName) + "_selected";
        searchablePLI = PickListDBAdapterFactory.getInstance().createPickListItem();
        this.pickList = PickListDBAdapterFactory.getInstance().createPickList();
        if (this.savePickList) {
            this.readData();
        }
    }

    @Override
    public void setAutoSaveOnAdd(boolean doAutoSave) {
        this.doAutoSaveOnAdd = doAutoSave;
    }

    public void setComboBox(ValComboBox comboBox) {
        this.comboBox = comboBox;
    }

    public void setSavePickList(boolean savePickList) {
        this.savePickList = savePickList;
    }

    protected void readData() {
        String valuesStr = AppPreferences.getLocalPrefs().get(this.prefName, "");
        if (StringUtils.isNotEmpty((String)valuesStr)) {
            String[] strs = StringUtils.split((String)valuesStr, (String)",");
            if (strs.length > 0) {
                int i = 0;
                while (i < strs.length) {
                    PickListItemIFace pli = this.pickList.addItem(strs[i], strs[i]);
                    this.items.add(pli);
                    ++i;
                }
            }
            Collections.sort(this.items);
        }
    }

    protected PickList getPickList(String nameArg) {
        throw new RuntimeException("Don't call this!");
    }

    @Override
    public PickListIFace getPickList() {
        return this.pickList;
    }

    @Override
    public Vector<PickListItemIFace> getList() {
        return this.items;
    }

    @Override
    public PickListItemIFace getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public PickListItemIFace addItem(String title, String value) {
        if (this.pickList.getReadOnly().booleanValue()) {
            throw new RuntimeException("Trying to add an item to a readonly picklist [" + this.pickList.getName() + "]");
        }
        int sizeLimit = 50;
        Integer sizeLimitInt = this.pickList.getSizeLimit();
        if (sizeLimitInt != null) {
            sizeLimit = sizeLimitInt;
        }
        searchablePLI.setTitle(title);
        int index = Collections.binarySearch(this.items, searchablePLI);
        if (index < 0) {
            if (this.items.size() >= sizeLimit) {
                PickListItemIFace oldest = null;
                for (PickListItemIFace pli : this.items) {
                    if (oldest != null && pli.getTimestampCreated().getTime() >= oldest.getTimestampCreated().getTime()) continue;
                    oldest = pli;
                }
                this.items.remove(oldest);
                this.pickList.removeItem(oldest);
            }
            PickListItemIFace item = PickListDBAdapterFactory.getInstance().createPickListItem();
            item.setTitle(title);
            item.setValue(value);
            this.items.add(item);
            if (this.pickList != null) {
                this.pickList.addItem(item);
                item.setPickList(this.pickList);
                this.pickList.reorder();
            }
            Collections.sort(this.items);
            if (this.doAutoSaveOnAdd) {
                this.save();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ChangeListener cl : PropertiesPickListAdapter.this.changeListeners) {
                        cl.stateChanged(new ChangeEvent(PropertiesPickListAdapter.this));
                    }
                }
            });
            return item;
        }
        return this.items.elementAt(index);
    }

    public void setSelectedIndex() {
        String selectStr = AppPreferences.getLocalPrefs().get(this.prefSelectedName, "");
        int selectedIndex = -1;
        int i = 0;
        for (PickListItemIFace item : this.items) {
            if (StringUtils.isNotEmpty((String)selectStr) && item.getValue().equals(selectStr)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.comboBox.getComboBox().setSelectedIndex(selectedIndex);
    }

    protected String convertModelToStr(PickListIFace pickListArg) {
        StringBuilder strBuf = new StringBuilder();
        for (PickListItemIFace item : pickListArg.getItems()) {
            if (strBuf.length() > 0) {
                strBuf.append(",");
            }
            strBuf.append(item.getValue());
        }
        return strBuf.toString();
    }

    @Override
    public void save() {
        Object selectedItem;
        log.debug((Object)"Saving PickList");
        if (this.savePickList) {
            AppPreferences.getLocalPrefs().put(this.prefName, this.convertModelToStr(this.pickList));
            log.debug((Object)("[" + this.prefName + "][" + this.convertModelToStr(this.pickList) + "]"));
        }
        if ((selectedItem = this.comboBox.getModel().getSelectedItem()) == null && this.comboBox.getTextField() != null) {
            selectedItem = this.comboBox.getTextField().getText();
        }
        if (selectedItem != null) {
            AppPreferences.getLocalPrefs().put(this.prefSelectedName, selectedItem.toString());
            log.debug((Object)("[" + this.prefSelectedName + "][" + selectedItem.toString() + "]"));
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isTabledBased() {
        return false;
    }

    @Override
    public PickListDBAdapterIFace.Type getType() {
        return PickListDBAdapterIFace.Type.Item;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (l != null) {
            this.changeListeners.add(l);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        if (l != null) {
            this.changeListeners.remove(l);
        }
    }
}

