/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.apache.commons.lang.StringUtils;

public class JEditComboBox
extends JComboBox {
    protected int caretPos = 0;
    protected boolean enableAdditions = true;
    protected boolean caseInsensitve = true;
    protected JTextField textField = null;
    protected boolean foundMatch = false;
    protected boolean ignoreFocus = false;
    protected boolean askBeforeSave = false;
    protected PickListDBAdapterIFace dbAdapter = null;
    public static final KeyStroke clearKeyStroke = KeyStroke.getKeyStroke(27, 0);

    public JEditComboBox() {
    }

    public JEditComboBox(ComboBoxModel arg0) {
        super(arg0);
    }

    public JEditComboBox(Object[] arg0) {
        super(arg0);
    }

    public JEditComboBox(Vector<?> arg0) {
        super(arg0);
    }

    public JEditComboBox(PickListDBAdapterIFace dbAdapter) {
        super(dbAdapter.getList());
        this.dbAdapter = dbAdapter;
        this.init(true);
    }

    public void init(PickListDBAdapterIFace dbAdapterArg, boolean makeEditable) {
        this.setModel(new DefaultComboBoxModel<PickListItemIFace>(dbAdapterArg.getList()));
        this.dbAdapter = dbAdapterArg;
        this.init(makeEditable);
    }

    public void init(boolean makeEditable) {
        if (makeEditable && !this.isEditable) {
            this.setEditor(new BasicComboBoxEditor());
            this.setEditable(true);
            this.setSelectedIndex(-1);
        }
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setEnableAdditions(boolean enableAdditions) {
        this.enableAdditions = enableAdditions;
    }

    public void setAskBeforeSave(boolean askBeforeSave) {
        this.askBeforeSave = askBeforeSave;
    }

    public void setCaseInsensitive(boolean caseInsensitve) {
        this.caseInsensitve = caseInsensitve;
    }

    public PickListDBAdapterIFace getDBAdapter() {
        return this.dbAdapter;
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        if (this.textField != null) {
            this.textField.setBackground(bgColor);
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        Object item;
        super.setSelectedIndex(index);
        if (this.textField != null && this.dbAdapter != null && index > -1 && (item = this.getItemAt(index)) instanceof PickListItem) {
            this.textField.setText(((PickListItem)item).getTitle());
        }
    }

    protected boolean askToAdd(String strArg) {
        if (this.ignoreFocus) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)strArg)) {
            this.ignoreFocus = true;
            String msg = UIRegistry.getLocalizedMessage("JEditComboBox.ADD_NEW_VALUE", strArg);
            String title = UIRegistry.getResourceString("JEditComboBox.ADD_NEW_ITEM_TITLE");
            if (!this.askBeforeSave || JOptionPane.showConfirmDialog(this, msg, title, 0) == 0) {
                PickListItemIFace pli = null;
                if (this.dbAdapter != null) {
                    if (!this.dbAdapter.isReadOnly()) {
                        pli = this.dbAdapter.addItem(strArg, strArg);
                    }
                } else {
                    pli = new PickListItem(strArg, strArg, new Timestamp(System.currentTimeMillis()));
                }
                if (pli != null) {
                    this.addItem(pli);
                    this.setSelectedItem(pli);
                }
                this.ignoreFocus = false;
                return true;
            }
            this.ignoreFocus = false;
        }
        return false;
    }

    public void addNewItemFromTextField() {
        if (this.getSelectedIndex() != -1) {
            if (this.textField != null) {
                this.textField.setSelectionStart(0);
                this.textField.setSelectionEnd(0);
                this.textField.moveCaretPosition(0);
            }
        } else if (this.enableAdditions && this.textField != null) {
            String str = this.textField.getText();
            if (StringUtils.isNotEmpty((String)str) && this.askToAdd(str)) {
                this.textField.setSelectionStart(0);
                this.textField.setSelectionEnd(0);
                this.textField.moveCaretPosition(0);
            } else {
                this.textField.setText("");
            }
        }
    }

    protected KeyAdapter createKeyAdapter() {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ev) {
                char key = ev.getKeyChar();
                if (ev.getKeyCode() == clearKeyStroke.getKeyCode()) {
                    int selectedIndex = JEditComboBox.this.getSelectedIndex();
                    if (selectedIndex > -1 && JEditComboBox.this.dbAdapter != null && JEditComboBox.this.textField != null && JEditComboBox.this.textField.getText().length() == 0 && !JEditComboBox.this.dbAdapter.isReadOnly()) {
                        PickListItem item = (PickListItem)JEditComboBox.this.getSelectedItem();
                        JEditComboBox.this.dbAdapter.getList().remove(item);
                    }
                } else if (!Character.isLetterOrDigit(key) && !Character.isSpaceChar(key)) {
                    if (ev.getKeyCode() == 10) {
                        JEditComboBox.this.addNewItemFromTextField();
                    }
                } else if (JEditComboBox.this.textField != null) {
                    if (JEditComboBox.this.getSelectedIndex() > -1) {
                        int pos = JEditComboBox.this.textField.getCaretPosition();
                        String currentText = JEditComboBox.this.textField.getText();
                        JEditComboBox.this.setSelectedIndex(-1);
                        JEditComboBox.this.textField.setText(currentText);
                        JEditComboBox.this.textField.moveCaretPosition(pos);
                        JEditComboBox.this.textField.setSelectionStart(pos);
                        JEditComboBox.this.textField.setSelectionEnd(pos);
                    }
                } else {
                    JEditComboBox.this.setSelectedIndex(-1);
                }
            }
        };
    }

    protected FocusListener createFocusListener() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JEditComboBox.this.addNewItemFromTextField();
            }
        };
    }

    @Override
    public void setEditor(ComboBoxEditor anEditor) {
        super.setEditor(anEditor);
        if (anEditor != null && anEditor.getEditorComponent() instanceof JTextField) {
            KeyAdapter ka;
            this.textField = (JTextField)anEditor.getEditorComponent();
            FocusListener fl = this.createFocusListener();
            if (fl != null) {
                this.textField.addFocusListener(fl);
            }
            if ((ka = this.createKeyAdapter()) != null) {
                this.textField.addKeyListener(ka);
            }
        }
    }

    public boolean hasAdapter() {
        return this.dbAdapter != null;
    }

    public static JEditComboBox create(String name, boolean readOnly, int sizeLimit, boolean createWhenNotFound) {
        PickListDBAdapterIFace adaptor = PickListDBAdapterFactory.getInstance().create(name, createWhenNotFound);
        adaptor.getPickList().setReadOnly(readOnly);
        adaptor.getPickList().setSizeLimit(sizeLimit);
        return new JEditComboBox(adaptor);
    }

    @Override
    public Dimension getPreferredSize() {
        if (UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX) {
            Dimension d = super.getPreferredSize();
            if (this.getEditor() != null) {
                d.height += 6;
            }
            return d;
        }
        return super.getPreferredSize();
    }
}

