/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.JAutoCompComboBox;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Formatter;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class JComboBoxFromQuery
extends JComboBox {
    protected static final Logger log = Logger.getLogger(JComboBoxFromQuery.class);
    protected int caretPos = 0;
    protected boolean caseInsensitve = true;
    protected JTextField tf = null;
    protected boolean foundMatch = false;
    protected boolean ignoreFocus = false;
    protected boolean allowNewValues = false;
    protected boolean doingSelection = false;
    protected DefaultComboBoxModel model;
    protected Vector<Integer> idList = new Vector();
    protected Vector<String> list = new Vector();
    protected String entryStr = "";
    protected int searchStopLength = Integer.MAX_VALUE;
    protected int oldLength = 0;
    protected String sql;
    protected String tableName;
    protected String displayColumns;
    protected String idColumn;
    protected String format;
    protected String keyColumn;
    protected int numColumns = -1;
    protected Object[] values;
    protected int prevCaretPos = -1;
    protected boolean skipSearch = false;
    protected PopupMenuListener popupMenuListener = null;

    public JComboBoxFromQuery(String sql, String format) {
        this(null, null, null, null, format);
        this.sql = sql;
    }

    public JComboBoxFromQuery(String tableName, String idColumn, String keyColumn, String format) {
        this(tableName, idColumn, keyColumn, null, format);
    }

    public JComboBoxFromQuery(String tableName, String idColumn, String keyColumn, String displayColumns, String format) {
        this.tableName = tableName;
        this.keyColumn = keyColumn;
        this.idColumn = idColumn;
        this.displayColumns = displayColumns != null ? displayColumns : keyColumn;
        this.format = format;
        this.init();
    }

    @Override
    public void requestFocus() {
        log.debug((Object)"requestFocus");
        if (this.tf != null) {
            this.tf.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public JTextField getTextField() {
        return this.tf;
    }

    protected void init() {
        this.model = new DefaultComboBoxModel<String>(this.list);
        this.setModel(this.model);
        this.setEditor(new BasicComboBoxEditor());
        this.setEditable(true);
        this.setSelectedItem("");
    }

    public void setPopupMenuListener(PopupMenuListener popupMenuListener) {
        if (popupMenuListener != null) {
            this.addPopupMenuListener(popupMenuListener);
        } else if (this.popupMenuListener != null) {
            this.removePopupMenuListener(this.popupMenuListener);
        }
        this.popupMenuListener = popupMenuListener;
    }

    public void clearSearch() {
        this.entryStr = null;
    }

    public void setCaseInsensitive(boolean caseInsensitve) {
        this.caseInsensitve = caseInsensitve;
    }

    public boolean isAllowNewValues() {
        return this.allowNewValues;
    }

    public void setAllowNewValues(boolean allowNewValues) {
        this.allowNewValues = allowNewValues;
    }

    protected void setSelectedIndexSuper(int index) {
        super.setSelectedIndex(index);
    }

    @Override
    public void setSelectedIndex(final int index) {
        log.debug((Object)("setSelectedIndex " + index));
        if (!this.doingSelection) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JComboBoxFromQuery.this.doingSelection = true;
                    if (index > -1) {
                        JComboBoxFromQuery.this.setSelectedIndexSuper(index);
                        JComboBoxFromQuery.this.tf.setText((String)JComboBoxFromQuery.this.getItemAt(index));
                        JComboBoxFromQuery.this.tf.setSelectionEnd(JComboBoxFromQuery.this.caretPos + JComboBoxFromQuery.this.tf.getText().length());
                        JComboBoxFromQuery.this.tf.moveCaretPosition(Math.min(JComboBoxFromQuery.this.caretPos, 0));
                    } else {
                        JComboBoxFromQuery.this.setSelectedIndexSuper(-1);
                    }
                    JComboBoxFromQuery.this.doingSelection = false;
                }
            });
        }
    }

    public List<String> getList() {
        return this.list;
    }

    public Integer getSelectedId() {
        if (this.idList.size() > 0 && this.getSelectedIndex() > -1) {
            return this.idList.get(this.getSelectedIndex());
        }
        return null;
    }

    public List<Integer> getIDList() {
        return this.idList;
    }

    protected void lookForMatch() {
        log.debug((Object)"look ");
        String s = this.tf.getText();
        int len = s.length();
        if (len == 0) {
            this.setSelectedIndex(-1);
            this.foundMatch = false;
            return;
        }
        this.caretPos = this.tf.getCaretPosition();
        String text = "";
        try {
            text = this.tf.getText(0, this.caretPos);
        }
        catch (BadLocationException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(JComboBoxFromQuery.class, ex);
            ex.printStackTrace();
        }
        String textLowerCase = text.toLowerCase();
        this.foundMatch = true;
        int n = this.getItemCount();
        int i = 0;
        while (i < n) {
            int index;
            if (this.caseInsensitve) {
                String item = ((String)this.getItemAt(i)).toLowerCase();
                index = item.indexOf(textLowerCase);
            } else {
                index = ((String)this.getItemAt(i)).indexOf(text);
            }
            if (index == 0) {
                this.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        if (!this.allowNewValues && len > 0) {
            this.tf.setText(s.substring(0, len - 1));
            this.lookForMatch();
            return;
        }
        this.foundMatch = false;
    }

    protected String buildSQL(String newEntryStr) {
        if (this.sql == null) {
            return "select distinct " + this.displayColumns + "," + this.idColumn + " from " + this.tableName + " where lower(" + this.keyColumn + ") like '" + this.entryStr.toLowerCase() + "%' order by " + this.keyColumn + " asc";
        }
        return this.sql.replace("%s", this.entryStr.toLowerCase());
    }

    protected void fillBox(String newEntryStr) {
        log.debug((Object)"fillbox");
        try {
            this.searchStopLength = Integer.MAX_VALUE;
            if (newEntryStr.equals(this.entryStr)) {
                return;
            }
            this.list.clear();
            this.idList.clear();
            if (newEntryStr.length() == 0) {
                this.searchStopLength = Integer.MAX_VALUE;
                return;
            }
            this.entryStr = newEntryStr;
            String queryString = this.buildSQL(newEntryStr);
            log.debug((Object)queryString);
            Connection connection = DBConnection.getInstance().createConnection();
            Statement dbStatement = null;
            ResultSet rs = null;
            try {
                try {
                    if (connection != null && (dbStatement = connection.createStatement()) != null) {
                        rs = dbStatement.executeQuery(queryString);
                    }
                    if (rs != null && rs.next()) {
                        if (this.numColumns == -1) {
                            this.numColumns = rs.getMetaData().getColumnCount() - 1;
                            this.values = new Object[this.numColumns];
                        }
                        do {
                            if (this.numColumns == 1) {
                                this.idList.addElement(rs.getInt(2));
                                this.list.addElement(rs.getString(1));
                                continue;
                            }
                            try {
                                this.idList.addElement(rs.getInt(this.numColumns + 1));
                                int i = 0;
                                while (i < this.numColumns) {
                                    Object val = rs.getObject(i + 1);
                                    this.values[i] = val != null ? val : "";
                                    ++i;
                                }
                                Formatter formatter = new Formatter();
                                formatter.format(this.format, this.values);
                                this.list.addElement(formatter.toString());
                            }
                            catch (IllegalFormatConversionException ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(JComboBoxFromQuery.class, ex);
                                this.list.addElement(this.values[0] != null ? this.values[0].toString() : UIRegistry.getResourceString("JComboBoxFromQuery.NO_VALUE"));
                            }
                        } while (rs.next());
                    } else {
                        this.searchStopLength = Integer.MAX_VALUE;
                    }
                    if (this.list.size() > 0 && this.list.size() < 11) {
                        this.searchStopLength = this.entryStr.length();
                    }
                }
                catch (SQLException ex) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(JComboBoxFromQuery.class, ex);
                    ex.printStackTrace();
                    if (rs != null) {
                        rs.close();
                    }
                    if (dbStatement != null) {
                        dbStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (dbStatement != null) {
                    dbStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(JComboBoxFromQuery.class, ex);
            ex.printStackTrace();
        }
    }

    protected void cbxKeyReleased(KeyEvent ev) {
        log.debug((Object)"cbxKeyReleased");
        if (ev.getKeyCode() == JAutoCompComboBox.SEARCH_KEY) {
            this.skipSearch = true;
            String str = this.tf.getText();
            this.fillBox(str);
            this.lookForMatch();
        }
    }

    protected void tfFocusGained(FocusEvent e) {
        this.searchStopLength = Integer.MAX_VALUE;
        log.debug((Object)"tfFocusGained");
    }

    protected void tfFocusLost(FocusEvent e) {
        log.debug((Object)"tfFocusLost");
        this.tf.setSelectionStart(0);
        this.tf.setSelectionEnd(0);
        this.tf.moveCaretPosition(0);
        if (this.tf.getText().length() == 0) {
            this.setSelectedIndex(-1);
        }
        if (this.getSelectedIndex() == -1) {
            this.tf.setText("");
        }
    }

    protected FocusAdapter getTextFocusAdapter() {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JComboBoxFromQuery.this.tfFocusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                JComboBoxFromQuery.this.tfFocusLost(e);
            }
        };
    }

    @Override
    public void setEditor(ComboBoxEditor anEditor) {
        super.setEditor(anEditor);
        if (anEditor.getEditorComponent() instanceof JTextField) {
            this.tf = (JTextField)anEditor.getEditorComponent();
            this.tf.addFocusListener(this.getTextFocusAdapter());
            this.tf.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ev) {
                    JComboBoxFromQuery.this.prevCaretPos = JComboBoxFromQuery.this.tf.getCaretPosition();
                }

                @Override
                public void keyReleased(KeyEvent ev) {
                    JComboBoxFromQuery.this.cbxKeyReleased(ev);
                }
            });
        }
    }

    public void cleanUp() {
        this.tf = null;
        this.values = null;
        this.model.removeAllElements();
        this.idList.clear();
        this.list.clear();
    }

    @Override
    public Dimension getPreferredSize() {
        if (UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX) {
            Dimension d = super.getPreferredSize();
            if (this.getEditor() != null) {
                d.height += 6;
            }
            return d;
        }
        return super.getPreferredSize();
    }
}

