/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.ui.db.JAutoCompComboBox;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class JAutoCompTextField
extends JTextField {
    protected int caretPos = 0;
    protected boolean enableAdditions = true;
    protected boolean caseInsensitve = true;
    protected boolean askBeforeSave = true;
    protected boolean hasChanged = false;
    protected boolean foundMatch = false;
    protected boolean ignoreFocus = false;
    protected PickListDBAdapterIFace dbAdapter = null;
    protected int prevCaretPos = -1;
    protected JPopupMenu popupMenu = null;

    public JAutoCompTextField() {
        UIHelper.setControlSize(this);
    }

    public JAutoCompTextField(String numCols) {
        super(numCols);
        UIHelper.setControlSize(this);
    }

    public JAutoCompTextField(int numCols) {
        super(numCols);
        UIHelper.setControlSize(this);
    }

    public JAutoCompTextField(int numCols, PickListDBAdapterIFace pickListDBAdapter) {
        super(numCols);
        this.dbAdapter = pickListDBAdapter;
        this.initAdapter();
        UIHelper.setControlSize(this);
    }

    public JAutoCompTextField(String text, int numCols) {
        super(text, numCols);
        UIHelper.setControlSize(this);
    }

    public JAutoCompTextField(PickListDBAdapterIFace dbAdapter) {
        this.dbAdapter = dbAdapter;
        this.initAdapter();
        UIHelper.setControlSize(this);
    }

    public void setPickListAdapter(PickListDBAdapterIFace dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    protected void lookup(String str) {
        this.foundMatch = true;
        int inx = 0;
        for (PickListItemIFace pli : this.dbAdapter.getList()) {
            String title = pli.getTitle();
            int ind = this.caseInsensitve ? title.toLowerCase().indexOf(str.toLowerCase()) : title.indexOf(str);
            if (ind == 0) {
                this.setSelectedIndex(inx);
                return;
            }
            ++inx;
        }
        this.foundMatch = false;
        this.hasChanged = true;
    }

    protected void keyReleasedInternal(KeyEvent ev) {
        if (this.dbAdapter != null) {
            if (ev.getKeyCode() == JAutoCompComboBox.SEARCH_KEY) {
                String title;
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        JMenuItem mi = (JMenuItem)ae.getSource();
                        int inx = 0;
                        for (PickListItemIFace pli : JAutoCompTextField.this.dbAdapter.getList()) {
                            String title = pli.getTitle();
                            if (mi.getText().equals(title)) {
                                JAutoCompTextField.this.setSelectedIndex(inx);
                                break;
                            }
                            ++inx;
                        }
                        JAutoCompTextField.this.popupMenu = null;
                    }
                };
                String txt = this.getText();
                int cnt = 0;
                for (PickListItemIFace pli : this.dbAdapter.getList()) {
                    title = pli.getTitle();
                    if (title.length() < txt.length() || !title.startsWith(txt)) continue;
                    ++cnt;
                }
                if (cnt > 0) {
                    this.popupMenu = new JPopupMenu();
                    for (PickListItemIFace pli : this.dbAdapter.getList()) {
                        title = pli.getTitle();
                        if (title.length() < txt.length() || !title.startsWith(txt)) continue;
                        JMenuItem mi = new JMenuItem(title);
                        UIHelper.setControlSize(mi);
                        this.popupMenu.add(mi);
                        mi.addActionListener(al);
                    }
                    Point location = this.getLocation();
                    Dimension size = this.getSize();
                    this.popupMenu.show(this, location.x, location.y + size.height);
                }
            } else if (ev.getKeyCode() == 10) {
                this.addNewItemFromTextField();
            } else if (ev.getKeyCode() == 35) {
                this.setSelectionStart(this.prevCaretPos);
                this.setSelectionEnd(this.getText().length());
            }
        }
    }

    protected void initAdapter() {
        if (this.dbAdapter != null) {
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JAutoCompTextField.this.addNewItemFromTextField();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ev) {
                    JAutoCompTextField.this.prevCaretPos = JAutoCompTextField.this.getCaretPosition();
                    if (UIHelper.isMacOS()) {
                        JAutoCompTextField.this.keyReleasedInternal(ev);
                    }
                }

                @Override
                public void keyTyped(KeyEvent arg0) {
                    super.keyTyped(arg0);
                }

                @Override
                public void keyReleased(KeyEvent ev) {
                    JAutoCompTextField.this.keyReleasedInternal(ev);
                }
            });
        }
    }

    public void setSelectedIndex(int index) {
        if (index > -1 && this.dbAdapter != null) {
            this.setText(this.dbAdapter.getItem(index).getTitle());
            this.setSelectionEnd(this.caretPos + this.getText().length());
            this.moveCaretPosition(this.caretPos);
        }
    }

    public void setEnableAdditions(boolean enableAdditions) {
        this.enableAdditions = enableAdditions;
    }

    public void setAskBeforeSave(boolean askBeforeSave) {
        this.askBeforeSave = askBeforeSave;
    }

    public void setCaseInsensitive(boolean caseInsensitve) {
        this.caseInsensitve = caseInsensitve;
    }

    protected boolean askToAdd(String strArg) {
        if (this.ignoreFocus) {
            return false;
        }
        if (this.hasChanged && StringUtils.isNotEmpty((String)strArg)) {
            this.ignoreFocus = true;
            String msg = UIRegistry.getLocalizedMessage("JAutoCompTextField.REMEM_VAL", strArg);
            if (!this.askBeforeSave || JOptionPane.showConfirmDialog(this, msg, UIRegistry.getResourceString("JAutoCompTextField.REMEM_VAL_TITLE"), 0) == 0) {
                if (this.dbAdapter != null) {
                    this.dbAdapter.addItem(strArg, null);
                }
                this.hasChanged = false;
                this.ignoreFocus = false;
                return true;
            }
            this.ignoreFocus = false;
        }
        return false;
    }

    protected void addNewItemFromTextField() {
        int inx = this.dbAdapter.getList().indexOf(this.getText());
        if (inx != -1) {
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
            this.moveCaretPosition(0);
        } else if (this.enableAdditions && this.askToAdd(this.getText())) {
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
            this.moveCaretPosition(0);
        }
    }

    public static JAutoCompTextField create(String name, boolean readOnly, int sizeLimit, boolean createWhenNotFound) {
        PickListDBAdapterIFace adaptor = PickListDBAdapterFactory.getInstance().create(name, createWhenNotFound);
        adaptor.getPickList().setReadOnly(readOnly);
        adaptor.getPickList().setSizeLimit(sizeLimit);
        return new JAutoCompTextField(adaptor);
    }
}

