/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.JEditComboBox;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.PickListItem;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class JAutoCompComboBox
extends JEditComboBox {
    public static int SEARCH_KEY = 114;

    public JAutoCompComboBox() {
        this.init();
    }

    public JAutoCompComboBox(ComboBoxModel arg0) {
        super(arg0);
        this.init();
    }

    public JAutoCompComboBox(Object[] arg0) {
        super(arg0);
        this.init();
    }

    public JAutoCompComboBox(Vector<?> arg0) {
        super(arg0);
        this.init();
    }

    public JAutoCompComboBox(PickListDBAdapterIFace dbAdapter) {
        super((Vector<?>)dbAdapter.getList());
        this.dbAdapter = dbAdapter;
        this.init();
    }

    protected void init() {
    }

    @Override
    public void setSelectedIndex(int index) {
        Object item;
        super.setSelectedIndex(index);
        if (this.textField != null && this.dbAdapter != null && index > -1 && (item = this.getItemAt(index)) instanceof PickListItem) {
            this.textField.setText(((PickListItem)item).getTitle());
            this.textField.setSelectionEnd(this.caretPos + this.textField.getText().length());
            this.textField.moveCaretPosition(this.caretPos);
        }
    }

    protected void lookForMatch() {
        String s = this.textField.getText();
        int len = s.length();
        if (len == 0) {
            this.setSelectedIndex(-1);
            this.foundMatch = false;
            return;
        }
        this.caretPos = this.textField.getCaretPosition();
        String text = "";
        try {
            text = this.textField.getText(0, this.caretPos);
        }
        catch (BadLocationException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(JAutoCompComboBox.class, ex);
            ex.printStackTrace();
        }
        String textLowerCase = text.toLowerCase();
        this.foundMatch = true;
        int n = this.getItemCount();
        int i = 0;
        while (i < n) {
            int ind;
            if (this.caseInsensitve) {
                String item = ((PickListItem)this.getItemAt(i)).getTitle().toLowerCase();
                ind = item.indexOf(textLowerCase);
            } else {
                ind = ((PickListItem)this.getItemAt(i)).getTitle().indexOf(text);
            }
            if (ind == 0) {
                this.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        if (!this.enableAdditions && len > 0) {
            this.textField.setText(s.substring(0, len - 1));
            this.lookForMatch();
            return;
        }
        this.foundMatch = false;
    }

    protected boolean hasDBAdapter() {
        return this.dbAdapter != null;
    }

    @Override
    protected KeyAdapter createKeyAdapter() {
        final JAutoCompComboBox cbx = this;
        return new KeyAdapter(){
            protected int prevCaretPos = -1;

            @Override
            public void keyPressed(KeyEvent ev) {
                this.prevCaretPos = JAutoCompComboBox.this.textField.getCaretPosition();
            }

            @Override
            public void keyReleased(KeyEvent ev) {
                if (!cbx.isPopupVisible() && JAutoCompComboBox.this.hasDBAdapter() && JAutoCompComboBox.this.dbAdapter.getType() != PickListDBAdapterIFace.Type.Table) {
                    if (ev.getKeyCode() == SEARCH_KEY) {
                        JAutoCompComboBox.this.lookForMatch();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                cbx.showPopup();
                            }
                        });
                    }
                } else {
                    char key = ev.getKeyChar();
                    if (ev.getKeyCode() == 8) {
                        String textStr = JAutoCompComboBox.this.textField.getText();
                        int len = textStr.length();
                        if (len == 0) {
                            JAutoCompComboBox.this.foundMatch = false;
                            JAutoCompComboBox.this.setSelectedIndex(-1);
                            return;
                        }
                        if (JAutoCompComboBox.this.foundMatch) {
                            JAutoCompComboBox.this.textField.setText(textStr.substring(0, len - 1));
                        } else if (!JAutoCompComboBox.this.enableAdditions && len > 0) {
                            JAutoCompComboBox.this.textField.setText(textStr.substring(0, len - 1));
                            JAutoCompComboBox.this.lookForMatch();
                            return;
                        }
                    } else if (!Character.isLetterOrDigit(key) && !Character.isSpaceChar(key) && ev.getKeyCode() != 127) {
                        if (ev.getKeyCode() == 10) {
                            JAutoCompComboBox.this.addNewItemFromTextField();
                        } else if (ev.getKeyCode() == 35) {
                            JAutoCompComboBox.this.textField.setSelectionStart(this.prevCaretPos);
                            JAutoCompComboBox.this.textField.setSelectionEnd(JAutoCompComboBox.this.textField.getText().length());
                        }
                        return;
                    }
                    JAutoCompComboBox.this.lookForMatch();
                }
            }
        };
    }

    public static JAutoCompComboBox create(String name, boolean readOnly, int sizeLimit, boolean createWhenNotFound) {
        PickListDBAdapterIFace adaptor = PickListDBAdapterFactory.getInstance().create(name, createWhenNotFound);
        adaptor.getPickList().setReadOnly(readOnly);
        adaptor.getPickList().setSizeLimit(sizeLimit);
        return new JAutoCompComboBox(adaptor);
    }

    public static /* bridge */ /* synthetic */ JEditComboBox create(String string, boolean bl, int n, boolean bl2) {
        return JAutoCompComboBox.create(string, bl, n, bl2);
    }
}

