/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregator;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ERTICaptionInfo {
    private static final Logger log = Logger.getLogger(ERTICaptionInfo.class);
    protected String colName;
    protected String colLabel = null;
    protected boolean isVisible;
    protected int posIndex;
    protected String description = null;
    protected String aggregatorName;
    protected String orderCol;
    protected Vector<ColInfo> colInfoList = null;
    protected Class<?> aggClass = null;
    protected Class<?> subClass = null;
    protected String subClassFieldName = null;
    protected Class<?> colClass = null;
    protected int orderColIndex = -1;
    protected DBFieldInfo fieldInfo = null;
    protected DataObjSwitchFormatter dataObjFormatter = null;
    protected UIFieldFormatterIFace uiFieldFormatter = null;

    public ERTICaptionInfo(String colName, String colLabel, boolean isVisible, UIFieldFormatterIFace uiFieldFormatter, int posIndex) {
        this.colName = colName;
        this.colLabel = colLabel;
        this.isVisible = isVisible;
        this.uiFieldFormatter = uiFieldFormatter;
        this.posIndex = posIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ERTICaptionInfo(Element element, ResourceBundle resBundle) {
        String subClassName;
        String aggClassName;
        String key;
        int tblId = XMLHelper.getAttr(element, "tableid", -1);
        if (tblId == -1) {
            throw new RuntimeException("search_config.xml caption has bad id[" + XMLHelper.getAttr(element, "tableid", "N/A") + "]");
        }
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(tblId);
        String dataObjFormatterName = XMLHelper.getAttr(element, "dataobjformatter", null);
        String formatter = XMLHelper.getAttr(element, "formatter", dataObjFormatterName);
        this.colName = element.attributeValue("col");
        String lookupColName = null;
        if (this.colName != null) {
            lookupColName = this.colName.indexOf(46) > -1 ? StringUtils.substringAfterLast((String)this.colName, (String)".") : this.colName;
            this.fieldInfo = tableInfo.getFieldByColumnName(lookupColName);
        }
        if (StringUtils.isNotEmpty((String)(key = XMLHelper.getAttr(element, "key", null)))) {
            try {
                this.colLabel = resBundle.getString(key);
                this.description = resBundle.getString(String.valueOf(key) + "_desc");
            }
            catch (MissingResourceException ex) {
                log.error((Object)("Missing resource [" + key + "] or [" + key + "_desc]"));
                this.colLabel = key;
                this.description = String.valueOf(key) + "_desc";
            }
        } else {
            if (tableInfo == null) throw new RuntimeException("Table Id is bad id[" + XMLHelper.getAttr(element, "tableid", "N/A") + "]");
            if (this.fieldInfo == null) {
                if (this.colName != null && this.colName.endsWith("ID")) {
                    this.colLabel = this.colName;
                    this.description = "";
                } else {
                    if (this.colName != null) throw new RuntimeException("Couldn't convert column Name[" + this.colName + "] to a field name to find the field in table[" + tblId + "]");
                    this.colInfoList = new Vector();
                    int pos = 0;
                    for (Object colObj : element.selectNodes("col")) {
                        Element colInfoObj = (Element)colObj;
                        ColInfo columnInfo = new ColInfo(XMLHelper.getAttr(colInfoObj, "name", null), XMLHelper.getAttr(colInfoObj, "field", null));
                        columnInfo.setPosition(pos++);
                        if (this.colInfoList.size() == 0) {
                            this.fieldInfo = tableInfo.getFieldByColumnName(columnInfo.getColumnName());
                        }
                        this.colInfoList.add(columnInfo);
                    }
                    if (tableInfo != null) {
                        for (ColInfo columnInfo : this.colInfoList) {
                            DBFieldInfo fi = tableInfo.getFieldByName(columnInfo.getFieldName());
                            if (fi != null) {
                                columnInfo.setFieldClass(fi.getDataClass());
                                continue;
                            }
                            log.error((Object)("Field Name in TableId doesn't exist Class is not a Data Table[" + tableInfo.getTitle() + "] Field[" + columnInfo.getFieldName() + "]"));
                        }
                    } else {
                        log.error((Object)("Aggregate Sub Class is not a Data Table[" + (tableInfo != null ? tableInfo.getTitle() : "N/A") + "]"));
                    }
                }
            } else if (this.fieldInfo.getFormatter() != null) {
                formatter = this.fieldInfo.getFormatter().getName();
            }
        }
        this.isVisible = XMLHelper.getAttr(element, "visible", true);
        String aggTableClassName = null;
        Element subElement = (Element)element.selectSingleNode("subobject");
        Element aggElement = (Element)element.selectSingleNode("agg");
        if (aggElement != null && StringUtils.isNotEmpty((String)(aggClassName = XMLHelper.getAttr(aggElement, "class", null)))) {
            aggTableClassName = aggClassName;
            try {
                DataObjAggregator agg;
                this.aggClass = Class.forName(aggClassName);
                boolean aggOK = false;
                DBTableInfo tInfo = DBTableIdMgr.getInstance().getByShortClassName(this.aggClass.getSimpleName());
                if (tInfo != null && StringUtils.isNotEmpty((String)tInfo.getAggregatorName()) && (agg = DataObjFieldFormatMgr.getInstance().getAggregator(tInfo.getAggregatorName())) != null) {
                    this.aggregatorName = tInfo.getAggregatorName();
                    aggOK = true;
                }
                if (!aggOK) {
                    this.aggregatorName = XMLHelper.getAttr(aggElement, "aggregator", null);
                }
                this.orderCol = XMLHelper.getAttr(aggElement, "ordercol", null);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ERTICaptionInfo.class, ex);
            }
        }
        if (subElement != null && StringUtils.isNotEmpty((String)(subClassName = XMLHelper.getAttr(subElement, "class", null)))) {
            try {
                this.subClass = Class.forName(subClassName);
                this.subClassFieldName = XMLHelper.getAttr(subElement, "fieldname", null);
                aggTableClassName = subClassName;
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ERTICaptionInfo.class, ex);
            }
        }
        String compositeClassName = null;
        if (StringUtils.isNotEmpty(aggTableClassName)) {
            compositeClassName = aggTableClassName;
        } else if (StringUtils.isNotEmpty((String)dataObjFormatterName)) {
            this.dataObjFormatter = DataObjFieldFormatMgr.getInstance().getFormatter(dataObjFormatterName);
            if (this.dataObjFormatter != null) {
                compositeClassName = this.dataObjFormatter.getDataClass().getName();
                try {
                    this.aggClass = Class.forName(compositeClassName);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ERTICaptionInfo.class, ex);
                }
            } else {
                log.error((Object)("Couldn't find formatter[" + dataObjFormatterName + "]"));
            }
            formatter = null;
        }
        if (StringUtils.isNotEmpty((String)compositeClassName)) {
            this.colInfoList = new Vector();
            for (Object colObj : element.selectNodes("col")) {
                Element colInfoObj = (Element)colObj;
                ColInfo columnInfo = new ColInfo(XMLHelper.getAttr(colInfoObj, "name", null), XMLHelper.getAttr(colInfoObj, "field", null));
                this.colInfoList.add(columnInfo);
            }
            DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(compositeClassName);
            if (ti != null) {
                for (ColInfo columnInfo : this.colInfoList) {
                    DBFieldInfo fi = ti.getFieldByName(columnInfo.getFieldName());
                    if (fi != null) {
                        columnInfo.setFieldClass(fi.getDataClass());
                        continue;
                    }
                    log.error((Object)("Field Name is Aggregate Sub Class doesn't exist Class is not a Data Table[" + compositeClassName + "] Field[" + columnInfo.getFieldName() + "]"));
                }
            } else {
                log.error((Object)("Aggregate Sub Class is not a Data Table[" + compositeClassName + "]"));
            }
        }
        if (!StringUtils.isNotEmpty((String)formatter)) return;
        this.uiFieldFormatter = UIFieldFormatterMgr.getInstance().getFormatter(formatter);
        if (this.uiFieldFormatter != null) return;
        log.error((Object)("The UIFieldFormatter could not be found named [" + formatter + "]"));
    }

    public String getColName() {
        return this.colName;
    }

    public String getColLabel() {
        if (this.colLabel == null) {
            return this.fieldInfo.getTitle();
        }
        return this.colLabel;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int getPosIndex() {
        return this.posIndex;
    }

    public void setPosIndex(int posIndex) {
        this.posIndex = posIndex;
    }

    public DBFieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public void setColLabel(String colLabel) {
        this.colLabel = colLabel;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.fieldInfo.getDescription();
        }
        return this.description;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public Class<?> getColClass() {
        return this.colClass;
    }

    public void setColClass(Class<?> colClass) {
        this.colClass = colClass;
    }

    public String getAggregatorName() {
        return this.aggregatorName;
    }

    public Vector<ColInfo> getColInfoList() {
        return this.colInfoList;
    }

    public void setColInfoList(Vector<ColInfo> colInfoList) {
        this.colInfoList = colInfoList;
    }

    public Class<?> getAggClass() {
        return this.aggClass;
    }

    public Class<?> getSubClass() {
        return this.subClass;
    }

    public String getOrderCol() {
        return this.orderCol;
    }

    public void setAggClass(Class<?> aggClass) {
        this.aggClass = aggClass;
    }

    public int getOrderColIndex() {
        return this.orderColIndex;
    }

    public void setOrderColIndex(int orderColIndex) {
        this.orderColIndex = orderColIndex;
    }

    public String getSubClassFieldName() {
        return this.subClassFieldName;
    }

    public DataObjSwitchFormatter getDataObjFormatter() {
        return this.dataObjFormatter;
    }

    public UIFieldFormatterIFace getUiFieldFormatter() {
        return this.uiFieldFormatter;
    }

    public void setUiFieldFormatter(UIFieldFormatterIFace uiFieldFormatter) {
        this.uiFieldFormatter = uiFieldFormatter;
    }

    public Object processValue(Object value) {
        return value;
    }

    public class ColInfo {
        protected String columnName;
        protected String fieldName;
        protected int position;
        protected Class<?> fieldClass;

        public ColInfo(String columnName, String fieldName) {
            this.columnName = columnName;
            this.fieldName = fieldName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public Class<?> getFieldClass() {
            return this.fieldClass;
        }

        public void setFieldClass(Class<?> fieldClass) {
            this.fieldClass = fieldClass;
        }
    }
}

