/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.JaasContext;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.db.PropertiesPickListAdapter;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.SchemaUpdateService;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizard;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizardFrame;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.JTiledPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatabaseLoginPanel
extends JTiledPanel {
    private static final Logger log = Logger.getLogger(DatabaseLoginPanel.class);
    private static final String LOGIN_PORT = "login.port";
    protected JTextField username;
    protected JPasswordField password;
    protected JSpinner portSpinner;
    protected ValComboBox databases;
    protected ValComboBox servers;
    protected JCheckBox rememberUsernameCBX;
    protected JButton editKeyInfoBtn;
    protected ArrayList<JLabel> labels = new ArrayList();
    protected JButton cancelBtn;
    protected JButton loginBtn;
    protected JButton helpBtn;
    protected JCheckBox moreBtn;
    protected ImageIcon forwardImgIcon;
    protected ImageIcon downImgIcon;
    protected JStatusBar statusBar;
    protected JComboBox dbDriverCBX;
    protected JPanel extraPanel;
    protected JDialog thisDlg;
    protected boolean isCancelled = true;
    protected boolean isLoggingIn = false;
    protected boolean isAutoClose = false;
    protected boolean doLoginWithDB = true;
    protected boolean engageUPPrefs = false;
    protected DatabaseLoginListener dbListener;
    protected JaasContext jaasContext;
    protected Window window;
    protected Vector<DatabaseDriverInfo> dbDrivers = new Vector();
    protected long elapsedTime = -1L;
    protected long loginCount = 0L;
    protected long loginAccumTime = 0L;
    protected ProgressWorker progressWorker = null;
    protected String title;
    protected String appName;
    protected String ssUserName = null;
    protected String ssPassword = null;
    protected MasterPasswordProviderIFace masterUsrPwdProvider = null;
    protected boolean doSaveUPPrefs = true;
    protected boolean checkForProcesses = true;
    protected PropertiesPickListAdapter dbPickList = null;
    protected PropertiesPickListAdapter svPickList = null;

    public DatabaseLoginPanel(String userName, String password, boolean engageUPPrefs, DatabaseLoginListener dbListener, boolean isDlg, String iconName, String helpContext) {
        this(userName, password, engageUPPrefs, dbListener, isDlg, null, null, iconName, helpContext);
    }

    public DatabaseLoginPanel(String userName, String password, boolean engageUPPrefs, DatabaseLoginListener dbListener, boolean isDlg, String title, String appName, String iconName, String helpContext) {
        this(userName, password, engageUPPrefs, null, dbListener, isDlg, true, title, appName, iconName, helpContext);
    }

    public DatabaseLoginPanel(String userName, String password, boolean engageUPPrefs, MasterPasswordProviderIFace masterUsrPwdProvider, DatabaseLoginListener dbListener, boolean isDlg, boolean doLoginWithDB, String title, String appName, String iconName, String helpContext) {
        this.ssUserName = userName;
        this.ssPassword = password;
        this.masterUsrPwdProvider = masterUsrPwdProvider;
        this.dbListener = dbListener;
        this.jaasContext = new JaasContext();
        this.title = title;
        this.appName = appName;
        this.doSaveUPPrefs = engageUPPrefs;
        this.doLoginWithDB = doLoginWithDB;
        this.engageUPPrefs = engageUPPrefs;
        this.createUI(isDlg, iconName, helpContext);
        SkinItem skinItem = SkinsMgr.getSkinItem("LoginPanel");
        if (skinItem != null) {
            skinItem.setupPanel(this);
        }
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public Window getWindow() {
        return this.window;
    }

    public JButton getLoginBtn() {
        return this.loginBtn;
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected int addLine(String label, JComponent comp, PanelBuilder pb, CellConstraints cc, int y) {
        int yy = y;
        JLabel lbl = UIHelper.createLabel(label != null ? String.valueOf(UIRegistry.getResourceString(label)) + ":" : " ", 4);
        this.labels.add(lbl);
        pb.add((Component)lbl, cc.xy(1, yy));
        pb.add((Component)comp, cc.xy(3, yy));
        return yy += 2;
    }

    private String getPasswordPrefPath(String usrName, String dbName, boolean includeDBName) {
        return String.valueOf(StringUtils.isNotEmpty((String)dbName) && includeDBName ? String.valueOf(dbName) + '_' + usrName + "_" : "") + "login.password";
    }

    private String getUserPrefPath(String dbName, boolean includeDBName) {
        String key = String.valueOf(StringUtils.isNotEmpty((String)dbName) && includeDBName ? String.valueOf(dbName) + '_' : "") + "login.username";
        return key;
    }

    protected void createUI(boolean isDlg, String iconName, String helpContext) {
        JLabel icon;
        final boolean isNotEmbedded = !DBConnection.getInstance().isEmbedded() && !UIRegistry.isMobile();
        final AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        SkinItem skinItem = SkinsMgr.getSkinItem("LoginPanel");
        if (skinItem != null) {
            skinItem.pushFG("Label.foreground");
        }
        if (isNotEmbedded) {
            SpinnerNumberModel portModel = new SpinnerNumberModel(3306, 0, 9999, 1);
            this.portSpinner = new JSpinner(portModel);
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.portSpinner, "#");
            this.portSpinner.setEditor(editor);
            this.portSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DatabaseDriverInfo drvInfo = DatabaseLoginPanel.this.dbDrivers.get(DatabaseLoginPanel.this.dbDriverCBX.getSelectedIndex());
                    if (drvInfo != null && isNotEmbedded && DatabaseLoginPanel.this.portSpinner != null) {
                        drvInfo.setPort((Integer)DatabaseLoginPanel.this.portSpinner.getValue());
                    }
                }
            });
            UIHelper.setControlSize(this.portSpinner);
        }
        this.dbPickList = new PropertiesPickListAdapter("login.databases");
        this.svPickList = new PropertiesPickListAdapter("login.servers");
        this.username = UIHelper.createTextField(15);
        this.password = UIHelper.createPasswordField(15);
        FocusAdapter focusAdp = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                JTextField tf = (JTextField)e.getSource();
                tf.selectAll();
            }
        };
        this.username.addFocusListener(focusAdp);
        this.password.addFocusListener(focusAdp);
        this.databases = new ValComboBox(this.dbPickList);
        this.servers = new ValComboBox(this.svPickList);
        this.dbPickList.setComboBox(this.databases);
        this.svPickList.setComboBox(this.servers);
        UIHelper.setControlSize(this.password);
        UIHelper.setControlSize(this.databases);
        UIHelper.setControlSize(this.servers);
        if (this.masterUsrPwdProvider != null) {
            this.editKeyInfoBtn = UIHelper.createI18NButton("CONFIG_MSTR_KEY");
            this.editKeyInfoBtn.setIcon(IconManager.getIcon("Key", IconManager.IconSize.Std20));
            this.editKeyInfoBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DatabaseLoginPanel.this.masterUsrPwdProvider != null && DatabaseLoginPanel.this.databases != null) {
                        String itemName = null;
                        if (DatabaseLoginPanel.this.databases.getComboBox().getSelectedItem() instanceof String) {
                            itemName = (String)DatabaseLoginPanel.this.databases.getComboBox().getSelectedItem();
                        } else {
                            PickListItemIFace pli = (PickListItemIFace)DatabaseLoginPanel.this.databases.getComboBox().getSelectedItem();
                            if (pli != null && pli.getValue() != null) {
                                itemName = pli.getValue();
                            }
                        }
                        if (itemName != null) {
                            DatabaseLoginPanel.this.masterUsrPwdProvider.editMasterInfo(DatabaseLoginPanel.this.username.getText(), itemName, false);
                        }
                    }
                }
            });
        }
        this.rememberUsernameCBX = UIHelper.createCheckBox(UIRegistry.getResourceString("rememberuser"));
        this.rememberUsernameCBX.setEnabled(this.engageUPPrefs);
        this.statusBar = new JStatusBar();
        this.statusBar.setErrorIcon(IconManager.getIcon("Error", IconManager.IconSize.Std16));
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.loginBtn = UIHelper.createButton(UIRegistry.getResourceString("Login"));
        this.helpBtn = UIHelper.createButton(UIRegistry.getResourceString("HELP"));
        this.forwardImgIcon = IconManager.getIcon("Forward");
        this.downImgIcon = IconManager.getIcon("Down");
        this.moreBtn = new JCheckBox(UIRegistry.getResourceString("LOGIN_DLG_MORE"), this.forwardImgIcon);
        UIHelper.setControlSize(this.moreBtn);
        this.dbDrivers = DatabaseDriverInfo.getDriversList();
        this.dbDriverCBX = UIHelper.createComboBox(this.dbDrivers);
        this.dbDriverCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseLoginPanel.this.updateUIControls();
                DatabaseDriverInfo drvInfo = DatabaseLoginPanel.this.dbDrivers.get(DatabaseLoginPanel.this.dbDriverCBX.getSelectedIndex());
                if (drvInfo != null && isNotEmbedded && DatabaseLoginPanel.this.portSpinner != null) {
                    Integer defPort = drvInfo.getPortAsInt();
                    int portFromPref = localPrefs.getInt(DatabaseLoginPanel.LOGIN_PORT, defPort);
                    DatabaseLoginPanel.this.portSpinner.setValue(portFromPref);
                    drvInfo.setPort(portFromPref);
                }
            }
        });
        if (this.dbDrivers.size() > 0) {
            if (this.dbDrivers.size() == 1) {
                this.dbDriverCBX.setSelectedIndex(0);
                this.dbDriverCBX.setEnabled(false);
            } else {
                String selectedStr = localPrefs.get("login.dbdriver_selected", "MySQL");
                int inx = Collections.binarySearch(this.dbDrivers, new DatabaseDriverInfo(selectedStr, null, null, false, null));
                this.dbDriverCBX.setSelectedIndex(inx > -1 ? inx : -1);
            }
        } else {
            JOptionPane.showConfirmDialog(null, UIRegistry.getResourceString("NO_DBDRIVERS"), UIRegistry.getResourceString("NO_DBDRIVERS_TITLE"), -1);
            System.exit(1);
        }
        this.addFocusListenerForTextComp(this.username);
        this.addFocusListenerForTextComp(this.password);
        this.addKeyListenerFor(this.username, !isDlg);
        this.addKeyListenerFor(this.password, !isDlg);
        this.addKeyListenerFor(this.databases.getTextField(), !isDlg);
        this.addKeyListenerFor(this.servers.getTextField(), !isDlg);
        if (!isDlg) {
            this.addKeyListenerFor(this.loginBtn, true);
        }
        this.rememberUsernameCBX.setSelected(this.engageUPPrefs ? localPrefs.getBoolean("login.rememberuser", false) : false);
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatabaseLoginPanel.this.dbListener != null) {
                    DatabaseLoginPanel.this.dbListener.cancelled();
                }
            }
        });
        this.loginBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseLoginPanel.this.doLogin();
            }
        });
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, helpContext);
        this.moreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatabaseLoginPanel.this.extraPanel.isVisible()) {
                    if (DatabaseLoginPanel.this.dbDriverCBX.getSelectedIndex() != -1) {
                        DatabaseLoginPanel.this.extraPanel.setVisible(false);
                        DatabaseLoginPanel.this.moreBtn.setIcon(DatabaseLoginPanel.this.forwardImgIcon);
                    }
                } else {
                    DatabaseLoginPanel.this.extraPanel.setVisible(true);
                    DatabaseLoginPanel.this.moreBtn.setIcon(DatabaseLoginPanel.this.downImgIcon);
                }
                if (DatabaseLoginPanel.this.window != null) {
                    DatabaseLoginPanel.this.window.pack();
                }
            }
        });
        this.dbPickList.setSelectedIndex();
        this.svPickList.setSelectedIndex();
        this.servers.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DatabaseLoginPanel.this.updateUIControls();
            }
        });
        this.databases.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DatabaseLoginPanel.this.updateUIControls();
            }
        });
        this.databases.getTextField().addFocusListener(new FocusAdapter(){
            String server = null;

            private String getServerStr() {
                String serverStr = null;
                Object serverObj = DatabaseLoginPanel.this.servers.getValue();
                if (serverObj != null) {
                    serverStr = serverObj.toString();
                }
                return serverStr;
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.server = this.getServerStr();
            }

            @Override
            public void focusLost(FocusEvent e) {
                String newVal;
                if (this.server != null && (newVal = this.getServerStr()) != null && !newVal.equals(this.server)) {
                    DatabaseLoginPanel.this.setUsrPwdControlsFromPrefs();
                }
            }
        });
        this.setUsrPwdControlsFromPrefs();
        PanelBuilder formBuilder = new PanelBuilder(new FormLayout("p,3dlu,p:g", "p,2dlu,p,2dlu,p,2dlu,p,2dlu,p"));
        CellConstraints cc = new CellConstraints();
        formBuilder.addSeparator(UIRegistry.getResourceString("LOGINLABEL"), cc.xywh(1, 1, 3, 1));
        this.addLine("username", this.username, formBuilder, cc, 3);
        this.addLine("password", this.password, formBuilder, cc, 5);
        formBuilder.add((Component)this.moreBtn, cc.xy(3, 7));
        PanelBuilder extraPanelBlder = new PanelBuilder(new FormLayout("p,3dlu,p:g", UIHelper.createDuplicateJGoodiesDef("p", "2dlu", isNotEmbedded ? 9 : 11)));
        this.extraPanel = extraPanelBlder.getPanel();
        this.extraPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        int y = 1;
        y = this.addLine(null, this.rememberUsernameCBX, extraPanelBlder, cc, y);
        y = this.addLine("databases", this.databases, extraPanelBlder, cc, y);
        y = this.addLine("servers", this.servers, extraPanelBlder, cc, y);
        y = this.addLine("driver", this.dbDriverCBX, extraPanelBlder, cc, y);
        if (isNotEmbedded) {
            y = this.addLine("port", this.portSpinner, extraPanelBlder, cc, y);
        }
        if (this.editKeyInfoBtn != null) {
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,f:p:g", "p"));
            pb.add((Component)this.editKeyInfoBtn, cc.xy(1, 1));
            y = this.addLine(null, pb.getPanel(), extraPanelBlder, cc, y);
            pb.getPanel().setOpaque(false);
        }
        this.extraPanel.setVisible(false);
        formBuilder.add((Component)extraPanelBlder.getPanel(), cc.xywh(3, 9, 1, 1));
        PanelBuilder outerPanel = new PanelBuilder(new FormLayout("p,3dlu,p:g", "t:p,2dlu,p,2dlu,p"), (JPanel)this);
        JLabel jLabel = icon = StringUtils.isNotEmpty((String)iconName) ? new JLabel(IconManager.getIcon(iconName)) : null;
        if (icon != null) {
            icon.setBorder(BorderFactory.createEmptyBorder(10, 10, 2, 2));
        }
        formBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        if (icon != null) {
            outerPanel.add((Component)icon, cc.xy(1, 1));
        }
        JPanel btnPanel = ButtonBarFactory.buildOKCancelHelpBar((JButton)this.loginBtn, (JButton)this.cancelBtn, (JButton)this.helpBtn);
        outerPanel.add((Component)formBuilder.getPanel(), cc.xy(3, 1));
        outerPanel.add((Component)btnPanel, cc.xywh(1, 3, 3, 1));
        outerPanel.add((Component)this.statusBar, cc.xywh(1, 5, 3, 1));
        formBuilder.getPanel().setOpaque(false);
        outerPanel.getPanel().setOpaque(false);
        btnPanel.setOpaque(false);
        this.updateUIControls();
        if (skinItem != null) {
            skinItem.popFG("Label.foreground");
        }
    }

    private String getSelectedDatabase() {
        Object obj = this.databases.getComboBox().getSelectedItem();
        if (obj instanceof PickListItemIFace) {
            return ((PickListItemIFace)obj).getValue();
        }
        return obj != null ? obj.toString() : null;
    }

    private void setUsrPwdControlsFromPrefs() {
        String dbName = this.getSelectedDatabase();
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        String userNameStr = "";
        String pwdStr = "";
        if (StringUtils.isNotEmpty((String)dbName) && this.engageUPPrefs) {
            userNameStr = localPrefs.get(this.getUserPrefPath(dbName, true), null);
            if (userNameStr == null) {
                userNameStr = localPrefs.get(this.getUserPrefPath(dbName, false), null);
            }
            if (StringUtils.isNotEmpty((String)userNameStr)) {
                pwdStr = localPrefs.get(this.getPasswordPrefPath(userNameStr, dbName, true), null);
                if (pwdStr == null) {
                    pwdStr = localPrefs.get(this.getPasswordPrefPath(userNameStr, dbName, false), null);
                }
                if (pwdStr != null) {
                    pwdStr = Encryption.decrypt(pwdStr);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)userNameStr) && this.rememberUsernameCBX.isSelected()) {
            this.username.setText(userNameStr);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatabaseLoginPanel.this.password.requestFocus();
                }
            });
        }
        if (StringUtils.isNotEmpty((String)pwdStr) && !UIRegistry.isRelease() || localPrefs.getBoolean("pwd.save", false).booleanValue()) {
            this.password.setText(pwdStr);
        }
    }

    protected void addFocusListenerForTextComp(JTextComponent textField) {
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DatabaseLoginPanel.this.updateUIControls();
            }
        });
    }

    protected void addDocListenerForTextComp(JTextComponent textField) {
        textField.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                DatabaseLoginPanel.this.updateUIControls();
            }
        });
    }

    protected void addKeyListenerFor(JComponent comp, boolean checkForRet) {
        class KeyAdp
        extends KeyAdapter {
            private boolean checkForRetLocal = false;

            public KeyAdp(boolean checkForRetArg) {
                this.checkForRetLocal = checkForRetArg;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatabaseLoginPanel.this.updateUIControls();
                if (this.checkForRetLocal && e.getKeyCode() == 10) {
                    DatabaseLoginPanel.this.doLogin();
                }
            }
        }
        comp.addKeyListener(new KeyAdp(checkForRet));
    }

    protected void updateUIControls() {
        boolean shouldEnable;
        if (this.extraPanel == null || this.isLoggingIn) {
            return;
        }
        String dbName = StringUtils.deleteWhitespace((String)this.databases.getTextField().getText());
        String uName = this.username.getText();
        String pwd = new String(this.password.getPassword());
        boolean bl = shouldEnable = StringUtils.isNotEmpty((String)uName) && StringUtils.isNotEmpty((String)pwd) && (this.servers.getComboBox().getSelectedIndex() != -1 || StringUtils.isNotEmpty((String)this.servers.getTextField().getText())) && StringUtils.isNotEmpty((String)dbName);
        if (shouldEnable && (StringUtils.contains((String)uName, (char)' ') || StringUtils.contains((String)uName, (char)','))) {
            shouldEnable = false;
            this.setMessage(UIRegistry.getResourceString("NO_SPC_USRNAME"), true);
        } else if (shouldEnable && (StringUtils.contains((String)pwd, (char)' ') || StringUtils.contains((String)pwd, (char)','))) {
            shouldEnable = false;
            this.setMessage(UIRegistry.getResourceString("NO_SPC_PWDNAME"), true);
        } else if (shouldEnable && (StringUtils.contains((String)dbName, (char)' ') || StringUtils.contains((String)dbName, (char)','))) {
            shouldEnable = false;
            this.setMessage(UIRegistry.getResourceString("NO_SPC_DBNAME"), true);
        } else if (this.dbDriverCBX.getSelectedIndex() == -1) {
            shouldEnable = false;
            this.setMessage(UIRegistry.getResourceString("MISSING_DRIVER"), true);
            if (!this.extraPanel.isVisible()) {
                this.moreBtn.doClick();
            }
        }
        this.loginBtn.setEnabled(shouldEnable);
        if (shouldEnable) {
            this.setMessage("", false);
        }
    }

    public void setMessage(String msg, boolean isError) {
        if (this.statusBar != null) {
            if (isError) {
                this.statusBar.setErrorMessage(msg, null);
            } else {
                this.statusBar.setText(msg);
            }
        }
    }

    protected void save() {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        if (this.databases != null) {
            this.databases.saveControlData();
        }
        if (this.servers != null) {
            this.servers.saveControlData();
        }
        if (this.doSaveUPPrefs) {
            if (this.databases != null) {
                String dbName = null;
                if (this.databases.getComboBox().getSelectedItem() instanceof PickListItemIFace) {
                    PickListItemIFace pli = (PickListItemIFace)this.databases.getComboBox().getSelectedItem();
                    if (pli != null) {
                        dbName = pli.getValue();
                    }
                } else {
                    dbName = (String)this.databases.getComboBox().getSelectedItem();
                }
                if (dbName != null) {
                    if (this.rememberUsernameCBX.isSelected()) {
                        localPrefs.put(this.getUserPrefPath(dbName, true), this.username.getText());
                    }
                    if (!UIRegistry.isRelease() || localPrefs.getBoolean("pwd.save", false).booleanValue()) {
                        localPrefs.put(this.getPasswordPrefPath(this.username.getText(), dbName, true), Encryption.encrypt(new String(this.password.getPassword())));
                    }
                }
            }
            localPrefs.putBoolean("login.rememberuser", this.rememberUsernameCBX.isSelected());
        }
        if (this.dbDrivers != null && this.dbDriverCBX != null && this.portSpinner != null && this.portSpinner.getValue() != null) {
            localPrefs.put("login.dbdriver_selected", this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex()).getName());
            if (!DBConnection.getInstance().isEmbedded() && !UIRegistry.isMobile()) {
                localPrefs.put(LOGIN_PORT, this.portSpinner.getValue().toString());
            }
        }
    }

    protected void loginOK() {
        Container parent = this.getParent();
        while (!(parent instanceof Window)) {
            parent = parent.getParent();
        }
        this.isCancelled = false;
        if (this.dbListener != null) {
            this.dbListener.loggedIn((Window)parent, this.getDatabaseName(), this.getUserName());
        } else {
            log.debug((Object)"listener is NULL");
        }
    }

    public void setAutoClose(boolean isAutoClose) {
        this.isAutoClose = isAutoClose;
    }

    protected void enableUI(boolean enable) {
        this.cancelBtn.setEnabled(enable);
        this.loginBtn.setEnabled(enable);
        this.helpBtn.setEnabled(enable);
        this.username.setEnabled(enable);
        this.password.setEnabled(enable);
        this.databases.setEnabled(enable);
        this.servers.setEnabled(enable);
        this.rememberUsernameCBX.setEnabled(enable);
        this.dbDriverCBX.setEnabled(enable);
        this.moreBtn.setEnabled(enable);
        if (this.portSpinner != null) {
            this.portSpinner.setEnabled(enable);
        }
        if (this.editKeyInfoBtn != null) {
            this.editKeyInfoBtn.setEnabled(enable);
        }
        for (JLabel lbl : this.labels) {
            lbl.setEnabled(enable);
        }
    }

    private Pair<String, String> getMasterUsrPwd() {
        String usr = null;
        String pwd = null;
        if (this.masterUsrPwdProvider != null) {
            Pair<String, String> masterUsrPwd = this.masterUsrPwdProvider.getUserNamePassword(this.getUserName(), this.getPassword(), this.getDatabaseName());
            if (masterUsrPwd == null) {
                return null;
            }
            if (StringUtils.isEmpty((String)((String)masterUsrPwd.first)) || StringUtils.isEmpty((String)((String)masterUsrPwd.second))) {
                this.setMessage(UIRegistry.getResourceString("BAD_USRPWD"), true);
                return null;
            }
            usr = (String)masterUsrPwd.first;
            pwd = (String)masterUsrPwd.second;
        } else {
            usr = StringUtils.isNotEmpty((String)this.ssUserName) ? this.ssUserName : this.getUserName();
            pwd = StringUtils.isNotEmpty((String)this.ssPassword) ? this.ssPassword : this.getPassword();
        }
        return new Pair<String, String>(usr, pwd);
    }

    public void doLogin() {
        this.isLoggingIn = true;
        this.save();
        if (this.masterUsrPwdProvider != null && !this.masterUsrPwdProvider.hasMasterUserAndPwdInfo(this.getUserName(), this.getPassword(), this.getDatabaseName()) && !this.masterUsrPwdProvider.editMasterInfo(this.getUserName(), this.getDatabaseName(), true)) {
            this.isLoggingIn = false;
            return;
        }
        final String name = this.getClass().getName();
        this.statusBar.setIndeterminate(name, true);
        this.enableUI(false);
        this.setMessage(String.format(UIRegistry.getResourceString("LoggingIn"), this.getDatabaseName()), false);
        String basePrefName = String.valueOf(this.getDatabaseName()) + "." + this.getUserName() + ".";
        this.loginCount = AppPreferences.getLocalPrefs().getLong(String.valueOf(basePrefName) + "logincount", -1L);
        this.loginAccumTime = AppPreferences.getLocalPrefs().getLong(String.valueOf(basePrefName) + "loginaccumtime", -1L);
        if (this.loginCount != -1L && this.loginAccumTime != -1L) {
            int timesPerSecond = 4;
            this.progressWorker = new ProgressWorker(this.statusBar.getProgressBar(), 0, (int)((double)this.loginAccumTime / (double)this.loginCount + 0.5), timesPerSecond);
            new Timer(1000 / timesPerSecond, this.progressWorker).start();
        } else {
            this.loginCount = 0L;
        }
        SwingWorker worker = new SwingWorker(){
            long eTime;
            boolean isLoggedIn = false;
            boolean timeOK = false;
            boolean isLoginCancelled = false;
            Pair<String, String> usrPwd = null;

            @Override
            public Object construct() {
                if (DatabaseLoginPanel.this.checkForProcesses && (DBConnection.getInstance().isEmbedded() || UIRegistry.isMobile())) {
                    SpecifyDBSetupWizardFrame.checkForMySQLProcesses();
                    DatabaseLoginPanel.this.checkForProcesses = false;
                }
                if (UIRegistry.isMobile()) {
                    File mobileTmpDir = DBConnection.getMobileMachineDir(DatabaseLoginPanel.this.getDatabaseName());
                    if (mobileTmpDir == null) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyDBSetupWizard.class, new RuntimeException("Couldn't get MobileTempDir"));
                    }
                    if (mobileTmpDir != null) {
                        UIRegistry.setEmbeddedDBPath(mobileTmpDir.getAbsolutePath());
                    }
                    if (UIRegistry.getMobileEmbeddedDBPath() == null) {
                        UIRegistry.setMobileEmbeddedDBPath(UIRegistry.getDefaultMobileEmbeddedDBPath(DatabaseLoginPanel.this.getDatabaseName()));
                    }
                }
                String connStr = DatabaseLoginPanel.this.getConnectionStr();
                DBConnection.checkForEmbeddedDir(connStr);
                UIRegistry.dumpPaths();
                this.eTime = System.currentTimeMillis();
                this.usrPwd = DatabaseLoginPanel.this.getMasterUsrPwd();
                if (this.usrPwd != null) {
                    this.isLoggedIn = UIHelper.tryLogin(DatabaseLoginPanel.this.getDriverClassName(), DatabaseLoginPanel.this.getDialectClassName(), DatabaseLoginPanel.this.getDatabaseName(), DatabaseLoginPanel.this.getConnectionStr(), (String)this.usrPwd.first, (String)this.usrPwd.second);
                    if (this.isLoggedIn && DatabaseLoginPanel.this.masterUsrPwdProvider != null) {
                        this.isLoggedIn &= DatabaseLoginPanel.this.jaasLogin();
                    }
                } else if (this.usrPwd == null) {
                    this.isLoginCancelled = true;
                    return null;
                }
                if (this.isLoggedIn) {
                    DatabaseDriverInfo drvInfo;
                    if (StringUtils.isNotEmpty((String)DatabaseLoginPanel.this.appName)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DatabaseLoginPanel.this.setMessage(String.format(UIRegistry.getResourceString("Starting"), (this).DatabaseLoginPanel.this.appName), false);
                            }
                        });
                    }
                    if ((drvInfo = DatabaseLoginPanel.this.dbDrivers.get(DatabaseLoginPanel.this.dbDriverCBX.getSelectedIndex())) != null) {
                        if (!DBConnection.getInstance().isEmbedded() && !UIRegistry.isMobile()) {
                            drvInfo.setPort((Integer)DatabaseLoginPanel.this.portSpinner.getValue());
                        }
                        DBConnection.getInstance().setDbCloseConnectionStr(drvInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Close, DatabaseLoginPanel.this.getServerName(), DatabaseLoginPanel.this.getDatabaseName()));
                        DBConnection.getInstance().setServerName(DatabaseLoginPanel.this.getServerName());
                        DBConnection.getInstance().setDriverName(((DatabaseDriverInfo)DatabaseLoginPanel.this.dbDriverCBX.getSelectedItem()).getName());
                        DBConnection.getInstance().setConnectionStr(drvInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, DatabaseLoginPanel.this.getServerName(), DatabaseLoginPanel.this.getDatabaseName()));
                        SchemaUpdateService.SchemaUpdateType status = SchemaUpdateService.getInstance().updateSchema(UIRegistry.getAppVersion(), DatabaseLoginPanel.this.getUserName());
                        if (status == SchemaUpdateService.SchemaUpdateType.Error) {
                            StringBuilder sb = new StringBuilder();
                            for (String s : SchemaUpdateService.getInstance().getErrMsgList()) {
                                sb.append(s);
                                sb.append("\n");
                            }
                            sb.append(UIRegistry.getResourceString("APP_EXIT"));
                            UIRegistry.showError(sb.toString());
                            CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit", null));
                        } else if (status == SchemaUpdateService.SchemaUpdateType.Success || status == SchemaUpdateService.SchemaUpdateType.SuccessAppVer) {
                            String arg = status == SchemaUpdateService.SchemaUpdateType.SuccessAppVer ? UIRegistry.getAppVersion() : "";
                            UIRegistry.showLocalizedMsg(3, "INFORMATION", status == SchemaUpdateService.SchemaUpdateType.SuccessAppVer ? "APPVER_UP_OK" : "SCHEMA_UP_OK", arg);
                        }
                    }
                }
                return null;
            }

            @Override
            public void finished() {
                DatabaseLoginPanel.this.statusBar.setIndeterminate(name, false);
                if (this.isLoggedIn) {
                    DatabaseLoginPanel.this.setMessage(UIRegistry.getResourceString("LoadingSchema"), false);
                    DatabaseLoginPanel.this.statusBar.repaint();
                    DataProviderFactory.getInstance().shutdown();
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    session.close();
                    long endTime = System.currentTimeMillis();
                    this.eTime = (endTime - this.eTime) / 1000L;
                    this.timeOK = true;
                    if (DatabaseLoginPanel.this.progressWorker != null) {
                        DatabaseLoginPanel.this.progressWorker.stop();
                    }
                    DatabaseLoginPanel.this.statusBar.setProgressDone(this.getClass().getName());
                    if (this.timeOK) {
                        DatabaseLoginPanel.this.elapsedTime = this.eTime;
                        DatabaseLoginPanel.this.loginAccumTime += DatabaseLoginPanel.this.elapsedTime;
                        if (DatabaseLoginPanel.this.loginCount < 1000L) {
                            String basePrefNameStr = String.valueOf(DatabaseLoginPanel.this.getDatabaseName()) + "." + DatabaseLoginPanel.this.getUserName() + ".";
                            AppPreferences.getLocalPrefs().putLong(String.valueOf(basePrefNameStr) + "logincount", ++DatabaseLoginPanel.this.loginCount);
                            AppPreferences.getLocalPrefs().putLong(String.valueOf(basePrefNameStr) + "loginaccumtime", DatabaseLoginPanel.this.loginAccumTime);
                        }
                    }
                    DatabaseLoginPanel.this.loginOK();
                    DatabaseLoginPanel.this.isLoggingIn = false;
                } else {
                    if (!this.isLoginCancelled) {
                        String msg = DBConnection.getInstance().getErrorMsg();
                        DatabaseLoginPanel.this.setMessage(StringUtils.isEmpty((String)msg) ? UIRegistry.getResourceString("INVALID_LOGIN") : msg, true);
                        if (DBConnection.getInstance().isEmbedded() || UIRegistry.isMobile()) {
                            DataProviderFactory.getInstance().shutdown();
                            DBConnection.shutdown();
                            DBConnection.shutdownFinalConnection(false, true);
                            DBConnection.startOver();
                        } else if (this.usrPwd != null) {
                            DatabaseLoginPanel.this.doCheckPermissions(this.usrPwd);
                        }
                    }
                    DatabaseLoginPanel.this.enableUI(true);
                    DatabaseLoginPanel.this.isLoggingIn = false;
                }
                if (DatabaseLoginPanel.this.isAutoClose) {
                    DatabaseLoginPanel.this.updateUIControls();
                }
            }
        };
        worker.start();
    }

    public static Pair<String, String> getITUsernamePwd() {
        JTextField userNameTF = UIHelper.createTextField(15);
        JPasswordField passwordTF = UIHelper.createPasswordField();
        JLabel statusLbl = UIHelper.createLabel("");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,4px,p,10px,p"));
        pb.add((Component)UIHelper.createI18NFormLabel("IT_Username"), cc.xy(1, 1));
        pb.add((Component)userNameTF, cc.xy(3, 1));
        pb.add((Component)UIHelper.createI18NFormLabel("IT_Password"), cc.xy(1, 3));
        pb.add((Component)passwordTF, cc.xy(3, 3));
        pb.add((Component)statusLbl, cc.xyw(1, 5, 3));
        PanelBuilder outerPanel = new PanelBuilder(new FormLayout("p,3dlu,p:g", "t:p:g"));
        JLabel icon = new JLabel(IconManager.getIcon("MySQLFull"));
        icon.setBorder(BorderFactory.createEmptyBorder(10, 10, 2, 2));
        pb.getPanel().setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        outerPanel.add((Component)icon, cc.xy(1, 1));
        outerPanel.add((Component)pb.getPanel(), cc.xy(3, 1));
        while (true) {
            CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("IT_LOGIN"), true, outerPanel.getPanel());
            dlg.setVisible(true);
            if (dlg.isCancelled()) break;
            String uName = userNameTF.getText();
            String pwd = new String(passwordTF.getPassword());
            DBConnection dbc = DBConnection.getInstance();
            DBConnection dbConn = DBConnection.createInstance(dbc.getDriver(), dbc.getDialect(), dbc.getDatabaseName(), dbc.getConnectionStr(), uName, pwd);
            if (dbConn == null) continue;
            DBMSUserMgr dbMgr = DBMSUserMgr.getInstance();
            dbMgr.close();
            if (dbMgr.connect(uName, pwd, dbc.getServerName(), dbc.getDatabaseName())) {
                dbMgr.close();
                return new Pair<String, String>(uName, pwd);
            }
            dbMgr.close();
            statusLbl.setText("<HTML><font color=\"red\">" + UIRegistry.getResourceString("IT_LOGIN_ERROR") + "</font></HTML>");
        }
        return null;
    }

    private void doCheckPermissions(Pair<String, String> usrPwd) {
        if (System.getProperty("user.name").equals("rods")) {
            boolean doFixIt;
            String dbDriver = DBConnection.getInstance().getDriver();
            String serverName = this.getServerName();
            String dbName = this.getDatabaseName();
            SQLException loginEx = DBConnection.getLoginException();
            if (StringUtils.isNotEmpty((String)dbDriver) && dbDriver.equals("com.mysql.jdbc.Driver") && loginEx != null && StringUtils.isNotEmpty((String)loginEx.getSQLState()) && loginEx.getSQLState().equals("08001") && (doFixIt = UIRegistry.displayConfirmLocalized("MISSING_PRIV_TITLE", "MISSING_PRIV", "MISSING_PRIV_FIX", "Cancel", 2))) {
                DBConnection.getInstance().setServerName(serverName);
                Pair<String, String> itUP = DatabaseLoginPanel.getITUsernamePwd();
                DBMSUserMgr mgr = DBMSUserMgr.getInstance();
                try {
                    if (mgr != null && mgr.connectToDBMS((String)itUP.first, (String)itUP.second, serverName)) {
                        boolean isOK = mgr.setPermissions((String)usrPwd.first, dbName, 31);
                        UIRegistry.showLocalizedMsg(isOK ? 1 : 0, UIRegistry.getResourceString("MISSING_PRIV_TITLE"), isOK ? "MISSING_PRIV_OK" : "MISSING_PRIV_ERR", new Object[0]);
                        mgr.close();
                    } else {
                        UIRegistry.showError("MISSING_PRIV_NO_LOGIN");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean jaasLogin() {
        if (this.jaasContext != null) {
            Pair<String, String> usrPwd = this.getMasterUsrPwd();
            return this.jaasContext.jaasLogin(this.getUserName(), this.getPassword(), this.getConnectionStr(), this.getDriverClassName(), (String)usrPwd.first, (String)usrPwd.second);
        }
        return false;
    }

    public String getServerName() {
        return this.servers.getTextField().getText().trim();
    }

    public String getDatabaseName() {
        return this.doLoginWithDB ? this.databases.getTextField().getText().trim() : null;
    }

    public String getUserName() {
        return this.username.getText().trim();
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public String getConnectionStr() {
        if (this.dbDriverCBX.getSelectedIndex() > -1) {
            DatabaseDriverInfo drvInfo = this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex());
            if (!DBConnection.getInstance().isEmbedded() && !UIRegistry.isMobile() && this.portSpinner != null) {
                drvInfo.setPort((Integer)this.portSpinner.getValue());
            }
            return drvInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.getServerName(), this.getDatabaseName());
        }
        return null;
    }

    public String getDialectClassName() {
        if (this.dbDriverCBX.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex()).getDialectClassName();
        }
        return null;
    }

    public String getDriverClassName() {
        if (this.dbDriverCBX.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex()).getDriverClassName();
        }
        return null;
    }

    public boolean doingAutoLogin() {
        return AppPreferences.getLocalPrefs().getBoolean("autologin", false);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean isLoggingIn() {
        return this.isLoggingIn;
    }

    public void setLoggingIn(boolean isLoggingIn) {
        this.isLoggingIn = isLoggingIn;
    }

    public static interface MasterPasswordProviderIFace {
        public boolean hasMasterUserAndPwdInfo(String var1, String var2, String var3);

        public Pair<String, String> getUserNamePassword(String var1, String var2, String var3);

        public boolean editMasterInfo(String var1, String var2, boolean var3);
    }

    class ProgressWorker
    implements ActionListener {
        protected int timesASecond;
        protected JProgressBar progressBar;
        protected int count;
        protected int totalCount;
        protected boolean stop = false;

        public ProgressWorker(JProgressBar progressBar, int count, int totalCount, int timesPerSecond) {
            this.timesASecond = timesPerSecond;
            this.progressBar = progressBar;
            this.count = count;
            this.totalCount = totalCount * this.timesASecond;
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.totalCount);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++this.count;
            this.progressBar.setValue(this.count);
            if (!this.stop) {
                if (this.count >= this.totalCount || this.progressBar.getValue() >= this.totalCount) {
                    this.progressBar.setIndeterminate(true);
                }
            } else {
                ((Timer)e.getSource()).stop();
            }
        }

        public synchronized void stop() {
            this.stop = true;
        }
    }
}

