/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DatabaseLoginDlg
extends JDialog
implements DatabaseLoginListener {
    private static final Logger log = Logger.getLogger(DatabaseLoginDlg.class);
    protected DatabaseLoginPanel dbPanel;
    protected DatabaseLoginListener listener;
    protected boolean doAutoClose = true;
    protected JPanel glassPane = new JPanel();

    public DatabaseLoginDlg(Frame frame, String userName, String password, boolean engageUPPrefs, DatabaseLoginListener listener, String iconName, String helpContext) {
        super(frame);
        this.listener = listener;
        this.dbPanel = new DatabaseLoginPanel(userName, password, engageUPPrefs, this, true, iconName, helpContext);
        this.setContentPane(this.dbPanel);
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.dbPanel.getLoginBtn());
        this.pack();
    }

    public boolean isCancelled() {
        return this.dbPanel.isCancelled();
    }

    public boolean doingAutoLogin() {
        return this.dbPanel.doingAutoLogin();
    }

    public void setDoAutoClose(boolean doAutoClose) {
        this.doAutoClose = doAutoClose;
        if (this.dbPanel != null) {
            this.dbPanel.setAutoClose(doAutoClose);
        }
    }

    public DatabaseLoginPanel getDatabaseLoginPanel() {
        return this.dbPanel;
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.dbPanel.doLogin();
        }
        super.setVisible(show);
    }

    public void aboutToLoginIn() {
        this.glassPane.setSize(this.getSize());
        this.setGlassPane(this.glassPane);
    }

    @Override
    public void loggedIn(Window window, String databaseName, String userName) {
        log.debug((Object)"loggedIn");
        this.setVisible(false);
        this.dispose();
        if (this.listener != null) {
            this.listener.loggedIn(window, databaseName, userName);
        }
    }

    @Override
    public void cancelled() {
        this.setVisible(false);
        this.dispose();
        if (this.listener != null) {
            this.listener.cancelled();
        }
    }
}

