/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.CommandAction;
import org.apache.log4j.Logger;

public class CommandActionForDB
extends CommandAction {
    private static final Logger log = Logger.getLogger(CommandActionForDB.class);
    protected Integer id;

    public CommandActionForDB(String type, String action, int tableId, int dataObjId) {
        super(type, action, tableId);
        this.id = dataObjId;
    }

    public Integer getId() {
        return this.id;
    }

    public Object getDataObj() {
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(this.tableId);
        if (tableInfo != null) {
            DataProviderSessionIFace session = null;
            try {
                session = DataProviderFactory.getInstance().createSession();
                Object object = session.getData("FROM " + tableInfo.getClassName() + " WHERE id = " + this.id);
                return object;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(CommandActionForDB.class, ex);
                log.error((Object)ex);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        } else {
            log.error((Object)("Couldn't find Table [" + this.id + "]"));
        }
        return null;
    }
}

