/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import edu.ku.brc.af.core.expresssearch.SearchConfigService;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.SearchBorder;
import edu.ku.brc.ui.SearchBorderMac;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;

public class SearchBox
extends JPanel
implements ActionListener,
PropertyChangeListener {
    protected static ImageIcon searchIcon = SearchBox.getSearchIcon();
    protected JAutoCompTextField searchText;
    protected ImageIcon triangleIcon = null;
    protected ImageIcon icon = null;
    protected List<JComponent> menus = new ArrayList<JComponent>();
    protected int iconWidth;
    protected JButton clearIconBtn = null;
    protected int heightAdjust;
    protected int widthAdjust;
    protected int popupHitWidth;
    protected MenuCreator menuCreator = null;

    public SearchBox(JAutoCompTextField textField, MenuCreator menuCreator) {
        this(textField, menuCreator, false);
    }

    public SearchBox(final JAutoCompTextField textField, MenuCreator menuCreator, boolean includeClearIcon) {
        super(null);
        this.menuCreator = menuCreator;
        SearchConfigService.getInstance().addPropertyChangeListener(this);
        this.setOpaque(false);
        this.triangleIcon = menuCreator != null ? IconManager.getIcon("SearchTriangle") : null;
        this.icon = searchIcon;
        int triWidth = this.triangleIcon != null ? this.triangleIcon.getIconWidth() : 0;
        this.iconWidth = Math.max(16, this.iconWidth);
        if (includeClearIcon) {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).SearchBox.this.searchText.setText("");
                        }
                    });
                }
            };
            this.clearIconBtn = UIHelper.createIconBtn("MacSearchClose", null, true, (Action)action);
            this.clearIconBtn.setEnabled(true);
            this.clearIconBtn.setFocusable(false);
            this.clearIconBtn.setVisible(false);
        }
        if (this.clearIconBtn != null) {
            textField.getDocument().addDocumentListener(new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    SearchBox.this.clearIconBtn.setVisible(!textField.getText().isEmpty());
                }
            });
        }
        this.setBorder(UIHelper.isMacOS() ? new SearchBorderMac(this.iconWidth + triWidth) : new SearchBorder(this.iconWidth + triWidth));
        this.searchText = textField;
        this.searchText.setBorder(null);
        this.add(this.searchText);
        if (this.clearIconBtn != null) {
            this.add(this.clearIconBtn);
        }
        this.popupHitWidth = 7 + this.iconWidth + triWidth + 2;
        this.searchText.setLocation(this.popupHitWidth, 4);
        Dimension size = textField.getPreferredSize();
        textField.setSize(size);
        this.widthAdjust = 16 + this.iconWidth + triWidth;
        this.heightAdjust = 8;
        final SearchBox p = this;
        if (menuCreator != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SearchBox.this.searchText.isEnabled()) {
                        super.mouseReleased(e);
                        if (e.getPoint().x <= SearchBox.this.popupHitWidth) {
                            JPopupMenu popup = SearchBox.this.getPopupMenu(p);
                            popup.show(p, 0, p.getHeight());
                        }
                    }
                }
            });
        }
        this.searchText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                SearchBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                SearchBox.this.repaint();
            }
        });
    }

    public void addClearListener(ActionListener l) {
        if (this.clearIconBtn != null) {
            this.clearIconBtn.addActionListener(l);
        }
    }

    public JAutoCompTextField getSearchText() {
        return this.searchText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.searchText.setEnabled(enabled);
        if (this.clearIconBtn != null) {
            this.clearIconBtn.setEnabled(enabled);
        }
    }

    public MenuCreator getMenuCreator() {
        return this.menuCreator;
    }

    public static ImageIcon getSearchIcon() {
        if (searchIcon == null) {
            searchIcon = UIHelper.isMacOS() ? IconManager.getIcon("SearchBoxMac") : IconManager.getIcon("SearchBoxLinux", IconManager.IconSize.Std16);
        }
        return searchIcon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem mi;
        if (e.getSource() instanceof JMenuItem && (mi = (JMenuItem)e.getSource()).getIcon() != null && !mi.getText().equals(UIRegistry.getResourceString("ESConfig"))) {
            this.icon = (ImageIcon)mi.getIcon();
            this.repaint();
        }
    }

    public void resetSearchIcon() {
        this.icon = searchIcon;
        this.repaint();
    }

    protected JPopupMenu getPopupMenu(ActionListener l) {
        if (this.menuCreator != null) {
            JPopupMenu popupMenu = new JPopupMenu();
            for (JComponent comp : this.menuCreator.createPopupMenus()) {
                if (comp instanceof JMenuItem) {
                    popupMenu.add((JMenuItem)comp);
                    ((JMenuItem)comp).addActionListener(l);
                    continue;
                }
                if (!(comp instanceof JSeparator)) continue;
                popupMenu.add(comp);
            }
            return popupMenu;
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRoundRect(0, 0, width - 1, height - 1, height - 1, height - 1);
        int ih = this.icon.getIconHeight();
        g.drawImage(this.icon.getImage(), 6, (height - ih) / 2 + 1, null);
        if (this.triangleIcon != null) {
            g.drawImage(this.triangleIcon.getImage(), 6 + this.iconWidth, (height - this.triangleIcon.getIconWidth()) / 2 + 2, null);
        }
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.searchText.getPreferredSize();
        size.width += this.widthAdjust;
        size.height += this.heightAdjust;
        return size;
    }

    protected void resizeSearchText(int width, int height) {
        Dimension d = this.searchText.getSize();
        d.width = width - this.widthAdjust - 5 - (this.clearIconBtn != null ? this.clearIconBtn.getWidth() : 0);
        d.height = height - this.heightAdjust;
        this.searchText.setSize(d);
        if (this.clearIconBtn != null) {
            Rectangle r = this.clearIconBtn.getBounds();
            r.x = this.searchText.getX() + d.width;
            r.y = (this.getSize().height - r.height) / 2;
            r.width = this.clearIconBtn.getWidth();
            r.height = this.clearIconBtn.getHeight();
            this.clearIconBtn.setBounds(r);
        }
    }

    @Override
    public void resize(Dimension d) {
        super.setSize(d);
        this.resizeSearchText(d.width, d.height);
    }

    @Override
    public void resize(int width, int height) {
        super.setSize(width, height);
        this.resizeSearchText(width, height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.resizeSearchText(width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.resizeSearchText(r.width, r.height);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d.width, d.height);
        this.resizeSearchText(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.resizeSearchText(width, height);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.menuCreator != null) {
            if (evt.getPropertyName().equals("contentsChanged")) {
                this.menuCreator.reset();
            } else if (evt.getPropertyName().equals("noContext")) {
                this.icon = searchIcon;
                this.repaint();
            }
        }
    }

    public static interface MenuCreator {
        public List<JComponent> createPopupMenus();

        public void reset();
    }
}

