/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import edu.ku.brc.ui.UIHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ProcessListUtil {
    private static String CSV_PATTERN = "\"([^\"]+?)\",?|([^,]+),?|,";
    private static Pattern csvRE = Pattern.compile(CSV_PATTERN);

    private static List<String> parse(String line) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = csvRE.matcher(line);
        while (m.find()) {
            String match = m.group();
            if (match == null) break;
            if (match.endsWith(",")) {
                match = match.substring(0, match.length() - 1);
            }
            if (match.startsWith("\"")) {
                match = match.substring(1, match.length() - 1);
            }
            if (match.length() == 0) {
                match = null;
            }
            list.add(match);
        }
        return list;
    }

    public static List<List<String>> getRunningProcessesWin() {
        ArrayList<List<String>> processList = new ArrayList<List<String>>();
        try {
            String line;
            boolean doDebug = true;
            Process process = Runtime.getRuntime().exec("tasklist.exe /v /nh /FO CSV");
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                if (doDebug && StringUtils.contains((String)line, (String)"mysql")) {
                    String lineStr = StringUtils.replaceChars((String)line, (char)'\\', (char)'/');
                    System.out.println("\n[" + lineStr + "]");
                    for (String tok : ProcessListUtil.parse(lineStr)) {
                        System.out.print("[" + tok + "]");
                    }
                    System.out.println();
                }
                processList.add(ProcessListUtil.parse(StringUtils.replaceChars((String)line, (char)'\\', (char)'/')));
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return processList;
    }

    public static List<List<String>> getRunningProcessesUnix() {
        ArrayList<List<String>> processes = new ArrayList<List<String>>();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("ps aux");
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Integer cmdInx = null;
            while ((line = input.readLine()) != null) {
                String[] tokens;
                if (cmdInx == null) {
                    cmdInx = line.indexOf("COMMAND");
                }
                if (line.trim().equals("")) continue;
                ArrayList<String> fields = new ArrayList<String>();
                String[] stringArray = tokens = StringUtils.split((String)line.substring(0, cmdInx).trim(), (char)' ');
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String tok = stringArray[n2];
                    fields.add(tok);
                    ++n2;
                }
                fields.add(line.substring(cmdInx, line.length()));
                processes.add(fields);
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return processes;
    }

    public static List<Integer> getProcessIdWithText(String ... text) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<List<String>> processList = ProcessListUtil.getRunningProcesses();
        for (List<String> line : processList) {
            int found = 0;
            for (String field : line) {
                int i = 0;
                while (i < text.length) {
                    if (StringUtils.contains((String)field.toLowerCase(), (String)text[i].toLowerCase())) {
                        ++found;
                    }
                    ++i;
                }
            }
            if (found != text.length) continue;
            ids.add(Integer.parseInt(line.get(1)));
        }
        return ids;
    }

    public static List<List<String>> getRunningProcesses() {
        if (UIHelper.isWindows()) {
            return ProcessListUtil.getRunningProcessesWin();
        }
        return ProcessListUtil.getRunningProcessesUnix();
    }

    public static boolean killProcess(int processId) {
        String cmd = UIHelper.isWindows() ? "taskkill /PID " + processId : "kill " + processId;
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        List<Integer> ids = !UIHelper.isWindows() ? ProcessListUtil.getProcessIdWithText("3337") : ProcessListUtil.getProcessIdWithText("_data/bin/mysqld");
        for (Integer id : ids) {
            System.out.println("KILLING: " + id);
        }
    }
}

