/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.PopupDlgId;
import org.apache.log4j.Logger;

public class PopupDlgPrefsMgr {
    private static final Logger log = Logger.getLogger(PopupDlgPrefsMgr.class);
    AppPreferences appPrefs = AppPreferences.getRemote();
    private String dialogNamePrefix = "ui.popupdialog.";

    public int generatePopupDialogId(String title, String message, String identifierStr) {
        log.debug((Object)"Generating DialogId");
        PopupDlgId popupId = new PopupDlgId(title, message, identifierStr);
        return popupId.getId();
    }

    public void disableDialog(int dialogId, int actionChoice) {
        String dialogPrefName = String.valueOf(this.dialogNamePrefix) + dialogId;
        log.debug((Object)("Adding disabling dialog to preferences: [" + dialogId + "] with selected value of: " + actionChoice));
        this.appPrefs.putInt(dialogPrefName, actionChoice);
    }

    public void removeDialogFromPrefs(int dialogId) {
        String dialogPrefName = String.valueOf(this.dialogNamePrefix) + dialogId;
        log.debug((Object)("Removing dialog from preferences: [" + dialogId + "]"));
        this.appPrefs.remove(dialogPrefName);
    }

    public int getDisabledDialogOptionSelection(int dialogId) {
        String dialogPrefName = String.valueOf(this.dialogNamePrefix) + dialogId;
        log.debug((Object)("Reading preference to get previous selection choice for dialog: [" + dialogId + "]"));
        int actionChoice = this.appPrefs.getInt(dialogPrefName, -1);
        log.debug((Object)(" Selection was: " + actionChoice));
        return actionChoice;
    }

    public boolean isDialogDisabled(int dialogId) {
        String dialogPrefName = String.valueOf(this.dialogNamePrefix) + dialogId;
        log.debug((Object)("Reading preferences to check whether dialog has been disabled: [" + dialogId + "]"));
        int actionChoice = this.appPrefs.getInt(dialogPrefName, -1);
        if (actionChoice == -1) {
            log.debug((Object)"Dialog has not been disabled");
            return false;
        }
        log.debug((Object)"Dialog previously has been disabled");
        return true;
    }
}

