/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import edu.ku.brc.af.ui.PopupDlgContent;
import edu.ku.brc.af.ui.PopupDlgPrefsMgr;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PopupDlg {
    public static final Logger log = Logger.getLogger(PopupDlg.class);
    public static int ERROR_MESSAGE = 0;
    public static int INFORMATION_MESSAGE = 1;
    public static int WARNING_MESSAGE = 2;
    public static int QUESTION_MESSAGE = 3;
    public static int PLAIN_MESSAGE = -1;
    public static int DEFAULT_OPTION = -1;
    public static int YES_NO_CANCEL_OPTION = 1;
    public static int YES_NO_OPTION = 0;
    public static int YES_OPTION = 0;
    public static int NO_OPTION = 1;
    public static int CANCEL_OPTION = 2;
    public static int OK_OPTION = 0;
    public static int CLOSED_OPTION = -1;

    public static int showConfirmDialog(Component parent, String message, String callingClassname, int dialogNumber) {
        PopupDlgPrefsMgr popupMgr = new PopupDlgPrefsMgr();
        int dialogId = popupMgr.generatePopupDialogId("", message, String.valueOf(callingClassname) + dialogNumber);
        boolean dontShow = popupMgr.isDialogDisabled(dialogId);
        if (!dontShow) {
            PopupDlgContent components = new PopupDlgContent(message);
            int response = JOptionPane.showConfirmDialog(parent, components.getComponents());
            boolean disableMe = components.isCheckboxSelected();
            if (disableMe) {
                log.debug((Object)"User has selected to disable the popup");
                popupMgr.disableDialog(dialogId, response);
            } else {
                log.debug((Object)"User has selected not to disable the popup");
            }
            return response;
        }
        return popupMgr.getDisabledDialogOptionSelection(dialogId);
    }

    public static int showConfirmDialog(Component parent, String message, String title, String doNotAgainMessage, int optionType, String callingClassname, int dialogNumber) {
        PopupDlgPrefsMgr popupMgr = new PopupDlgPrefsMgr();
        int dialogId = popupMgr.generatePopupDialogId(title, message, String.valueOf(callingClassname) + dialogNumber);
        boolean dontShow = popupMgr.isDialogDisabled(dialogId);
        if (!dontShow) {
            PopupDlgContent components = null;
            components = StringUtils.isBlank((String)doNotAgainMessage) ? new PopupDlgContent(message) : new PopupDlgContent(message, doNotAgainMessage);
            int response = JOptionPane.showConfirmDialog(parent, components.getComponents(), title, optionType);
            boolean disableMe = components.isCheckboxSelected();
            if (disableMe) {
                log.debug((Object)"User has selected to disable the popup");
                popupMgr.disableDialog(dialogId, response);
            } else {
                log.debug((Object)"User has selected not to disable the popup");
            }
            return response;
        }
        return popupMgr.getDisabledDialogOptionSelection(dialogId);
    }

    public static int showConfimDialog(Component parent, String message, String title, String doNotAgainMessage, int optionType, int messageType, Icon icon, String callingClassname, int dialogNumber) {
        PopupDlgPrefsMgr popupMgr = new PopupDlgPrefsMgr();
        int dialogId = popupMgr.generatePopupDialogId(title, message, String.valueOf(callingClassname) + dialogNumber);
        boolean dontShow = popupMgr.isDialogDisabled(dialogId);
        if (!dontShow) {
            PopupDlgContent components = new PopupDlgContent(message, doNotAgainMessage);
            int response = JOptionPane.showConfirmDialog(parent, components.getComponents(), title, optionType, messageType, icon);
            boolean disableMe = components.isCheckboxSelected();
            if (disableMe) {
                log.debug((Object)"User has selected to disable the popup");
                popupMgr.disableDialog(dialogId, response);
            } else {
                log.debug((Object)"User has selected not to disable the popup");
            }
            return response;
        }
        return popupMgr.getDisabledDialogOptionSelection(dialogId);
    }

    public static void main(String[] args) {
    }
}

