/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;

public class PasswordStrengthUI
extends JPanel
implements UIPluginable,
GetSetValueIFace {
    private static final int PWD_MIXED_CASE = 1;
    private static final int PWD_NUMERIC = 1;
    private static final int PWD_SPECIAL = 1;
    private String[] SCORE_KEYS = new String[]{"VERY_WEAK", "WEAK", "MEDIOCRE", "STRONG", "VERY_STRONG"};
    private String[] ERR_KEYS = new String[]{"PWD_MIN_LENGTH", "PWD_NUMERIC", "PWD_MIXED_CASE", "PWD_SPECIAL"};
    private JCheckBox[] cbxs = new JCheckBox[this.ERR_KEYS.length];
    private String[] scoreStrings;
    private String[] errorStrings;
    protected ColorPanel colorPanel;
    protected JProgressBar progress;
    protected int score = 0;
    protected String errReason = null;
    protected String scoreDesc = null;
    protected int minPwdLen;
    protected boolean doPainting = false;
    protected boolean initialSet = true;

    public PasswordStrengthUI() {
        this(8);
    }

    public PasswordStrengthUI(int minPwdLen) {
        super(new BorderLayout());
        this.minPwdLen = minPwdLen;
        this.progress = new JProgressBar(0, 100);
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.scoreStrings = new String[this.SCORE_KEYS.length];
        int i = 0;
        while (i < this.SCORE_KEYS.length) {
            this.scoreStrings[i] = UIRegistry.getResourceString(this.getKey(this.SCORE_KEYS[i]));
            ++i;
        }
        CellConstraints cc = new CellConstraints();
        PanelBuilder pbi = new PanelBuilder(new FormLayout(UIHelper.createDuplicateJGoodiesDef("p", "4px", this.cbxs.length), "p"));
        this.errorStrings = new String[this.ERR_KEYS.length];
        int x = 1;
        int i2 = 0;
        while (i2 < this.ERR_KEYS.length) {
            this.errorStrings[i2] = UIRegistry.getResourceString(this.getKey(this.ERR_KEYS[i2]));
            this.cbxs[i2] = UIHelper.createCheckBox(this.errorStrings[i2]);
            pbi.add((Component)this.cbxs[i2], cc.xy(x, 1));
            this.cbxs[i2].setEnabled(false);
            x += 2;
            ++i2;
        }
        UIRegistry.popResourceBundle();
        this.colorPanel = new ColorPanel();
        this.colorPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,4px,p"), (JPanel)this);
        pb.add((Component)this.colorPanel, cc.xy(1, 1));
        pb.add((Component)pbi.getPanel(), cc.xy(1, 3));
    }

    public void setMinPwdLen(int minPwdLen) {
        this.minPwdLen = minPwdLen;
    }

    public void setPasswordField(final JTextField pwdTF, final JButton btn) {
        DocumentAdaptor listener = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                String txt = pwdTF.getText();
                if (StringUtils.isEmpty((String)txt)) {
                    PasswordStrengthUI.this.initialSet = true;
                    PasswordStrengthUI.this.doPainting = false;
                    JCheckBox[] jCheckBoxArray = PasswordStrengthUI.this.cbxs;
                    int n = jCheckBoxArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JCheckBox cbx = jCheckBoxArray[n2];
                        cbx.setSelected(false);
                        ++n2;
                    }
                } else if (PasswordStrengthUI.this.initialSet) {
                    PasswordStrengthUI.this.initialSet = false;
                } else {
                    PasswordStrengthUI.this.doPainting = true;
                }
                if (btn != null) {
                    btn.setEnabled(!txt.isEmpty());
                }
                if (PasswordStrengthUI.this.doPainting) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PasswordStrengthUI.this.checkStrength(pwdTF.getText());
                            (this).PasswordStrengthUI.this.colorPanel.repaint();
                        }
                    });
                }
            }
        };
        pwdTF.getDocument().addDocumentListener(listener);
    }

    public String getScoreDesc() {
        int inx = this.score < 16 ? 0 : (this.score < 25 ? 1 : (this.score < 35 ? 2 : (this.score < 45 ? 3 : 4)));
        return this.scoreStrings[inx];
    }

    public int getScore() {
        return Math.min((int)((double)this.score / 50.0 * 100.0), 100);
    }

    public boolean checkStrength(String pwd) {
        boolean isOK = this.checkStrengthInternal(pwd);
        if (isOK) {
            this.progress.setValue(this.getScore());
            this.progress.setString(this.getScoreDesc());
        } else {
            this.progress.setValue(0);
            this.progress.setString(this.errReason);
        }
        return isOK;
    }

    private String getKey(String key) {
        return "PasswordStrengthUI." + key;
    }

    private boolean checkStrengthInternal(String pwd) {
        int upper = 0;
        int lower = 0;
        int numbers = 0;
        int special = 0;
        int length = 0;
        this.score = 0;
        if (StringUtils.isEmpty((String)pwd)) {
            return false;
        }
        length = pwd.length();
        if (length < 5) {
            this.score += 3;
        } else if (length > 4 && length < 8) {
            this.score += 6;
        } else if (length > 7 && length < 16) {
            this.score += 12;
        } else if (length > 15) {
            this.score += 18;
        }
        Pattern p = Pattern.compile(".??[a-z]");
        Matcher m = p.matcher(pwd);
        while (m.find()) {
            ++lower;
        }
        if (lower > 0) {
            ++this.score;
        }
        p = Pattern.compile(".??[A-Z]");
        m = p.matcher(pwd);
        while (m.find()) {
            ++upper;
        }
        if (upper > 0) {
            this.score += 5;
        }
        p = Pattern.compile(".??[0-9]");
        m = p.matcher(pwd);
        while (m.find()) {
            ++numbers;
        }
        if (numbers > 0) {
            this.score += 5;
            if (numbers > 1) {
                this.score += 2;
                if (numbers > 2) {
                    this.score += 3;
                }
            }
        }
        p = Pattern.compile(".??[:,!,@,#,$,%,^,&,*,?,_,~]");
        m = p.matcher(pwd);
        while (m.find()) {
            ++special;
        }
        if (special > 0) {
            this.score += 5;
            if (special > 1) {
                this.score += 5;
            }
        }
        if (upper > 0 && lower > 0) {
            this.score += 2;
        }
        if ((upper > 0 || lower > 0) && numbers > 0) {
            this.score += 2;
        }
        if ((upper > 0 || lower > 0) && numbers > 0 && special > 0) {
            this.score += 2;
        }
        if (upper > 0 && lower > 0 && numbers > 0 && special > 0) {
            this.score += 2;
        }
        JCheckBox[] jCheckBoxArray = this.cbxs;
        int n = this.cbxs.length;
        int n2 = 0;
        while (n2 < n) {
            JCheckBox cbx = jCheckBoxArray[n2];
            cbx.setSelected(false);
            ++n2;
        }
        this.errReason = null;
        if (length < this.minPwdLen) {
            this.errReason = this.errorStrings[0];
        } else {
            this.cbxs[0].setSelected(true);
        }
        if (numbers < 1) {
            this.errReason = this.errorStrings[1];
        } else {
            this.cbxs[1].setSelected(true);
        }
        if (upper < 1 || lower < 1) {
            this.errReason = this.errorStrings[2];
        } else {
            this.cbxs[2].setSelected(true);
        }
        if (special < 1) {
            this.errReason = this.errorStrings[3];
        } else {
            this.cbxs[3].setSelected(true);
        }
        return true;
    }

    @Override
    public boolean canCarryForward() {
        return false;
    }

    @Override
    public String[] getCarryForwardFields() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Password Strength";
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void initialize(Properties properties, boolean isViewMode) {
    }

    @Override
    public boolean isNotEmpty() {
        return false;
    }

    @Override
    public void setCellName(String cellName) {
    }

    @Override
    public void setParent(FormViewObj parent) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"password"};
    }

    @Override
    public void carryForwardStateChange() {
    }

    @Override
    public void setNewObj(boolean isNewObj) {
    }

    class ColorPanel
    extends JComponent {
        @Override
        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(200, new JLabel((String)"X").getPreferredSize().height + ins.top + ins.bottom + 4);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isEnabled() && PasswordStrengthUI.this.doPainting) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getBackground());
                Dimension size = this.getSize();
                Insets ins = this.getInsets();
                int barWidth = size.width - ins.left - ins.right;
                int w = (int)((double)barWidth * ((double)PasswordStrengthUI.this.getScore() / 100.0));
                int h = size.height - ins.top - ins.bottom;
                int halfBW = barWidth / 2;
                GradientPaint bg = new GradientPaint(new Point(0, 0), Color.RED, new Point(halfBW, 0), Color.YELLOW);
                g2.setPaint(bg);
                Shape clipShape = g.getClip();
                g2.setClip(ins.left, ins.top, ins.left + w, h);
                g.fillRect(ins.left, ins.top, halfBW, h);
                bg = new GradientPaint(new Point(ins.left + halfBW, 0), Color.YELLOW, new Point(ins.left + barWidth, 0), Color.GREEN);
                g2.setPaint(bg);
                g.fillRect(ins.left + halfBW, ins.top, halfBW * 2, h);
                g.setClip(clipShape);
            }
        }
    }
}

