/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.specify.datamodel.DNASequence;
import edu.ku.brc.ui.GetSetValueIFace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class IllustrativeBarCodeUI
extends JPanel
implements GetSetValueIFace,
UIPluginable {
    protected int[] totals = new int[5];
    protected String sequence = "";

    public IllustrativeBarCodeUI() {
        this.setPreferredSize(new Dimension(700, 100));
    }

    private int getIndex(char code) {
        switch (code) {
            case 'A': {
                return 0;
            }
            case 'G': {
                return 1;
            }
            case 'C': {
                return 2;
            }
            case 'T': {
                return 3;
            }
        }
        return 4;
    }

    private Color getColor(char code) {
        switch (code) {
            case 'A': {
                return Color.GREEN;
            }
            case 'G': {
                return Color.BLACK;
            }
            case 'C': {
                return Color.BLUE;
            }
            case 'T': {
                return Color.RED;
            }
        }
        return Color.WHITE;
    }

    public void setSequence(String sequence) {
        int i = 0;
        while (i < this.totals.length) {
            this.totals[i] = 0;
            ++i;
        }
        this.sequence = sequence;
        if (sequence != null) {
            i = 0;
            while (i < sequence.length()) {
                int n = this.getIndex(sequence.charAt(i));
                this.totals[n] = this.totals[n] + 1;
                ++i;
            }
        }
        this.repaint();
    }

    public int getTotal(char code) {
        return this.totals[this.getIndex(code)];
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 150);
    }

    @Override
    public Dimension getSize() {
        Dimension size = super.getSize();
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        int startX;
        super.paintComponent(g);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getSize();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, size.width, size.height);
        Font font = new Font("Arial", 0, 10);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int txtHeight = fm.getHeight();
        int barHeight = 25;
        int spacing = txtHeight + 4;
        int x = startX = 10;
        int y = spacing;
        int barLength = size.width / 2 - 2 * startX;
        if (this.sequence != null) {
            g.setColor(Color.BLACK);
            g2.drawString("0", x, y - 2);
            int endX = 0;
            int i = 0;
            while (i < this.sequence.length()) {
                char code = this.sequence.charAt(i);
                g2.setColor(this.getColor(code));
                g2.drawLine(x, y, x, y + barHeight);
                x += 2;
                if ((i + 1) % barLength == 0) {
                    g.setColor(Color.BLACK);
                    g2.drawString(Integer.toString(i), x - fm.stringWidth(Integer.toString(i)), y - 2);
                    x = startX;
                    g2.drawString(Integer.toString(i + 1), x, (y += barHeight + spacing) - 2);
                    endX = x + fm.stringWidth(Integer.toString(i + 1));
                }
                ++i;
            }
            g.setColor(Color.BLACK);
            x = Math.max(endX + 6, x - fm.stringWidth(Integer.toString(i)));
            g2.drawString(Integer.toString(i), x, y - 2);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void initialize(Properties properties, boolean isViewMode) {
    }

    @Override
    public boolean isNotEmpty() {
        return false;
    }

    @Override
    public void setCellName(String cellName) {
    }

    @Override
    public void setParent(FormViewObj parent) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value != null) {
            this.setSequence(((DNASequence)value).getGeneSequence());
        }
    }

    @Override
    public boolean canCarryForward() {
        return false;
    }

    @Override
    public String[] getCarryForwardFields() {
        return null;
    }

    @Override
    public String getTitle() {
        return "IllustrativeBarCode";
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"geneSequence"};
    }

    @Override
    public void carryForwardStateChange() {
    }

    @Override
    public void setNewObj(boolean isNewObj) {
    }
}

