/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.SearchTermField;
import edu.ku.brc.af.ui.SearchTermParserIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.DateParser;
import edu.ku.brc.ui.DateWrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ESTermParser
implements SearchTermParserIFace {
    private static final ESTermParser instance = new ESTermParser();
    protected DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    protected static SimpleDateFormat dbDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected List<SearchTermField> fields = new ArrayList<SearchTermField>(5);

    protected ESTermParser() {
    }

    public static ESTermParser getInstance() {
        return instance;
    }

    @Override
    public List<SearchTermField> getFields() {
        return ESTermParser.instance.fields;
    }

    @Override
    public boolean parse(String searchTermArg, boolean parseAsSingleTerm) {
        ESTermParser.instance.fields.clear();
        int currentYear = Calendar.getInstance().get(1);
        String searchTerm = searchTermArg;
        DateParser dd = new DateParser(ESTermParser.instance.scrDateFormat.getSimpleDateFormat().toPattern());
        int cnt = 0;
        if (searchTerm.length() > 0) {
            String[] terms;
            if (StringUtils.contains((String)searchTerm, (char)'\\')) {
                return false;
            }
            boolean startWith = searchTerm.startsWith("*");
            boolean endsWith = searchTerm.endsWith("*");
            if ((searchTerm = StringUtils.remove((String)searchTerm, (char)'*')).startsWith("\"") || searchTerm.startsWith("'") || searchTerm.startsWith("`")) {
                searchTerm = StringUtils.stripStart((String)searchTerm, (String)"\"'`");
                searchTerm = StringUtils.stripEnd((String)searchTerm, (String)"\"'`");
                terms = new String[]{searchTerm};
            } else {
                terms = parseAsSingleTerm ? new String[]{searchTerm} : StringUtils.split((String)searchTerm, (char)' ');
            }
            if (terms.length == 1) {
                terms[0] = String.valueOf(startWith ? "*" : "") + terms[0] + (endsWith ? "*" : "");
            } else {
                terms[0] = String.valueOf(startWith ? "*" : "") + terms[0];
                terms[terms.length - 1] = String.valueOf(terms[terms.length - 1]) + (endsWith ? "*" : "");
            }
            String[] stringArray = terms;
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                String term = stringArray[n2];
                if (!StringUtils.isEmpty((String)term)) {
                    SearchTermField stf = new SearchTermField(term);
                    if (stf.isSingleChar()) {
                        return false;
                    }
                    ESTermParser.instance.fields.add(stf);
                    cnt += !stf.isSingleChar() ? 1 : 0;
                    String termStr = term;
                    if (termStr.startsWith("*")) {
                        stf.setOption(32);
                        termStr = termStr.substring(1);
                        stf.setTerm(termStr);
                    }
                    if (termStr.endsWith("*")) {
                        stf.setOption(64);
                        termStr = termStr.substring(0, termStr.length() - 1);
                        stf.setTerm(termStr);
                    }
                    if (StringUtils.isNumeric((String)termStr)) {
                        int year;
                        stf.setOption(8);
                        if (StringUtils.contains((String)termStr, (char)'.')) {
                            stf.setOption(16);
                        }
                        if (!stf.isOn(16) && termStr.length() == 4 && (year = Integer.parseInt(termStr)) > 1000 && year <= currentYear) {
                            stf.setOption(4);
                        }
                    } else {
                        Date searchDate = dd.parseDate(searchTermArg);
                        if (searchDate != null) {
                            try {
                                termStr = dbDateFormat.format(searchDate);
                                stf.setTerm(termStr);
                                stf.setOption(2);
                            }
                            catch (Exception ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(ESTermParser.class, ex);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return ESTermParser.instance.fields.size() > 0 && cnt > 0;
    }

    @Override
    public String createWhereClause(SearchTermField term, String abbrevArg, String fieldName) {
        String abbrev = StringUtils.isNotEmpty((String)abbrevArg) ? String.valueOf(abbrevArg) + '.' : "";
        boolean startWildCard = term.isOn(32);
        boolean endWildCard = term.isOn(64);
        if (startWildCard || endWildCard) {
            return "LOWER(" + abbrev + fieldName + ") LIKE " + (startWildCard ? "'%" : "'") + term.getTerm() + (endWildCard ? "%'" : "'");
        }
        return "LOWER(" + abbrev + fieldName + ") = " + "'" + term.getTerm() + "'";
    }
}

