/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;

public class BrowseBtnPanel
extends JPanel
implements GetSetValueIFace,
DocumentListener {
    protected JTextField textField;
    protected JButton browseBtn;
    protected boolean isForInput;
    protected boolean useNativeFileDlg = false;
    protected boolean isValidFile = false;
    protected boolean isValidatingFile = false;
    protected FilenameFilter nativeDlgFilter = null;
    protected FileFilter fileFilter = null;
    protected String currentDir = null;

    public BrowseBtnPanel(Object value, int cols, boolean doDirsOnly, boolean isForInput) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.isForInput = isForInput;
        this.createUI(value, cols, doDirsOnly, isForInput);
    }

    public BrowseBtnPanel(JTextField textField, boolean doDirsOnly, boolean isForInput) {
        super(new BorderLayout());
        this.textField = textField;
        this.createUI(null, -1, doDirsOnly, isForInput);
    }

    protected void createUI(Object value, int cols, boolean doDirsOnly, boolean isForInputArg) {
        this.useNativeFileDlg = !doDirsOnly && !this.isForInput;
        UIHelper.setControlSize(this);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("f:p:g, 2dlu, r:p", "p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        if (this.textField == null) {
            this.textField = new ValTextField(value != null ? value.toString() : "", cols);
        }
        panelBuilder.add((Component)this.textField, cc.xy(1, 1));
        this.browseBtn = UIHelper.createButton(UIRegistry.getResourceString("BROWSE"));
        this.browseBtn.addActionListener(new BrowseAction(this.textField, doDirsOnly, isForInputArg));
        panelBuilder.add((Component)this.browseBtn, cc.xy(3, 1));
        this.setOpaque(false);
    }

    public void setUseNativeFileDlg(boolean useNativeFileDlg) {
        this.useNativeFileDlg = useNativeFileDlg;
    }

    public boolean isValidatingFile() {
        return this.isValidatingFile;
    }

    public void setValidatingFile(boolean isValidatingFile) {
        this.isValidatingFile = isValidatingFile;
        if (this.isValidatingFile) {
            this.textField.getDocument().addDocumentListener(this);
        } else {
            this.textField.getDocument().removeDocumentListener(this);
            this.isValidFile = true;
        }
    }

    public boolean isValidFile() {
        return this.isValidFile;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getBrowseBtn() {
        return this.browseBtn;
    }

    public void setNativeDlgFilter(FilenameFilter nativeDlgFilter) {
        this.nativeDlgFilter = nativeDlgFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.browseBtn.setEnabled(enabled);
    }

    protected void verifyForValidFile() {
        String str = this.textField.getText();
        if (StringUtils.isNotEmpty((String)str)) {
            File file = new File(str);
            this.isValidFile = file.exists();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.verifyForValidFile();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.verifyForValidFile();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.verifyForValidFile();
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value instanceof String) {
            String newValue = (String)value;
            String oldValue = this.textField.getText();
            this.textField.setText(newValue);
            this.firePropertyChange("setValue", oldValue, newValue);
        }
        if (value == null) {
            String oldValue = this.textField.getText();
            this.textField.setText(defaultValue);
            this.firePropertyChange("setValue", oldValue, defaultValue);
            this.textField.repaint();
        }
    }

    @Override
    public Object getValue() {
        return this.textField.getText();
    }

    public String getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(String currentDir) {
        this.currentDir = currentDir;
    }

    public class BrowseAction
    implements ActionListener {
        private JTextField txtField;
        private JFileChooser chooser = null;
        private FileDialog fileDlg = null;
        private boolean dirsOnly;
        private boolean isForInputBA;

        public BrowseAction(JTextField textField, boolean dirsOnly, boolean isForInput) {
            this.txtField = textField;
            this.dirsOnly = dirsOnly;
            this.isForInputBA = isForInput;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BrowseBtnPanel.this.useNativeFileDlg) {
                this.fileDlg = this.isForInputBA ? new FileDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("CHOOSE_FILE"), 0) : new FileDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("CHOOSE_FILE"), 1);
                this.fileDlg.setFilenameFilter(BrowseBtnPanel.this.nativeDlgFilter);
                if (BrowseBtnPanel.this.currentDir != null) {
                    this.fileDlg.setDirectory(BrowseBtnPanel.this.currentDir);
                }
                UIHelper.centerAndShow(this.fileDlg);
                if (StringUtils.isNotEmpty((String)this.fileDlg.getFile())) {
                    String filePath = String.valueOf(this.fileDlg.getDirectory()) + this.fileDlg.getFile();
                    BrowseBtnPanel.this.currentDir = this.fileDlg.getDirectory();
                    if (BrowseBtnPanel.this.textField instanceof ValTextField) {
                        ((ValTextField)this.txtField).setValueWithNotification(filePath, "", true);
                    } else {
                        this.txtField.setText(String.valueOf(this.fileDlg.getDirectory()) + this.fileDlg.getFile());
                    }
                    this.txtField.repaint();
                }
            } else {
                int returnVal;
                if (this.chooser == null) {
                    this.chooser = new JFileChooser();
                    this.chooser.setFileSelectionMode(this.dirsOnly ? 1 : 0);
                }
                this.chooser.setFileFilter(BrowseBtnPanel.this.fileFilter);
                if (BrowseBtnPanel.this.currentDir != null) {
                    this.chooser.setCurrentDirectory(new File(BrowseBtnPanel.this.currentDir));
                }
                if ((returnVal = this.isForInputBA ? this.chooser.showOpenDialog(UIRegistry.getTopWindow()) : this.chooser.showSaveDialog(UIRegistry.getTopWindow())) == 0) {
                    BrowseBtnPanel.this.currentDir = this.chooser.getCurrentDirectory().getPath();
                    if (BrowseBtnPanel.this.textField instanceof ValTextField) {
                        ((ValTextField)this.txtField).setValueWithNotification(this.chooser.getSelectedFile().getAbsolutePath(), "", true);
                    } else {
                        this.txtField.setText(this.chooser.getSelectedFile().getAbsolutePath());
                    }
                    this.txtField.repaint();
                }
            }
        }
    }
}

