/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane.formeditor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.tasks.subpane.formeditor.Attr;
import edu.ku.brc.af.tasks.subpane.formeditor.BasicFormPreviewPanel;
import edu.ku.brc.af.tasks.subpane.formeditor.Control;
import edu.ku.brc.af.tasks.subpane.formeditor.ControlIFace;
import edu.ku.brc.af.tasks.subpane.formeditor.EditorPropPanel;
import edu.ku.brc.af.tasks.subpane.formeditor.Param;
import edu.ku.brc.af.tasks.subpane.formeditor.SubControl;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCell;
import edu.ku.brc.af.ui.forms.persist.FormCellField;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellLabel;
import edu.ku.brc.af.ui.forms.persist.FormRow;
import edu.ku.brc.af.ui.forms.persist.FormRowIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.View;
import edu.ku.brc.af.ui.forms.persist.ViewDef;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSet;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpViewSetObj;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ViewSetSelectorPanel
extends JPanel
implements PropertyChangeListener {
    protected JList levelsList;
    protected JList viewSetsList;
    protected JList viewsList;
    protected JList altViewsList;
    protected JList viewDefsList;
    protected ViewSetIFace selectedViewSet = null;
    protected ViewIFace selectedView = null;
    protected ViewDefIFace selectedViewDef = null;
    protected AltViewIFace selectedAltView = null;
    protected FormViewDef formViewDef = null;
    protected FormRow selectedRow = null;
    protected FormCell selectedCell = null;
    protected Vector<Control> controls = null;
    protected Hashtable<String, Control> controlHash = new Hashtable();
    protected Hashtable<String, SubControl> subcontrolHash = new Hashtable();
    protected EditorPropPanel panel;
    protected JTree tree;
    protected Vector<ViewSetIFace> viewSetVector = new Vector();
    protected JButton addBtn;
    protected JButton delBtn;
    protected JButton saveBtn;
    protected Hashtable<String, Boolean> idHash = new Hashtable();
    protected BasicFormPreviewPanel previewPanel;
    protected EditDeleteAddPanel viewControlPanel;
    protected EditDeleteAddPanel altViewControlPanel;
    protected EditDeleteAddPanel viewDefControlPanel;

    public ViewSetSelectorPanel(BasicFormPreviewPanel previewPanel) {
        this.previewPanel = previewPanel;
        Vector<String> levelsVec = new Vector<String>();
        SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        Hashtable usedColTypes = new Hashtable();
        levelsVec.add(user.getUserType());
        levelsVec.add("BackStop");
        this.addBtn = UIHelper.createIconBtn("PlusSign", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ViewSetSelectorPanel.this.addControl();
            }
        });
        this.delBtn = UIHelper.createIconBtn("MinusSign", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ViewSetSelectorPanel.this.delControl(TYPE.SelectedObj);
            }
        });
        ActionListener addViewAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewSetSelectorPanel.this.addView();
            }
        };
        ActionListener delViewAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewSetSelectorPanel.this.delView();
            }
        };
        this.viewControlPanel = new EditDeleteAddPanel(null, delViewAL, addViewAL);
        ActionListener addAltViewAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewSetSelectorPanel.this.addAltView();
            }
        };
        ActionListener delAltViewAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewSetSelectorPanel.this.delAltView();
            }
        };
        this.altViewControlPanel = new EditDeleteAddPanel(null, delAltViewAL, addAltViewAL);
        ActionListener addDefViewAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewSetSelectorPanel.this.addViewDef();
            }
        };
        ActionListener delDefViewAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewSetSelectorPanel.this.delViewDef();
            }
        };
        this.viewDefControlPanel = new EditDeleteAddPanel(null, delDefViewAL, addDefViewAL);
        ActionListener saveAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewSetSelectorPanel.this.save();
            }
        };
        EditDeleteAddPanel saveControlPanel = new EditDeleteAddPanel(null, null, saveAL);
        saveControlPanel.getAddBtn().setIcon(IconManager.getIcon("Save", IconManager.IconSize.Std16));
        saveControlPanel.getAddBtn().setEnabled(true);
        this.setLayout(new BorderLayout());
        this.levelsList = new JList(levelsVec);
        this.panel = new EditorPropPanel(this.controlHash, this.subcontrolHash, null, true, this);
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,4px,p, 6px,10px,6px, p,6px,p, 6px,10px,6px, p,f:p:g", "p,2px,f:p:g,2px,p,10px,p,4px"));
        CellConstraints cc = new CellConstraints();
        String[] labels = new String[]{"User Level", "ViewSets", " ", "Views", "AltViews", " ", "View Defs"};
        int x = 1;
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            pb.add((Component)UIHelper.createLabel(label, 0), cc.xy(x, 1));
            x += 2;
            ++n2;
        }
        Color vsFGColor = new Color(224, 224, 224);
        Color vsBGColor = new Color(124, 124, 124);
        Dimension ps = new Dimension(200, 150);
        x = 1;
        JScrollPane sp = UIHelper.createScrollPane(this.levelsList);
        pb.add((Component)sp, cc.xy(x, 3));
        this.viewSetsList = new JList(new DefaultListModel());
        sp = UIHelper.createScrollPane(this.viewSetsList);
        sp.setPreferredSize(ps);
        pb.add((Component)sp, cc.xy(x += 2, 3));
        pb.add((Component)new VerticalSeparator(vsFGColor, vsBGColor), cc.xy(x += 2, 3));
        this.viewsList = new JList(new DefaultListModel());
        sp = new JScrollPane(this.viewsList, 22, 30);
        sp.setPreferredSize(ps);
        pb.add((Component)sp, cc.xy(x += 2, 3));
        this.altViewsList = new JList(new DefaultListModel());
        sp = UIHelper.createScrollPane(this.altViewsList);
        sp.setPreferredSize(ps);
        pb.add((Component)sp, cc.xy(x += 2, 3));
        pb.add((Component)new VerticalSeparator(vsFGColor, vsBGColor), cc.xy(x += 2, 3));
        this.viewDefsList = new JList(new DefaultListModel());
        sp = UIHelper.createScrollPane(this.viewDefsList);
        sp.setPreferredSize(ps);
        pb.add((Component)sp, cc.xy(x += 2, 3));
        x += 2;
        pb.add((Component)saveControlPanel, cc.xy(1, 5));
        pb.add((Component)this.viewControlPanel, cc.xy(7, 5));
        pb.add((Component)this.altViewControlPanel, cc.xy(9, 5));
        pb.add((Component)this.viewDefControlPanel, cc.xy(13, 5));
        pb.addSeparator("View Def Editor", cc.xywh(1, 7, 13, 1));
        this.add((Component)pb.getPanel(), "North");
        pb = new PanelBuilder(new FormLayout("max(250px;p),4px,f:p:g", "t:p"));
        PanelBuilder inner = new PanelBuilder(new FormLayout("max(250px;p)", "t:p,2px,t:p"));
        this.tree = new JTree();
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
        sp = UIHelper.createScrollPane(this.tree);
        inner.add((Component)sp, cc.xy(1, 1));
        PanelBuilder btnPb = new PanelBuilder(new FormLayout("f:p:g,p,2px,p", "p"));
        btnPb.add((Component)this.delBtn, cc.xy(2, 1));
        btnPb.add((Component)this.addBtn, cc.xy(4, 1));
        inner.add((Component)btnPb.getPanel(), cc.xy(1, 3));
        pb.add((Component)inner.getPanel(), cc.xy(1, 1));
        pb.add((Component)this.panel, cc.xy(3, 1));
        this.add((Component)pb.getPanel(), "Center");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ViewSetSelectorPanel.this.treeSelected();
            }
        });
        this.levelsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewSetSelectorPanel.this.levelSelected();
                }
            }
        });
        this.viewSetsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewSetSelectorPanel.this.viewSetSelected();
                }
            }
        });
        this.viewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewSetSelectorPanel.this.viewSelected();
                }
            }
        });
        this.altViewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewSetSelectorPanel.this.altViewSelected();
                }
            }
        });
        this.viewDefsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewSetSelectorPanel.this.viewDefSelected();
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            protected void doPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int yc;
                    int xc = e.getX();
                    TreePath path = ViewSetSelectorPanel.this.tree.getPathForLocation(xc, yc = e.getY());
                    if (path != null) {
                        ViewSetSelectorPanel.this.tree.setSelectionPath(path);
                    }
                    ViewSetSelectorPanel.this.treeSelected();
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)ViewSetSelectorPanel.this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
                    if (ViewSetSelectorPanel.this.selectedCell != null || ViewSetSelectorPanel.this.selectedRow != null) {
                        new TreePopupMenu((Component)e.getSource(), e, ViewSetSelectorPanel.this.selectedCell);
                    } else if (selectedNode.getUserObject() instanceof FormViewDef) {
                        new TreePopupMenu((Component)e.getSource(), e);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.doPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.doPopup(e);
            }
        });
        XStream xstream = new XStream();
        xstream.alias("control", Control.class);
        xstream.useAttributeFor(Control.class, "type");
        xstream.useAttributeFor(Attr.class, "type");
        xstream.useAttributeFor(Attr.class, "name");
        xstream.useAttributeFor(Attr.class, "required");
        xstream.useAttributeFor(Attr.class, "defaultValue");
        xstream.aliasAttribute("default", "defaultValue");
        xstream.alias("uicontrols", Vector.class);
        xstream.alias("attr", Attr.class);
        xstream.alias("param", Param.class);
        xstream.alias("subcontrol", SubControl.class);
        xstream.aliasAttribute("desc", "desc");
        xstream.aliasAttribute(Attr.class, "values", "values");
        xstream.useAttributeFor(SubControl.class, "type");
        try {
            this.controls = (Vector)xstream.fromXML(FileUtils.readFileToString((File)new File("UIControls.xml")));
            for (Control control : this.controls) {
                this.controlHash.put(control.getType(), control);
                if (control.getSubcontrols() == null) continue;
                for (SubControl sc : control.getSubcontrols()) {
                    this.subcontrolHash.put(sc.getType(), sc);
                }
            }
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ViewSetSelectorPanel.class, ex);
            ex.printStackTrace();
        }
    }

    protected FormViewDef getViewDefFromSelection() {
        if (this.tree != null && this.tree.getSelectionModel() != null && this.tree.getSelectionModel().getSelectionPath() != null) {
            TreePath path = this.tree.getSelectionModel().getSelectionPath();
            int i = 0;
            while (i < path.getPathCount()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(i);
                if (node.getUserObject() instanceof FormViewDef) {
                    return (FormViewDef)node.getUserObject();
                }
                ++i;
            }
        }
        return null;
    }

    protected void updateUIControls() {
        this.addBtn.setEnabled(false);
        this.delBtn.setEnabled(false);
        if (this.tree.getSelectionModel().getSelectionPath() != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
            Object nodeObj = node.getUserObject();
            if (nodeObj instanceof FormRow) {
                this.addBtn.setEnabled(true);
                this.delBtn.setEnabled(true);
            } else if (nodeObj instanceof FormViewDef) {
                this.addBtn.setEnabled(true);
                this.delBtn.setEnabled(true);
            } else if (nodeObj instanceof FormCell) {
                this.addBtn.setEnabled(true);
                this.delBtn.setEnabled(true);
            }
        }
    }

    protected void addControl() {
        if (this.selectedCell != null) {
            this.addControlTo(this.selectedCell);
        } else if (this.selectedRow != null) {
            this.addControlTo(null);
        } else {
            this.addRow();
        }
    }

    protected List<ControlIFace> getControlsList(boolean addRow) {
        Vector<ControlIFace> list = new Vector<ControlIFace>();
        for (Control c : this.controls) {
            list.add(c);
            if (c.getSubcontrols() == null || c.getSubcontrols().size() <= 0) continue;
            for (SubControl sc : c.getSubcontrols()) {
                list.add(sc);
            }
        }
        return list;
    }

    protected void addControlTo(FormCell selectedCellArg) {
        List<ControlIFace> list = this.getControlsList(true);
        ToggleButtonChooserDlg<ControlIFace> dlg = new ToggleButtonChooserDlg<ControlIFace>((Frame)UIRegistry.getTopWindow(), "ViewSetSelectorPanel.CHOOSE_A_CONTROL", list, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.addControl(dlg.getSelectedObject(), selectedCellArg);
        }
    }

    protected void setDefaultDspUIType(FormCellField fcf) {
        FormCellFieldIFace.FieldType dspUiType = null;
        FormCellFieldIFace.FieldType uitype = fcf.getUiType();
        switch (uitype) {
            case textarea: {
                dspUiType = FormCellFieldIFace.FieldType.dsptextarea;
                break;
            }
            case querycbx: {
                dspUiType = FormCellFieldIFace.FieldType.textfieldinfo;
                break;
            }
            case formattedtext: {
                dspUiType = FormCellFieldIFace.FieldType.formattedtext;
                break;
            }
            case image: 
            case url: 
            case checkbox: 
            case tristate: 
            case password: 
            case list: 
            case button: 
            case plugin: {
                dspUiType = uitype;
                break;
            }
            case combobox: 
            case spinner: {
                dspUiType = FormCellFieldIFace.FieldType.dsptextfield;
                break;
            }
            default: {
                dspUiType = FormCellFieldIFace.FieldType.dsptextfield;
            }
        }
        fcf.setDspUIType(dspUiType);
    }

    protected void updateTreeNodes(DefaultMutableTreeNode parentNode, DefaultTreeModel model, boolean updateChildren) {
        model.nodeChanged(parentNode);
        if (updateChildren) {
            int i = 0;
            while (i < parentNode.getChildCount()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                this.updateTreeNodes(node, model, true);
                ++i;
            }
        }
    }

    protected void renumberRows(Vector<FormRowIFace> rows) {
        byte num = 0;
        for (FormRowIFace row : this.formViewDef.getRows()) {
            row.setRowNumber(num);
            num = (byte)(num + 1);
        }
    }

    protected void addRow() {
        int position;
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        FormRow newRow = new FormRow();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newRow);
        newNode.setUserObject(newRow);
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
        if (parentNode == null) {
            parentNode = (DefaultMutableTreeNode)model.getRoot();
            selectedNode = null;
        }
        if (this.selectedRow == null || parentNode.getUserObject() instanceof String) {
            this.formViewDef.getRows().add(newRow);
            position = this.formViewDef.getRows().size() - 1;
        } else {
            position = this.formViewDef.getRows().indexOf(this.selectedRow);
            this.formViewDef.getRows().insertElementAt(newRow, (byte)position);
        }
        model.insertNodeInto(newNode, parentNode, position);
        this.renumberRows(this.formViewDef.getRows());
        this.updateTreeNodes((DefaultMutableTreeNode)model.getRoot(), model, false);
        Object[] newPath = new Object[]{parentNode, newNode};
        final TreePath newTreePath = new TreePath(newPath);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewSetSelectorPanel.this.tree.setSelectionPath(newTreePath);
            }
        });
        this.previewPanel.rebuild(false);
    }

    protected void addControl(ControlIFace selectedControl, FormCell selectedCell) {
        int position = 0;
        if (selectedCell != null) {
            position = this.selectedRow.getCells().indexOf(selectedCell);
        }
        if (selectedControl instanceof RowControl) {
            this.addRow();
            return;
        }
        EditorPropPanel panel = new EditorPropPanel(this.controlHash, this.subcontrolHash, this.getAvailableFieldCells(), false, this);
        FormCell formCell = null;
        boolean skip = false;
        if (selectedControl instanceof Control) {
            Control control = (Control)selectedControl;
            if (control.getType().equals("label")) {
                formCell = new FormCellLabel();
                formCell.setIdent(Integer.toString(this.getNextId()));
            }
            if (formCell != null) {
                formCell.setType(FormCellIFace.CellType.valueOf(control.getType()));
                panel.loadView(formCell.getType().toString(), this.selectedViewDef.getClassName());
                panel.setDataIntoUI(this.formViewDef, formCell, this.formViewDef.getRows().size() * 2 - 1, this.formViewDef.getRowDefItem().getNumItems(), (int)this.selectedRow.getRowNumber(), this.selectedRow.getCells().size() * 2 - 1, this.formViewDef.getColumnDefItem().getNumItems(), position);
            }
        } else {
            SubControl subControl = (SubControl)selectedControl;
            FormCellField fcf = null;
            if (subControl.getType().equals("combobox")) {
                fcf = new FormCellField(FormCellIFace.CellType.field, Integer.toString(this.getNextId()), "", 1, 1);
                fcf.setUiType(FormCellFieldIFace.FieldType.combobox);
                this.setDefaultDspUIType(fcf);
                formCell = fcf;
            }
            panel.loadView(fcf.getUiType().toString(), this.selectedViewDef.getClassName());
            panel.setDataIntoUI(this.formViewDef, fcf, this.formViewDef.getRows().size() * 2 - 1, this.formViewDef.getRowDefItem().getNumItems(), (int)this.selectedRow.getRowNumber(), this.selectedRow.getCells().size() * 2 - 1, this.formViewDef.getColumnDefItem().getNumItems(), position);
        }
        if (!skip && formCell != null) {
            CustomDialog propDlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ViewSetSelectorPanel.CREATE"), true, panel);
            propDlg.createUI();
            propDlg.pack();
            Rectangle r = propDlg.getBounds();
            r.width += 60;
            r.height += 30;
            propDlg.setBounds(r);
            propDlg.setVisible(true);
            if (!propDlg.isCancelled()) {
                if (selectedControl instanceof Control) {
                    panel.getDataFromUI(formCell);
                } else {
                    panel.getDataFromUI((FormCellField)formCell);
                }
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(formCell);
                newNode.setUserObject(formCell);
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
                if (!(parentNode.getUserObject() instanceof FormRow)) {
                    parentNode = (DefaultMutableTreeNode)parentNode.getParent();
                }
                TreePath treePath = this.tree.getSelectionModel().getSelectionPath();
                Object[] path = treePath.getPath();
                Object[] newPath = new Object[path.length + (selectedCell == null ? 1 : 0)];
                int i = 0;
                while (i < path.length) {
                    newPath[i] = path[i];
                    ++i;
                }
                newPath[newPath.length - 1] = newNode;
                if (this.selectedRow.getCells().size() == 0) {
                    this.selectedRow.getCells().add(formCell);
                    ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(newNode, parentNode, 0);
                } else if (position == this.selectedRow.getCells().size() - 1) {
                    this.selectedRow.getCells().add(formCell);
                    ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(newNode, parentNode, position + 1);
                } else {
                    this.selectedRow.getCells().insertElementAt(formCell, position + 1);
                    ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(newNode, parentNode, position + 1);
                }
                this.idHash.put(formCell.getIdent(), true);
                final TreePath newTreePath = new TreePath(newPath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewSetSelectorPanel.this.tree.setSelectionPath(newTreePath);
                    }
                });
                this.previewPanel.rebuild(false);
            }
        }
    }

    protected void delControl(TYPE type) {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
        Object formObj = selectedNode.getUserObject();
        if (type == TYPE.DelRow && formObj instanceof FormCell) {
            selectedNode = parentNode;
            parentNode = (DefaultMutableTreeNode)parentNode.getParent();
            formObj = selectedNode.getUserObject();
        }
        if (formObj instanceof FormRow) {
            FormRow row = (FormRow)formObj;
            ((FormViewDef)parentNode.getUserObject()).getRows().remove(row);
            for (FormCellIFace formCell : row.getCells()) {
                this.idHash.remove(formCell.getIdent());
            }
        } else if (formObj instanceof FormCell) {
            FormCell formCell = (FormCell)formObj;
            ((FormRow)parentNode.getUserObject()).getCells().remove(formCell);
            this.idHash.remove(formCell.getIdent());
        }
        this.renumberRows(this.formViewDef.getRows());
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.removeNodeFromParent(selectedNode);
    }

    protected void buildIdHash(FormViewDef fvd) {
        this.idHash.clear();
        for (FormRowIFace row : fvd.getRows()) {
            for (FormCellIFace cell : row.getCells()) {
                this.idHash.put(cell.getIdent(), true);
            }
        }
    }

    protected int getNextId() {
        int id = 1;
        while (this.idHash.get(Integer.toString(id)) != null) {
            ++id;
        }
        return id;
    }

    protected Vector<FormCellLabel> getAvailableLabels() {
        Vector<FormCellLabel> list = new Vector<FormCellLabel>();
        Hashtable<String, FormCellLabel> labelHash = new Hashtable<String, FormCellLabel>();
        for (FormRowIFace row : this.formViewDef.getRows()) {
            for (FormCellIFace cell : row.getCells()) {
                if (!(cell instanceof FormCellLabel)) continue;
                labelHash.put(cell.getIdent(), (FormCellLabel)cell);
            }
        }
        for (FormRowIFace row : this.formViewDef.getRows()) {
            for (FormCellIFace cell : row.getCells()) {
                FormCellField fcf;
                FormCellLabel label;
                if (!(cell instanceof FormCellField) || (label = (FormCellLabel)labelHash.get((fcf = (FormCellField)cell).getIdent())) == null) continue;
                labelHash.remove(label.getIdent());
            }
        }
        list.addAll(labelHash.values());
        return list;
    }

    protected Vector<FormCellField> getAvailableFieldCells() {
        Vector<FormCellField> list = new Vector<FormCellField>();
        Hashtable<String, FormCellLabel> labelForHash = new Hashtable<String, FormCellLabel>();
        for (FormRowIFace row : this.formViewDef.getRows()) {
            for (FormCellIFace cell : row.getCells()) {
                FormCellLabel fcl;
                if (!(cell instanceof FormCellLabel) || !StringUtils.isNotEmpty((String)(fcl = (FormCellLabel)cell).getLabelFor())) continue;
                labelForHash.put(fcl.getLabelFor(), (FormCellLabel)cell);
            }
        }
        for (FormRowIFace row : this.formViewDef.getRows()) {
            for (FormCellIFace cell : row.getCells()) {
                FormCellField fcf;
                FormCellLabel label;
                if (!(cell instanceof FormCellField) || (label = (FormCellLabel)labelForHash.get((fcf = (FormCellField)cell).getIdent())) != null) continue;
                list.add(fcf);
            }
        }
        return list;
    }

    protected void treeSelected() {
        TreePath treePath = this.tree.getSelectionModel().getSelectionPath();
        if (treePath == null) {
            this.selectedRow = null;
            this.selectedCell = null;
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof FormRow) {
            if (nodeObj == this.selectedRow) {
                return;
            }
            this.selectedRow = (FormRow)nodeObj;
            this.selectedCell = null;
        } else if (nodeObj instanceof FormCell) {
            if (nodeObj == this.selectedCell) {
                return;
            }
            this.selectedCell = (FormCell)nodeObj;
            DefaultMutableTreeNode rowNode = (DefaultMutableTreeNode)node.getParent();
            this.selectedRow = (FormRow)rowNode.getUserObject();
        } else {
            this.selectedRow = null;
            this.selectedCell = null;
        }
        if (treePath != null) {
            this.updateUIControls();
            if (treePath.getPathCount() == 1) {
                this.panel.loadView("ViewDefProps", null);
                this.panel.setData(this.selectedViewDef);
                return;
            }
            if (this.selectedCell != null) {
                int col = 0;
                for (FormCellIFace fc : this.selectedRow.getCells()) {
                    if (fc == nodeObj) break;
                    ++col;
                }
                this.showPropertiesPanel((FormCell)nodeObj, this.formViewDef.getClassName(), this.formViewDef.getRows().size() * 2 - 1, this.formViewDef.getRowDefItem().getNumItems(), this.selectedRow.getRowNumber(), this.selectedRow.getCells().size() * 2 - 1, this.formViewDef.getColumnDefItem().getNumItems(), col);
            }
        }
    }

    protected void showPropertiesPanel(FormCell formCell, String dataClassName, int rows, int rowDefs, int rowInx, int cols, int colDefs, int colInx) {
        if (formCell instanceof FormCellField) {
            FormCellField fcf = (FormCellField)formCell;
            this.panel.loadView(fcf.getUiType().toString(), dataClassName);
            this.panel.setDataIntoUI(this.formViewDef, fcf, rows, rowDefs, rowInx, cols, colDefs, colInx);
        } else {
            if (formCell instanceof FormCellLabel) {
                this.panel.setFieldsNotUsedByLabels(this.getAvailableFieldCells());
            }
            this.panel.loadView(formCell.getType().toString(), dataClassName);
            this.panel.setDataIntoUI(this.formViewDef, formCell, rows, rowDefs, rowInx, cols, colDefs, colInx);
        }
    }

    protected void levelSelected() {
        this.selectedViewSet = null;
        this.selectedView = null;
        this.selectedViewDef = null;
        this.selectedAltView = null;
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
        DefaultListModel model = (DefaultListModel)this.viewsList.getModel();
        model.clear();
        model = (DefaultListModel)this.altViewsList.getModel();
        model.clear();
        model = (DefaultListModel)this.viewSetsList.getModel();
        model.clear();
        this.viewSetVector.clear();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        for (SpAppResourceDir dir : ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getSpAppResourceList()) {
            if (dir.getSpAppResourceDirId() != null) {
                session.attach(dir);
            }
            for (SpViewSetObj vso : dir.getSpViewSets()) {
                try {
                    Element root = XMLHelper.readStrToDOM4J(vso.getDataAsString());
                    ViewSet viewSet = new ViewSet(root, false);
                    this.viewSetVector.add(viewSet);
                    model.addElement(viewSet.getName());
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ViewSetSelectorPanel.class, ex);
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
        }
        session.close();
    }

    protected void viewSetSelected() {
        this.selectedViewSet = null;
        this.selectedView = null;
        this.selectedViewDef = null;
        this.selectedAltView = null;
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
        DefaultListModel model = (DefaultListModel)this.altViewsList.getModel();
        model.clear();
        model = (DefaultListModel)this.viewDefsList.getModel();
        model.clear();
        model = (DefaultListModel)this.viewsList.getModel();
        model.clear();
        int inx = this.viewSetsList.getSelectedIndex();
        if (inx > -1) {
            this.selectedViewSet = (ViewSet)this.viewSetVector.get(inx);
            this.viewControlPanel.getAddBtn().setEnabled(true);
            this.viewDefControlPanel.getAddBtn().setEnabled(true);
            Vector<String> names = new Vector<String>(this.selectedViewSet.getViews().keySet());
            Collections.sort(names);
            for (String viewName : names) {
                model.addElement(viewName);
            }
            model = (DefaultListModel)this.viewDefsList.getModel();
            names.clear();
            names.addAll(this.selectedViewSet.getViewDefs().keySet());
            Collections.sort(names);
            for (String viewDefName : names) {
                model.addElement(viewDefName);
            }
        } else {
            this.viewControlPanel.getAddBtn().setEnabled(false);
            this.viewDefControlPanel.getAddBtn().setEnabled(false);
        }
    }

    protected void viewSelected() {
        this.selectedView = null;
        this.selectedViewDef = null;
        this.selectedAltView = null;
        this.viewDefsList.clearSelection();
        DefaultListModel model = (DefaultListModel)this.altViewsList.getModel();
        model.clear();
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
        if (this.viewsList.getSelectedIndex() > -1) {
            if (this.selectedViewSet != null) {
                String viewName = (String)this.viewsList.getSelectedValue();
                if (viewName != null) {
                    this.selectedView = this.selectedViewSet.getViews().get(viewName);
                    for (AltViewIFace altView : this.selectedView.getAltViews()) {
                        model.addElement(altView.getName());
                    }
                }
                this.altViewControlPanel.getAddBtn().setEnabled(true);
                this.viewControlPanel.getDelBtn().setEnabled(true);
            }
        } else {
            this.altViewControlPanel.getAddBtn().setEnabled(false);
            this.viewControlPanel.getDelBtn().setEnabled(false);
        }
    }

    protected void viewDefSelected(ViewIFace view, ViewDefIFace viewDef, AltViewIFace.CreationMode mode) {
        if (viewDef instanceof FormViewDef) {
            this.selectedViewDef = viewDef;
            if (this.selectedViewDef instanceof FormViewDef) {
                this.formViewDef = (FormViewDef)viewDef;
                this.buildIdHash(this.formViewDef);
            }
        }
        for (AltViewIFace av : view.getAltViews()) {
            if (av.getViewDef() != viewDef || mode != av.getMode()) continue;
            this.selectedAltView = av;
            break;
        }
        this.buildTreeModel(viewDef);
        int i = 0;
        while (i < this.tree.getRowCount()) {
            this.tree.expandRow(i);
            ++i;
        }
        this.tree.repaint();
        this.previewPanel.set((View)view);
        this.previewPanel.setFormViewDef((ViewDef)viewDef);
        this.previewPanel.rebuild(mode == AltViewIFace.CreationMode.EDIT);
        this.panel.loadView("ViewDefProps", null);
        this.panel.setData(this.selectedViewDef);
        this.validate();
        this.repaint();
    }

    protected void altViewSelected() {
        this.selectedAltView = null;
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
        String altViewName = (String)this.altViewsList.getSelectedValue();
        if (altViewName != null) {
            this.selectedAltView = this.selectedView.getAltView(altViewName);
            this.viewDefSelected(this.selectedView, this.selectedAltView.getViewDef(), this.selectedAltView.getMode());
            this.panel.loadView("AltViewProps", null);
            this.panel.setData(this.selectedAltView);
            this.validate();
            this.repaint();
        }
    }

    protected void viewDefSelected() {
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
        String viewDefName = (String)this.viewDefsList.getSelectedValue();
        if (viewDefName != null) {
            this.selectedView = null;
            this.selectedAltView = null;
            this.viewsList.clearSelection();
            this.selectedViewDef = this.selectedViewSet.getViewDefs().get(viewDefName);
            if (this.selectedViewDef != null) {
                ViewIFace view = this.selectedView;
                if (view == null || !view.getClassName().equals(this.selectedViewDef.getClassName())) {
                    view = null;
                    for (ViewIFace v : this.selectedViewSet.getViews().values()) {
                        if (!v.getClassName().equals(this.selectedViewDef.getClassName())) continue;
                        view = v;
                        break;
                    }
                }
                if (view != null) {
                    this.viewDefSelected(view, this.selectedViewDef, AltViewIFace.CreationMode.EDIT);
                }
            }
            this.viewDefControlPanel.getDelBtn().setEnabled(true);
        } else {
            this.viewDefControlPanel.getDelBtn().setEnabled(false);
        }
    }

    protected void buildTreeModel(Vector<ViewDefIFace> viewDefs) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ViewDefs");
        model.setRoot(root);
        for (ViewDefIFace vd : viewDefs) {
            DefaultMutableTreeNode vdNode = new DefaultMutableTreeNode(vd.getName());
            vdNode.setUserObject(vd);
            if (!(vd instanceof FormViewDef)) continue;
            root.add(vdNode);
            FormViewDef fvd = (FormViewDef)vd;
            for (FormRowIFace r : fvd.getRows()) {
                FormRow row = (FormRow)r;
                DefaultMutableTreeNode rowNode = new DefaultMutableTreeNode(row.getRowNumber());
                rowNode.setUserObject(row);
                vdNode.add(rowNode);
                for (FormCellIFace c : row.getCells()) {
                    FormCell cell = (FormCell)c;
                    DefaultMutableTreeNode cellNode = new DefaultMutableTreeNode(cell.toString());
                    cellNode.setUserObject(cell);
                    rowNode.add(cellNode);
                }
            }
        }
        model.nodeStructureChanged(root);
    }

    protected void buildTreeModel(ViewDefIFace viewDef) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode vdNode = new DefaultMutableTreeNode(viewDef.getName());
        vdNode.setUserObject(viewDef);
        model.setRoot(vdNode);
        if (viewDef instanceof FormViewDef) {
            FormViewDef fvd = (FormViewDef)viewDef;
            for (FormRowIFace r : fvd.getRows()) {
                FormRow row = (FormRow)r;
                DefaultMutableTreeNode rowNode = new DefaultMutableTreeNode(row.getRowNumber());
                rowNode.setUserObject(row);
                vdNode.add(rowNode);
                for (FormCellIFace c : row.getCells()) {
                    FormCell cell = (FormCell)c;
                    DefaultMutableTreeNode cellNode = new DefaultMutableTreeNode(cell.toString());
                    cellNode.setUserObject(cell);
                    rowNode.add(cellNode);
                }
            }
        }
        model.nodeStructureChanged(vdNode);
    }

    protected void addView() {
    }

    protected void delView() {
    }

    protected void addAltView() {
    }

    protected void delAltView() {
    }

    protected void addViewDef() {
        List<ControlIFace> list = this.getControlsList(true);
        ToggleButtonChooserDlg<ControlIFace> dlg = new ToggleButtonChooserDlg<ControlIFace>((Frame)UIRegistry.getTopWindow(), "ViewSetSelectorPanel.CHOOSE_A_CONTROL", list, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.addControl(dlg.getSelectedObject(), this.selectedCell);
        }
    }

    protected void delViewDef() {
    }

    protected void save() {
        if (this.selectedViewSet != null) {
            File file = new File("viewset.xml");
            StringBuilder sb = new StringBuilder();
            this.selectedViewSet.toXML(sb);
            try {
                FileUtils.writeStringToFile((File)file, (String)sb.toString());
                Element root = XMLHelper.readFileToDOM4J(file);
                ViewSet vs = new ViewSet(root, false);
                for (ViewDefIFace viewDef : vs.getViewDefs().values()) {
                    if (!(viewDef instanceof FormViewDef)) continue;
                    FormViewDef fvd = (FormViewDef)viewDef;
                    System.out.println(String.valueOf(viewDef.getName()) + " " + fvd.getRows().size());
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ViewSetSelectorPanel.class, ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.nodeChanged((TreeNode)model.getRoot());
        this.previewPanel.rebuild(this.selectedAltView.getMode() == AltViewIFace.CreationMode.EDIT);
    }

    class MenuActionListener
    implements ActionListener {
        protected FormCell formCell;
        protected Object data;
        protected TYPE type;

        public MenuActionListener(TYPE type) {
            this.formCell = null;
            this.data = null;
            this.type = type;
        }

        public MenuActionListener(FormCell formCell, Object data) {
            this.formCell = formCell;
            this.data = data;
            this.type = TYPE.AddControl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.type == TYPE.AddRow) {
                ViewSetSelectorPanel.this.addRow();
            } else if (this.type == TYPE.DelRow || this.type == TYPE.DelControl) {
                ViewSetSelectorPanel.this.delControl(this.type);
            } else if (this.data instanceof Control) {
                ViewSetSelectorPanel.this.addControl((Control)this.data, this.formCell);
            } else if (this.data instanceof SubControl) {
                ViewSetSelectorPanel.this.addControl((SubControl)this.data, this.formCell);
            } else if (this.data instanceof RowControl) {
                ViewSetSelectorPanel.this.addRow();
            }
        }

        public TYPE getType() {
            return this.type;
        }
    }

    class RowControl
    implements ControlIFace {
        RowControl() {
        }

        @Override
        public String getDesc() {
            return "A Form Row";
        }

        @Override
        public String getType() {
            return "Row";
        }

        public String toString() {
            return "New Row";
        }
    }

    public static enum TYPE {
        SelectedObj,
        AddControl,
        DelControl,
        AddRow,
        DelRow;

    }

    public class TreePopupMenu
    extends MouseAdapter {
        private JPopupMenu menu = new JPopupMenu();

        public TreePopupMenu(Component src, MouseEvent e, FormCell formCell) {
            boolean isOnCell = ViewSetSelectorPanel.this.selectedCell != null;
            JMenuItem menuItem = new JMenuItem("Add Row");
            menuItem.addActionListener(new MenuActionListener(TYPE.AddRow));
            this.menu.add(menuItem);
            menuItem = new JMenuItem("Delete Row");
            menuItem.addActionListener(new MenuActionListener(TYPE.DelRow));
            this.menu.add(menuItem);
            JMenu addMenu = new JMenu("Add Control");
            this.menu.add(addMenu);
            for (ControlIFace control : ViewSetSelectorPanel.this.getControlsList(true)) {
                menuItem = new JMenuItem(control.toString());
                menuItem.addActionListener(new MenuActionListener(formCell, control));
                addMenu.add(menuItem);
            }
            if (isOnCell) {
                menuItem = new JMenuItem("Delete Control");
                menuItem.addActionListener(new MenuActionListener(TYPE.DelControl));
                this.menu.add(menuItem);
            }
            this.menu.show(src, e.getX(), e.getY());
        }

        public TreePopupMenu(Component src, MouseEvent e) {
            JMenuItem menuItem = new JMenuItem("Add Row");
            this.menu.add(menuItem);
            menuItem.addActionListener(new MenuActionListener(TYPE.AddRow));
            this.menu.show(src, e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.displayMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.displayMenu(e);
        }

        private void displayMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

