/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane.formeditor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.tasks.subpane.formeditor.DefItemPropPanel;
import edu.ku.brc.af.tasks.subpane.formeditor.DefItemRenderer;
import edu.ku.brc.af.tasks.subpane.formeditor.JGoodiesDefItem;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public class RowColDefPanel
extends JPanel {
    protected JGoodiesDefItem.MINMAX_TYPE[] minMax = new JGoodiesDefItem.MINMAX_TYPE[]{JGoodiesDefItem.MINMAX_TYPE.None, JGoodiesDefItem.MINMAX_TYPE.Min, JGoodiesDefItem.MINMAX_TYPE.Max};
    protected JGoodiesDefItem.ALIGN_TYPE[] rowAlign = new JGoodiesDefItem.ALIGN_TYPE[]{JGoodiesDefItem.ALIGN_TYPE.None, JGoodiesDefItem.ALIGN_TYPE.Top, JGoodiesDefItem.ALIGN_TYPE.Bottom};
    protected JGoodiesDefItem.ALIGN_TYPE[] colAlign = new JGoodiesDefItem.ALIGN_TYPE[]{JGoodiesDefItem.ALIGN_TYPE.None, JGoodiesDefItem.ALIGN_TYPE.Left, JGoodiesDefItem.ALIGN_TYPE.Right};
    protected String def;
    protected boolean isRow;
    protected Vector<JGoodiesDefItem> items = new Vector();
    protected JList itemList;
    protected JGoodiesDefItem currentItem = null;
    protected DefItemPropPanel propsPanel;
    protected EditDeleteAddPanel controlPanel;

    public RowColDefPanel(FormViewDef.JGDefItem item, int numInUse, boolean isRow) {
        super(new BorderLayout());
        this.isRow = isRow;
        this.createUI(numInUse, isRow);
        DefaultListModel model = (DefaultListModel)this.itemList.getModel();
        int cnt = 0;
        String[] stringArray = StringUtils.split((String)item.getDefStr(), (String)",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            JGoodiesDefItem jgItem = new JGoodiesDefItem(tok, isRow);
            jgItem.setInUse(cnt < numInUse);
            this.items.add(jgItem);
            model.addElement(jgItem);
            ++cnt;
            ++n2;
        }
    }

    protected void createUI(int numInUse, boolean isRow) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("max(125px;p):g,16px,p", "p,2px,p,2px,p:g"));
        this.propsPanel = new DefItemPropPanel(numInUse, isRow);
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowColDefPanel.this.addItem();
            }
        };
        ActionListener delAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowColDefPanel.this.delItem();
            }
        };
        this.controlPanel = new EditDeleteAddPanel(null, delAL, addAL);
        this.controlPanel.getAddBtn().setEnabled(true);
        this.itemList = new JList(new DefaultListModel());
        this.itemList.setCellRenderer(new DefItemRenderer(IconManager.IconSize.Std16));
        JScrollPane sp = UIHelper.createScrollPane(this.itemList);
        pb.addSeparator(String.valueOf(isRow ? "Row" : "Column") + " Items", cc.xy(1, 1));
        pb.add((Component)sp, cc.xy(1, 3));
        pb.add((Component)this.controlPanel, cc.xy(1, 5));
        pb.addSeparator("Properties", cc.xy(3, 1));
        pb.add((Component)this.propsPanel, cc.xywh(3, 3, 1, 3));
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    RowColDefPanel.this.itemSelected();
                }
            }
        });
        this.add((Component)pb.getPanel(), "Center");
    }

    public void addItem() {
        DefaultListModel model = (DefaultListModel)this.itemList.getModel();
        JGoodiesDefItem item = new JGoodiesDefItem("p", this.isRow);
        item.setInUse(false);
        this.items.add(item);
        model.addElement(item);
    }

    public void delItem() {
        if (!this.currentItem.isInUse()) {
            DefaultListModel model = (DefaultListModel)this.itemList.getModel();
            this.items.remove(this.currentItem);
            model.removeElement(this.currentItem);
        }
    }

    protected void itemSelected() {
        this.currentItem = (JGoodiesDefItem)this.itemList.getSelectedValue();
        if (this.currentItem != null) {
            this.propsPanel.getDataFromUI();
            this.controlPanel.getDelBtn().setEnabled(!this.currentItem.isInUse());
        }
        this.propsPanel.setCurrentItem(this.currentItem);
    }

    public String getDefStr() {
        StringBuilder sb = new StringBuilder();
        for (JGoodiesDefItem item : this.items) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(item.toString());
        }
        return sb.toString();
    }

    public void getDataFromUI() {
        this.propsPanel.getDataFromUI();
    }
}

