/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane.formeditor;

import org.apache.commons.lang.StringUtils;

public class JGoodiesDefItem {
    private String[] prefixes = new String[]{"f", "fill", "l", "left", "r", "right", "c", "center", "t", "top", "b", "bottom"};
    private ALIGN_TYPE[] prefixeVals = new ALIGN_TYPE[]{ALIGN_TYPE.Fill, ALIGN_TYPE.Fill, ALIGN_TYPE.Left, ALIGN_TYPE.Left, ALIGN_TYPE.Right, ALIGN_TYPE.Right, ALIGN_TYPE.Center, ALIGN_TYPE.Center, ALIGN_TYPE.Top, ALIGN_TYPE.Top, ALIGN_TYPE.Bottom, ALIGN_TYPE.Bottom};
    protected MINMAX_TYPE minMax = MINMAX_TYPE.None;
    protected int len = -1;
    protected SIZE_TYPE type = SIZE_TYPE.Pixels;
    protected boolean isGrow;
    protected ALIGN_TYPE align = ALIGN_TYPE.None;
    protected boolean isPreferredSize = true;
    protected boolean isInUse;

    public JGoodiesDefItem() {
    }

    public JGoodiesDefItem(String defArg, boolean isRow) {
        this.parse(defArg, isRow);
    }

    public void parse(String defArg, boolean isRow) {
        String def = defArg;
        def = StringUtils.isEmpty((String)def) ? "p" : defArg.toLowerCase();
        if (def.startsWith("min")) {
            this.minMax = MINMAX_TYPE.Min;
            this.parseMinMax(def);
        } else if (def.startsWith("max")) {
            this.minMax = MINMAX_TYPE.Max;
            this.parseMinMax(def);
        } else {
            String adjustedDef = def;
            int inx = 0;
            String[] stringArray = this.prefixes;
            int n = this.prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String pfx = stringArray[n2];
                if (def.startsWith(pfx)) {
                    adjustedDef = def.substring(pfx.length() + 1, def.length());
                    this.align = this.prefixeVals[inx];
                    break;
                }
                ++inx;
                ++n2;
            }
            if (StringUtils.isNumeric((String)adjustedDef.substring(0, 1))) {
                this.parseNum(adjustedDef);
                this.isPreferredSize = false;
            } else {
                this.isPreferredSize = true;
            }
        }
        this.isGrow = def.endsWith(":g") || def.endsWith(":grow");
    }

    protected void parseNum(String def) {
        int inx = def.indexOf("px");
        if (inx > -1) {
            this.len = Integer.parseInt(def.substring(0, inx));
            this.type = SIZE_TYPE.Pixels;
        } else {
            inx = def.indexOf("dlu");
            if (inx > -1) {
                this.len = Integer.parseInt(def.substring(0, inx));
                this.type = SIZE_TYPE.Dlus;
            } else {
                throw new RuntimeException("Can't parse [" + def + "]");
            }
        }
    }

    protected void parseMinMax(String def) {
        String[] toks = StringUtils.split((String)def, (String)"();");
        this.parseNum(toks[1]);
    }

    public void parseAlign(String def, boolean isRow) {
        int inx = def.indexOf(58);
        if (inx > -1) {
            String val = def.substring(0, inx);
            this.align = val.equals("f") || val.equals("fill") ? ALIGN_TYPE.Fill : (isRow ? (val.equals("t") || val.equals("top") ? ALIGN_TYPE.Top : (val.equals("c") || val.equals("center") ? ALIGN_TYPE.Center : (val.equals("b") || val.equals("bottom") ? ALIGN_TYPE.Bottom : ALIGN_TYPE.None))) : (val.equals("l") || val.equals("left") ? ALIGN_TYPE.Left : (val.equals("c") || val.equals("center") ? ALIGN_TYPE.Center : (val.equals("r") || val.equals("right") ? ALIGN_TYPE.Right : ALIGN_TYPE.None))));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAlignStr(this.align));
        if (this.len == -1) {
            sb.append("p");
        } else if (this.minMax != MINMAX_TYPE.None) {
            sb.append(this.minMax == MINMAX_TYPE.Min ? "min(" : "max(");
            sb.append(this.len);
            sb.append(this.type == SIZE_TYPE.Pixels ? "px" : "dlu");
            sb.append(";p)");
        } else {
            sb.append(this.len);
            sb.append(this.type == SIZE_TYPE.Pixels ? "px" : "dlu");
        }
        if (this.isGrow) {
            sb.append(":g");
        }
        return sb.toString();
    }

    protected String getAlignStr(ALIGN_TYPE align) {
        if (align != null) {
            switch (align) {
                case None: {
                    return "";
                }
                case Fill: {
                    return "f:";
                }
                case Left: {
                    return "l:";
                }
                case Center: {
                    return "c:";
                }
                case Right: {
                    return "r:";
                }
                case Top: {
                    return "t:";
                }
                case Bottom: {
                    return "b:";
                }
            }
        }
        return "";
    }

    public MINMAX_TYPE getMinMax() {
        return this.minMax;
    }

    public void setMinMax(MINMAX_TYPE minMax) {
        this.minMax = minMax;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public SIZE_TYPE getType() {
        return this.type;
    }

    public void setType(SIZE_TYPE type) {
        this.type = type;
    }

    public boolean isGrow() {
        return this.isGrow;
    }

    public void setGrow(boolean isGrow) {
        this.isGrow = isGrow;
    }

    public ALIGN_TYPE getAlign() {
        return this.align;
    }

    public void setAlign(ALIGN_TYPE align) {
        this.align = align;
    }

    public boolean isInUse() {
        return this.isInUse;
    }

    public void setInUse(boolean isInUse) {
        this.isInUse = isInUse;
    }

    public boolean isPreferredSize() {
        return this.isPreferredSize;
    }

    public void setPreferredSize(boolean isPreferredSize) {
        this.isPreferredSize = isPreferredSize;
    }

    public static enum ALIGN_TYPE {
        None,
        Fill,
        Left,
        Center,
        Right,
        Top,
        Bottom;

    }

    public static enum MINMAX_TYPE {
        None,
        Min,
        Max;

    }

    public static enum SIZE_TYPE {
        Pixels,
        Dlus;

    }
}

