/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane.formeditor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.tasks.subpane.formeditor.JGoodiesDefItem;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefItemPropPanel
extends JPanel {
    protected JGoodiesDefItem.MINMAX_TYPE[] minMax = new JGoodiesDefItem.MINMAX_TYPE[]{JGoodiesDefItem.MINMAX_TYPE.None, JGoodiesDefItem.MINMAX_TYPE.Min, JGoodiesDefItem.MINMAX_TYPE.Max};
    protected JGoodiesDefItem.ALIGN_TYPE[] rowAlign = new JGoodiesDefItem.ALIGN_TYPE[]{JGoodiesDefItem.ALIGN_TYPE.None, JGoodiesDefItem.ALIGN_TYPE.Top, JGoodiesDefItem.ALIGN_TYPE.Bottom};
    protected JGoodiesDefItem.ALIGN_TYPE[] colAlign = new JGoodiesDefItem.ALIGN_TYPE[]{JGoodiesDefItem.ALIGN_TYPE.None, JGoodiesDefItem.ALIGN_TYPE.Left, JGoodiesDefItem.ALIGN_TYPE.Right};
    protected JGoodiesDefItem.SIZE_TYPE[] sizes = new JGoodiesDefItem.SIZE_TYPE[]{JGoodiesDefItem.SIZE_TYPE.Pixels, JGoodiesDefItem.SIZE_TYPE.Dlus};
    protected boolean isRow;
    protected JComboBox minMaxCBX;
    protected JComboBox alignCBX;
    protected JComboBox unitCBX;
    protected JSpinner sizeSpinner;
    protected JCheckBox growCB;
    protected JCheckBox preferredSizeCB;
    protected JGoodiesDefItem currentItem = null;
    protected JPanel propsPanel;

    public DefItemPropPanel(int numInUse, boolean isRow) {
        super(new BorderLayout());
        this.isRow = isRow;
        this.createUI(isRow);
    }

    protected void createUI(boolean isRow) {
        this.propsPanel = this.createPropertyPanel(isRow);
        this.enablePropPanel(true);
        this.add((Component)this.propsPanel, "Center");
    }

    protected JPanel createPropertyPanel(boolean isRow) {
        this.alignCBX = UIHelper.createComboBox((Object[])(isRow ? this.rowAlign : this.colAlign));
        this.minMaxCBX = UIHelper.createComboBox((Object[])this.minMax);
        this.unitCBX = UIHelper.createComboBox((Object[])this.sizes);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 1024, 10);
        this.sizeSpinner = new JSpinner(model);
        UIHelper.setControlSize(this.sizeSpinner);
        this.growCB = UIHelper.createCheckBox(UIRegistry.getResourceString("DefItemPropPanel.SHOULD_GROW"));
        this.preferredSizeCB = UIHelper.createCheckBox(UIRegistry.getResourceString("DefItemPropPanel.USE_PREF_SIZE"));
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p:g", "p,2px,p,2px,p,2px,p,2px,p,2px,p,5px"));
        int y = 1;
        pb.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("DefItemPropPanel.MIN_MAX"), 4), cc.xy(1, y));
        pb.add((Component)this.minMaxCBX, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("DefItemPropPanel.ALIGNMENT"), 4), cc.xy(1, y += 2));
        pb.add((Component)this.alignCBX, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel(" ", 4), cc.xy(1, y += 2));
        pb.add((Component)this.preferredSizeCB, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("DefItemPropPanel.SIZE"), 4), cc.xy(1, y += 2));
        pb.add((Component)this.sizeSpinner, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("DefItemPropPanel.UNIT"), 4), cc.xy(1, y += 2));
        pb.add((Component)this.unitCBX, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel("", 4), cc.xy(1, y += 2));
        pb.add((Component)this.growCB, cc.xy(3, y));
        y += 2;
        this.minMaxCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefItemPropPanel.this.updateUIControls();
            }
        });
        this.preferredSizeCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DefItemPropPanel.this.updateUIControls();
            }
        });
        return pb.getPanel();
    }

    protected void updateUIControls() {
        boolean isNone = this.minMaxCBX.getSelectedIndex() == 0;
        boolean enable = true;
        if (isNone) {
            enable = !this.preferredSizeCB.isSelected();
        }
        this.preferredSizeCB.setEnabled(isNone);
        this.sizeSpinner.setEnabled(enable);
        this.unitCBX.setEnabled(enable);
        if (!enable) {
            this.sizeSpinner.setValue(0);
        }
    }

    protected void enablePropPanel(boolean enable) {
        int i = 0;
        while (i < this.propsPanel.getComponentCount()) {
            this.propsPanel.getComponent(i).setEnabled(enable);
            ++i;
        }
    }

    protected void setDataIntoUI() {
        if (this.currentItem != null) {
            this.minMaxCBX.setSelectedItem((Object)this.currentItem.getMinMax());
            this.alignCBX.setSelectedItem((Object)this.currentItem.getAlign());
            if (this.currentItem.getLen() > -1) {
                this.sizeSpinner.setValue(this.currentItem.getLen());
            }
            this.growCB.setSelected(this.currentItem.isGrow());
            this.preferredSizeCB.setSelected(this.currentItem.isPreferredSize());
            this.updateUIControls();
        } else {
            this.enablePropPanel(false);
        }
    }

    protected void getDataFromUI() {
        if (this.currentItem != null) {
            this.currentItem.setMinMax((JGoodiesDefItem.MINMAX_TYPE)((Object)this.minMaxCBX.getSelectedItem()));
            this.currentItem.setAlign((JGoodiesDefItem.ALIGN_TYPE)((Object)this.alignCBX.getSelectedItem()));
            this.currentItem.setLen(this.preferredSizeCB.isSelected() ? -1 : (Integer)this.sizeSpinner.getValue());
            this.currentItem.setPreferredSize(this.preferredSizeCB.isSelected());
            this.currentItem.setGrow(this.growCB.isSelected());
        }
    }

    public JGoodiesDefItem getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(JGoodiesDefItem currentItem) {
        this.enablePropPanel(true);
        this.currentItem = currentItem;
        this.setDataIntoUI();
    }
}

