/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane.formeditor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.tasks.subpane.formeditor.DefItemPropPanel;
import edu.ku.brc.af.tasks.subpane.formeditor.JGoodiesDefItem;
import edu.ku.brc.af.tasks.subpane.formeditor.RowColDefPanel;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.lang.StringUtils;

public class DefItemEditorPanel
extends JPanel {
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel;
    protected RowColDefPanel propsPanel;
    protected JPanel autoPropsPanel;
    protected DefItemPropPanel cellItemPanel;
    protected DefItemPropPanel sepItemPanel;
    protected JGoodiesDefItem cellItem;
    protected JGoodiesDefItem sepItem;
    protected JRadioButton autoCB;
    protected JRadioButton listCB;
    protected boolean isUsingAuto = false;
    protected FormViewDef.JGDefItem item;
    protected int numInUse;

    public DefItemEditorPanel(FormViewDef.JGDefItem item, int numInUse, boolean isRow) {
        super(new BorderLayout());
        this.item = item;
        this.numInUse = numInUse;
        this.createUI(numInUse, isRow);
        String cellStr = item.getCellDefStr();
        String sepStr = item.getSepDefStr();
        if (StringUtils.isEmpty((String)cellStr)) {
            cellStr = "p";
        }
        if (StringUtils.isEmpty((String)sepStr)) {
            sepStr = "2px";
        }
        this.cellItem = new JGoodiesDefItem(cellStr, isRow);
        this.sepItem = new JGoodiesDefItem(sepStr, isRow);
        this.cellItemPanel.setCurrentItem(this.cellItem);
        this.sepItemPanel.setCurrentItem(this.sepItem);
    }

    protected void createUI(int numInUseArg, boolean isRow) {
        this.propsPanel = new RowColDefPanel(this.item, numInUseArg, isRow);
        this.autoPropsPanel = this.createAutoPropertyPanel(numInUseArg, isRow);
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add("Auto", this.autoPropsPanel);
        this.cardPanel.add("List", this.propsPanel);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefItemEditorPanel.this.isUsingAuto = DefItemEditorPanel.this.autoCB.isSelected();
                DefItemEditorPanel.this.cardLayout.show(DefItemEditorPanel.this.cardPanel, DefItemEditorPanel.this.isUsingAuto ? "Auto" : "List");
            }
        };
        this.autoCB = new JRadioButton("Auto");
        this.autoCB.addActionListener(action);
        this.listCB = new JRadioButton("List");
        this.listCB.addActionListener(action);
        ButtonGroup group = new ButtonGroup();
        group.add(this.autoCB);
        group.add(this.listCB);
        this.autoCB.setSelected(true);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,16px,p,f:p:g", "p"));
        pb.add((Component)this.listCB, cc.xy(2, 1));
        pb.add((Component)this.autoCB, cc.xy(4, 1));
        this.add((Component)pb.getPanel(), "North");
        this.add((Component)this.cardPanel, "Center");
        this.cardLayout.show(this.cardPanel, "List");
        this.listCB.setSelected(true);
        this.isUsingAuto = false;
    }

    protected JPanel createAutoPropertyPanel(int numInUseArg, boolean isRow) {
        this.cellItemPanel = new DefItemPropPanel(numInUseArg, isRow);
        this.sepItemPanel = new DefItemPropPanel(numInUseArg, isRow);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,16px,p", "p,2px,p"));
        pb.addSeparator(String.valueOf(isRow ? "Row" : "Column") + " Item", cc.xy(1, 1));
        pb.add((Component)this.cellItemPanel, cc.xy(1, 3));
        pb.addSeparator("Separator", cc.xy(3, 1));
        pb.add((Component)this.sepItemPanel, cc.xy(3, 3));
        return pb.getPanel();
    }

    public void getDataFromUI() {
        this.item.setAuto(this.isUsingAuto);
        if (this.isUsingAuto) {
            this.cellItemPanel.getDataFromUI();
            this.sepItemPanel.getDataFromUI();
            String cellStr = this.cellItem.toString();
            String sepStr = this.sepItem.toString();
            this.item.setCellDefStr(cellStr);
            this.item.setSepDefStr(sepStr);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.numInUse) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(cellStr);
                sb.append(',');
                sb.append(sepStr);
                ++i;
            }
            this.item.setDefStr(sb.toString());
        } else {
            this.propsPanel.getDataFromUI();
            this.item.setDefStr(this.propsPanel.getDefStr());
        }
        this.item.toString();
    }

    public boolean isUsingAuto() {
        return this.isUsingAuto;
    }
}

