/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.ui.UIHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ViewViewSetEditorPanel
extends JPanel {
    protected ViewSetIFace viewSet;
    protected Vector<ViewIFace> views;
    protected Vector<ViewDefIFace> viewDefs;
    protected ViewIFace selectedView = null;
    protected AltViewIFace selectedAltView = null;
    protected JList viewList;
    protected JList altViewList;
    protected JList viewDefList;
    protected DefaultListModel altViewModel = new DefaultListModel();
    protected MultiView viewsMultiView;
    protected ViewIFace viewsFormView;
    protected MultiView altViewsMultiView;
    protected ViewIFace altViewsFormView;
    protected MultiView viewDefMultiView;
    protected ViewIFace viewDefFormView;
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel;

    public ViewViewSetEditorPanel(ViewSetIFace viewSet) {
        this.viewSet = viewSet;
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,max(200;p),10px,p,f:p:g", "p,2px,p,2px,p,2px,p,2px,p,2px,p,10px, p,5px,p,2px,p,2px,p,p:g"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        this.viewsFormView = AppContextMgr.getInstance().getView("SystemSetup", "ViewProps");
        this.viewsMultiView = new MultiView(null, null, this.viewsFormView, AltViewIFace.CreationMode.EDIT, 16, null);
        this.altViewsFormView = AppContextMgr.getInstance().getView("SystemSetup", "AltViewProps");
        this.altViewsMultiView = new MultiView(null, null, this.altViewsFormView, AltViewIFace.CreationMode.EDIT, 16, null);
        this.viewDefFormView = AppContextMgr.getInstance().getView("SystemSetup", "ViewDefProps");
        this.viewDefMultiView = new MultiView(null, null, this.viewDefFormView, AltViewIFace.CreationMode.EDIT, 16, null);
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add("View", this.viewsMultiView);
        this.cardPanel.add("AltView", this.altViewsMultiView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        this.views = new Vector<ViewIFace>(viewSet.getViews().values());
        Collections.sort(this.views);
        this.viewDefs = new Vector<ViewDefIFace>(viewSet.getViewDefs().values());
        Collections.sort(this.views);
        this.viewList = new JList<ViewIFace>(this.views);
        this.altViewList = new JList(this.altViewModel);
        this.viewDefList = new JList<ViewDefIFace>(this.viewDefs);
        this.altViewList.setVisibleRowCount(4);
        JPanel viewBtnBar = this.createViewListBtnBar();
        JPanel altViewBtnBar = this.createAltViewListBtnBar();
        JPanel viewDefBtnBar = this.createAltViewListBtnBar();
        JScrollPane vsp = UIHelper.createScrollPane(this.viewList);
        JScrollPane asp = UIHelper.createScrollPane(this.altViewList);
        JScrollPane vdsp = UIHelper.createScrollPane(this.viewDefList);
        pb.add((Component)UIHelper.createLabel("Views"), cc.xy(2, 1));
        pb.add((Component)vsp, cc.xy(2, 3));
        pb.add((Component)viewBtnBar, cc.xy(2, 5));
        pb.add((Component)UIHelper.createLabel("Alt Views"), cc.xy(2, 7));
        pb.add((Component)asp, cc.xy(2, 9));
        pb.add((Component)altViewBtnBar, cc.xy(2, 11));
        pb.add((Component)this.cardPanel, cc.xywh(4, 1, 1, 11));
        pb.addSeparator("", cc.xywh(1, 13, 5, 1));
        pb.add((Component)UIHelper.createLabel("View Defs"), cc.xy(2, 15));
        pb.add((Component)vdsp, cc.xy(2, 17));
        pb.add((Component)viewDefBtnBar, cc.xy(2, 19));
        pb.add((Component)this.viewDefMultiView, cc.xywh(4, 15, 1, 6));
        this.viewList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewViewSetEditorPanel.this.viewSelected();
                }
            }
        });
        this.altViewList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewViewSetEditorPanel.this.altViewSelected();
                }
            }
        });
        this.viewDefList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewViewSetEditorPanel.this.viewDefSelected();
                }
            }
        });
    }

    protected void viewSelected() {
        ViewIFace view = (ViewIFace)this.viewList.getSelectedValue();
        if (view != this.selectedView) {
            this.selectedView = view;
            this.viewsMultiView.setData(view);
            this.altViewModel.clear();
            for (AltViewIFace av : this.selectedView.getAltViews()) {
                this.altViewModel.addElement(av);
            }
        }
        this.cardLayout.show(this.cardPanel, "View");
    }

    protected void altViewSelected() {
        AltViewIFace altView = (AltViewIFace)this.altViewList.getSelectedValue();
        if (altView != this.selectedAltView) {
            this.selectedAltView = altView;
            this.altViewsMultiView.setData(this.selectedAltView);
        }
        this.cardLayout.show(this.cardPanel, "AltView");
    }

    protected void viewDefSelected() {
        ViewDefIFace viewDef = (ViewDefIFace)this.viewDefList.getSelectedValue();
        this.viewDefMultiView.setData(viewDef);
    }

    protected JPanel createViewListBtnBar() {
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        ActionListener removeAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        return UIHelper.createAddRemoveEditBtnBar(addAL, "", removeAL, "", null, null);
    }

    protected JPanel createAltViewListBtnBar() {
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        ActionListener removeAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        return UIHelper.createAddRemoveEditBtnBar(addAL, "", removeAL, "", null, null);
    }
}

