/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.dbsupport.CustomQueryFactory;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.JPAQuery;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.stats.BarChartPanel;
import edu.ku.brc.stats.StatDataItem;
import edu.ku.brc.stats.StatGroupTable;
import edu.ku.brc.stats.StatGroupTableFromCustomQuery;
import edu.ku.brc.stats.StatGroupTableFromQuery;
import edu.ku.brc.stats.StatsMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class StatsPane
extends BaseSubPane {
    private static final Logger log = Logger.getLogger(StatsPane.class);
    protected static BasicStroke lineStroke = new BasicStroke(1.5f, 1, 1);
    protected String resourceName = null;
    protected Color bgColor = Color.WHITE;
    protected boolean useSeparatorTitles = false;
    protected FadeBtn updateBtn = null;
    protected int PREFERREDWIDTH = 300;
    protected int SPACING = 35;
    protected JComponent upperDisplayComp = null;
    protected JPanel centerPanel = null;
    protected Vector<Component> comps = new Vector();

    public StatsPane(String name, Taskable task, String resourceName, boolean useSeparatorTitles, Color bgColor, JComponent upperDisplayComp) {
        super(name, task);
        this.resourceName = resourceName;
        this.useSeparatorTitles = useSeparatorTitles;
        this.upperDisplayComp = upperDisplayComp;
        this.bgColor = bgColor != null ? bgColor : Color.WHITE;
        this.setBackground(this.bgColor);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        if (upperDisplayComp == null) {
            JLabel lbl = UIHelper.createI18NLabel("COLL_STATS", 0);
            int pntSize = lbl.getFont().getSize();
            lbl.setFont(lbl.getFont().deriveFont((float)pntSize + 2.0f).deriveFont(1));
            this.add((Component)lbl, "North");
        }
        this.init();
        this.registerPrintContextMenu();
    }

    protected QueryType getQueryType(String type) {
        try {
            return QueryType.valueOf(type.toUpperCase());
        }
        catch (Exception ex) {
            log.error((Object)ex);
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(StatsPane.class, ex);
            return QueryType.SQL;
        }
    }

    protected CommandAction createCommandActionFromElement(Element command) {
        CommandAction cmdAction = null;
        if (command != null) {
            String typeStr = XMLHelper.getAttr(command, "type", null);
            String actionStr = XMLHelper.getAttr(command, "action", null);
            String className = XMLHelper.getAttr(command, "class", null);
            String data = XMLHelper.getAttr(command, "data", null);
            if (StringUtils.isNotEmpty((String)typeStr) && StringUtils.isNotEmpty((String)actionStr)) {
                Class<DataModelObjBase> classObj = null;
                if (StringUtils.isNotEmpty((String)className)) {
                    try {
                        classObj = Class.forName(className).asSubclass(DataModelObjBase.class);
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(StatsPane.class, ex);
                    }
                    if (classObj != null) {
                        cmdAction = new CommandAction(typeStr, actionStr, classObj);
                    }
                } else {
                    cmdAction = new CommandAction(typeStr, actionStr, data);
                }
            }
        }
        return cmdAction;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected StatGroupTable processGroupItems(Element boxElement, String title, String[] colNames, boolean hasResBundle) {
        StatGroupTable groupTable = null;
        List items = boxElement.selectNodes("item");
        if (items != null) {
            groupTable = new StatGroupTable(title, colNames, this.useSeparatorTitles, items.size());
            for (Object io : items) {
                Element itemElement = (Element)io;
                String itemTitle = this.getStrFromAttr(itemElement, "title", hasResBundle);
                String formatStr = null;
                Element formatNode = (Element)itemElement.selectSingleNode("sql/format");
                if (formatNode != null) {
                    formatStr = formatNode.getTextTrim();
                }
                Element command = (Element)itemElement.selectSingleNode("command");
                CommandAction cmdAction = null;
                if (command != null) {
                    cmdAction = this.createCommandActionFromElement(command);
                }
                Element subSqlEl = (Element)itemElement.selectSingleNode("sql");
                QueryType queryType = this.getQueryType(XMLHelper.getAttr(subSqlEl, "type", "sql"));
                CustomQueryIFace customQuery = null;
                if (queryType == QueryType.CUSTOM) {
                    String customQueryName = XMLHelper.getAttr(subSqlEl, "name", null);
                    if (!StringUtils.isNotEmpty((String)customQueryName)) {
                        log.error((Object)("Name is empty for box item [" + XMLHelper.getAttr(itemElement, "title", "N/A") + "]"));
                        return null;
                    }
                    customQuery = CustomQueryFactory.getInstance().getQuery(customQueryName);
                    if (customQuery == null) {
                        return null;
                    }
                    if (!StatsPane.isPermissionOK(customQuery.getTableIds())) {
                        return null;
                    }
                } else {
                    List<Integer> tableIds = StatsPane.getTabledIds(subSqlEl);
                    if (!StatsPane.isPermissionOK(tableIds)) {
                        return null;
                    }
                }
                StatDataItem statItem = new StatDataItem(itemTitle, cmdAction, XMLHelper.getAttr(itemElement, "useprogress", false));
                switch (queryType) {
                    case SQL: {
                        String sql;
                        List statements = itemElement.selectNodes("sql/statement");
                        if (statements.size() == 1) {
                            sql = QueryAdjusterForDomain.getInstance().adjustSQL(((Element)statements.get(0)).getText());
                            statItem.add(sql, 1, 1, StatDataItem.VALUE_TYPE.Value, formatStr);
                            break;
                        }
                        if (statements.size() <= 0) break;
                        int cnt = 0;
                        for (Object stObj : statements) {
                            Element stElement = (Element)stObj;
                            int vRowInx = XMLHelper.getAttr(stElement, "row", -1);
                            int vColInx = XMLHelper.getAttr(stElement, "col", -1);
                            String format = XMLHelper.getAttr(stElement, "format", null);
                            String sql2 = QueryAdjusterForDomain.getInstance().adjustSQL(stElement.getText());
                            if (vRowInx == -1 || vColInx == -1) {
                                statItem.add(sql2, format);
                            } else {
                                statItem.add(sql2, vRowInx, vColInx, StatDataItem.VALUE_TYPE.Value, format);
                            }
                            ++cnt;
                        }
                        break;
                    }
                    case JPA: {
                        List statements = itemElement.selectNodes("sql/statement");
                        String sql = QueryAdjusterForDomain.getInstance().adjustSQL(((Element)statements.get(0)).getText());
                        statItem.addCustomQuery(new JPAQuery(sql), formatStr);
                        break;
                    }
                    case CUSTOM: {
                        statItem.addCustomQuery(customQuery, formatStr);
                        break;
                    }
                }
                groupTable.addDataItem(statItem);
                statItem.startUp();
            }
            groupTable.relayout();
        }
        return groupTable;
    }

    private String getStrFromAttr(String str, boolean hasResBundle) {
        if (StringUtils.isNotEmpty((String)str) && !str.equals(" ")) {
            return hasResBundle ? UIRegistry.getResourceString(str) : str;
        }
        return " ";
    }

    private String getStrFromAttr(Element boxElement, String attr, boolean hasResBundle) {
        String str = XMLHelper.getAttr(boxElement, attr, null);
        return this.getStrFromAttr(str, hasResBundle);
    }

    protected Component processBox(Element boxElement, boolean hasResBundle) {
        StatGroupTable comp = null;
        int descCol = XMLHelper.getAttr(boxElement, "desccol", -1);
        int valCol = XMLHelper.getAttr(boxElement, "valcol", -1);
        String descTitle = this.getStrFromAttr(boxElement, "desctitle", hasResBundle);
        String title = this.getStrFromAttr(boxElement, "title", hasResBundle);
        String noresults = this.getStrFromAttr(boxElement, "noresults", hasResBundle);
        String[] colNames = null;
        colNames = valCol != -1 && descCol == -1 ? new String[]{this.getStrFromAttr(boxElement, "valtitle", hasResBundle)} : (descCol != -1 && valCol == -1 && StringUtils.isNotEmpty((String)descTitle) ? new String[]{this.getStrFromAttr(descTitle, hasResBundle)} : new String[]{this.getStrFromAttr(descTitle, hasResBundle), this.getStrFromAttr(boxElement, "valtitle", hasResBundle)});
        Element sqlElement = (Element)boxElement.selectSingleNode("sql");
        if (valCol > -1 && sqlElement != null) {
            List<Integer> tableIds = StatsPane.getTabledIds(sqlElement);
            if (StatsPane.isPermissionOK(tableIds)) {
                QueryType queryType = this.getQueryType(XMLHelper.getAttr(sqlElement, "type", "sql"));
                Element command = (Element)boxElement.selectSingleNode("command");
                int colId = -1;
                CommandAction cmdAction = null;
                if (command != null) {
                    colId = XMLHelper.getAttr(command, "colid", -1);
                    cmdAction = this.createCommandActionFromElement(command);
                }
                try {
                    Element sqlStmt = (Element)sqlElement.selectSingleNode("statement");
                    String sql = QueryAdjusterForDomain.getInstance().adjustSQL(sqlStmt.getText());
                    switch (queryType) {
                        case SQL: {
                            sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
                            StatGroupTableFromQuery group = new StatGroupTableFromQuery(title, colNames, sql, descCol, valCol, this.useSeparatorTitles, noresults);
                            if (cmdAction != null) {
                                group.setCommandAction(cmdAction, colId);
                            }
                            comp = group;
                            group.relayout();
                            break;
                        }
                        case JPA: {
                            StatGroupTableFromCustomQuery group = new StatGroupTableFromCustomQuery(title, colNames, new JPAQuery(sql), this.useSeparatorTitles, noresults);
                            if (cmdAction != null) {
                                group.setCommandAction(cmdAction, colId);
                            }
                            comp = group;
                            group.relayout();
                            break;
                        }
                        case CUSTOM: {
                            StatGroupTableFromCustomQuery group = new StatGroupTableFromCustomQuery(title, colNames, sql, this.useSeparatorTitles, noresults);
                            if (cmdAction != null) {
                                group.setCommandAction(cmdAction, colId);
                            }
                            comp = group;
                            group.relayout();
                        }
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(StatsPane.class, ex);
                    ex.printStackTrace();
                }
            }
        } else {
            comp = this.processGroupItems(boxElement, title, colNames, hasResBundle);
        }
        return comp;
    }

    protected void init() {
        JComponent parentComp = this.upperDisplayComp != null ? this.upperDisplayComp : this;
        for (Component c : this.comps) {
            parentComp.remove(c);
        }
        this.comps.clear();
        if (this.centerPanel != null) {
            this.remove(this.centerPanel);
        }
        Element rootElement = null;
        try {
            rootElement = AppContextMgr.getInstance().getResourceAsDOM(this.resourceName);
            if (rootElement == null) {
                throw new RuntimeException("Couldn't find resource [" + this.resourceName + "]");
            }
            StringBuilder rowsDef = new StringBuilder(128);
            boolean hasResBundle = false;
            Element panelEl = (Element)rootElement.selectObject("/panel");
            String resBundleName = XMLHelper.getAttr(panelEl, "resource", null);
            if (StringUtils.isNotEmpty((String)resBundleName)) {
                hasResBundle = true;
                UIRegistry.loadAndPushResourceBundle(resBundleName);
            }
            List rows = rootElement.selectNodes("/panel/row");
            int maxCols = 0;
            for (Object obj : rows) {
                Element rowElement = (Element)obj;
                List boxes = rowElement.selectNodes("box");
                maxCols = Math.max(maxCols, boxes.size());
                if (rowsDef.length() > 0) {
                    rowsDef.append(",15dlu,");
                }
                rowsDef.append("top:p");
            }
            int preferredWidth = this.PREFERREDWIDTH;
            int spacing = this.SPACING;
            String colDefs = UIHelper.createDuplicateJGoodiesDef("f:min(" + preferredWidth + "px;p)", String.valueOf(spacing) + "px", maxCols);
            FormLayout formLayout = new FormLayout(colDefs, rowsDef.toString());
            PanelBuilder builder = new PanelBuilder(formLayout);
            CellConstraints cc = new CellConstraints();
            int y = 1;
            for (Object obj : rows) {
                Element rowElement = (Element)obj;
                int x = 1;
                List boxes = rowElement.selectNodes("box");
                for (Object bo : boxes) {
                    Element boxElement = (Element)bo;
                    String type = XMLHelper.getAttr(boxElement, "type", "box");
                    int colSpan = XMLHelper.getAttr(boxElement, "colspan", 1);
                    Component comp = null;
                    if (type.equalsIgnoreCase("bar chart")) {
                        String statName = XMLHelper.getAttr(boxElement, "name", null);
                        if (StringUtils.isNotEmpty((String)statName)) {
                            BarChartPanel bcp = (BarChartPanel)StatsMgr.createStatPane(statName);
                            int width = colSpan > 1 ? maxCols * preferredWidth + (maxCols - 1) * spacing : preferredWidth;
                            bcp.setPreferredChartSize(width, preferredWidth);
                            comp = bcp;
                            this.validate();
                            this.doLayout();
                            this.repaint();
                        }
                    } else {
                        comp = this.processBox(boxElement, hasResBundle);
                    }
                    if (comp == null) continue;
                    this.comps.add(comp);
                    if (colSpan == 1) {
                        builder.add(comp, cc.xy(x, y));
                    } else {
                        builder.add(comp, cc.xywh(x, y, colSpan, 1));
                    }
                    x += 2;
                }
                y += 2;
            }
            if (hasResBundle) {
                UIRegistry.popResourceBundle();
            }
            this.setBackground(this.bgColor);
            JPanel statPanel = builder.getPanel();
            statPanel.setBackground(Color.WHITE);
            boolean hasUpper = this.upperDisplayComp != null;
            builder = new PanelBuilder(new FormLayout("C:P:G", hasUpper ? "50px,p,20px,p" : "p"));
            if (hasUpper) {
                y = 2;
                builder.add((Component)this.upperDisplayComp, cc.xy(1, y));
                y += 2;
            } else {
                y = 1;
            }
            builder.add((Component)statPanel, cc.xy(1, y));
            this.centerPanel = builder.getPanel();
            this.centerPanel.setBackground(Color.WHITE);
            if (this.isTiled()) {
                this.centerPanel.setOpaque(false);
                this.setOpaque(false);
                statPanel.setOpaque(false);
            }
            this.centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.centerPanel, "Center");
            if (this.updateBtn == null) {
                PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,4px", "4px,p,4px"));
                this.updateBtn = new FadeBtn(UIRegistry.getResourceString("STS_UPDATE"));
                pb.add((Component)this.updateBtn, cc.xy(2, 2));
                pb.getPanel().setBackground(this.bgColor);
                this.add((Component)pb.getPanel(), "South");
                this.updateBtn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        StatsPane.this.init();
                    }
                });
            }
            this.centerPanel.validate();
            this.validate();
            this.doLayout();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(StatsPane.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
    }

    protected static List<Integer> getTabledIds(Element item) {
        List tables;
        if (item != null && (tables = item.selectNodes("tables/id")) != null) {
            Vector<Integer> list = new Vector<Integer>();
            for (Object obj : tables) {
                Element tbl = (Element)obj;
                list.add(Integer.parseInt(tbl.getTextTrim()));
            }
            return list;
        }
        return null;
    }

    public static boolean isPermissionOK(List<Integer> list) {
        boolean isOK = true;
        if (AppContextMgr.isSecurityOn() && list != null) {
            for (Integer tableId : list) {
                DBTableInfo tInfo = DBTableIdMgr.getInstance().getInfoById(tableId);
                if (tInfo == null || tInfo.getPermissions().canView()) continue;
                return false;
            }
        }
        return isOK;
    }

    class FadeBtn
    extends JComponent {
        protected String text;
        protected Dimension size = null;
        protected boolean isHover = false;
        protected boolean isActivate = false;

        public FadeBtn(String text) {
            this.text = text;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    FadeBtn.this.isHover = true;
                    FadeBtn.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FadeBtn.this.isHover = false;
                    FadeBtn.this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    FadeBtn.this.isActivate = true;
                    FadeBtn.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    FadeBtn.this.isActivate = false;
                    FadeBtn.this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension sz = this.getSize();
            boolean x = false;
            boolean y = false;
            Graphics2D g2d = (Graphics2D)g;
            Color color = this.isActivate ? new Color(64, 64, 255, 192) : (this.isHover ? new Color(32, 32, 32, 192) : new Color(128, 128, 128, 128));
            g.setColor(color);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int arc = sz.height;
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double((double)x, (double)y, sz.width - 1, sz.height - 1, arc, arc);
            g2d.setStroke(lineStroke);
            g2d.draw(rr);
            FontMetrics fm = g2d.getFontMetrics();
            int hgt = fm.getHeight();
            int wdh = fm.stringWidth(this.text);
            g2d.drawString(this.text, (this.size.width - wdh) / 2, this.size.height - (this.size.height - hgt) / 2 - fm.getDescent() - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.size == null) {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
                Graphics2D g2d = bufferedImage.createGraphics();
                FontMetrics fm = g2d.getFontMetrics();
                int h = fm.getHeight() + 4;
                int w = fm.stringWidth(this.text) + h;
                this.size = new Dimension(w, h);
            }
            return this.size;
        }
    }

    protected static enum QueryType {
        SQL,
        JPA,
        CUSTOM;

    }
}

