/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleDescPane
extends BaseSubPane {
    protected ImageIcon splashImage = null;

    public SimpleDescPane(String name, Taskable task, ImageIcon splashImage) {
        super(name, task);
        this.setLayout(null);
        this.removeAll();
        this.setBackground(Color.WHITE);
        this.splashImage = splashImage;
    }

    public SimpleDescPane(String name, Taskable task, String desc) {
        super(name, task);
        this.setBackground(Color.WHITE);
        JLabel label = UIHelper.createLabel(desc, 0);
        this.add((Component)label, "Center");
    }

    public SimpleDescPane(String name, Taskable task, JPanel panel) {
        super(name, task);
        this.setBackground(Color.WHITE);
        this.add((Component)panel, "Center");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.splashImage != null) {
            Dimension size = this.getSize();
            int imgW = Math.min(size.width, this.splashImage.getIconWidth());
            int imgH = Math.min(size.height, this.splashImage.getIconHeight());
            int x = (size.width - imgW) / 2;
            int y = (size.height - imgH) / 2;
            g.drawImage(this.splashImage.getImage(), x, y, imgW, imgH, null);
        }
    }

    public ImageIcon getSplashImage() {
        return this.splashImage;
    }

    public void setSplashImage(ImageIcon splashImage) {
        this.splashImage = splashImage;
    }
}

