/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.ChartPane;
import edu.ku.brc.dbsupport.QueryResultsContainer;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsGetter;
import edu.ku.brc.dbsupport.QueryResultsHandlerIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.Icon;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChartPane
extends ChartPane {
    private QueryResultsGetter getter;
    private QueryResultsContainer qrContainer;
    private QueryResultsHandlerIFace handler = null;

    public PieChartPane(String name, Taskable task) {
        super(name, task);
        this.progressLabel.setText(UIRegistry.getResourceString("PieChartPane.BUILD_PIECHART"));
        this.getter = new QueryResultsGetter(this);
        this.qrContainer = new QueryResultsContainer(name);
    }

    @Override
    public Icon getIcon() {
        return IconManager.getIcon("Pie_Chart", IconManager.IconSize.Std16);
    }

    @Override
    public void setHandler(QueryResultsHandlerIFace handler) {
        this.handler = handler;
    }

    @Override
    public QueryResultsHandlerIFace getHandler() {
        return this.handler;
    }

    @Override
    public synchronized void allResultsBack(QueryResultsContainerIFace qrc) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        List<Object> list = this.handler.getDataObjects();
        int i = 0;
        while (i < list.size()) {
            Object descObj = list.get(i++);
            Object valObj = list.get(i);
            dataset.setValue((Comparable)((Object)UIHelper.getString(descObj)), (double)UIHelper.getInt(valObj));
            ++i;
        }
        list.clear();
        JFreeChart chart = ChartFactory.createPieChart((String)this.title, (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelFont(new Font("SansSerif", 0, 11));
        this.removeAll();
        ChartPanel panel = new ChartPanel(chart, true, true, true, true, true);
        this.add((Component)panel, "Center");
        this.doLayout();
        this.repaint();
    }

    @Override
    public void resultsInError(QueryResultsContainerIFace qrc) {
    }
}

