/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.AttachmentUtils;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlDescPane
extends SimpleDescPane
implements HyperlinkListener {
    public HtmlDescPane(String name, Taskable task, String htmlDesc) {
        super(name, task, "");
        this.removeAll();
        JEditorPane htmlPane = new JEditorPane("text/html", htmlDesc);
        final JScrollPane scrollPane = UIHelper.createScrollPane(htmlPane);
        this.add((Component)scrollPane, "Center");
        htmlPane.setEditable(false);
        htmlPane.addHyperlinkListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scrollPane.getVerticalScrollBar().setValue(0);
                scrollPane.getHorizontalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                AttachmentUtils.openURI(e.getURL().toURI());
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HtmlDescPane.class, ex);
                ex.printStackTrace();
            }
        }
    }
}

