/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.tasks.subpane.DroppableFormObject;
import edu.ku.brc.af.tasks.subpane.DroppableTaskPane;
import edu.ku.brc.af.tasks.subpane.FormProcessor;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltView;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class FormPane
extends DroppableTaskPane {
    protected String viewSetName = null;
    protected String viewName = null;
    protected Object data = null;
    protected RecordSetIFace recordSet = null;
    protected MultiView multiView = null;
    protected FormProcessor formProcessor = null;
    protected String cacheDesc = null;
    protected ImageIcon icon = null;
    protected boolean isNewObj;
    protected boolean firstTimeShown = true;
    protected boolean isShuttingDown = false;
    protected boolean doSuppressBusRules = false;

    public FormPane(String name, Taskable task, String desc) {
        super(name, task, desc);
    }

    public FormPane(String name, Taskable task, String viewSetName, String viewName, String mode, Object data, int options) {
        this(name, task, viewSetName, viewName, mode, data, options, null);
    }

    public FormPane(String name, Taskable task, String viewSetName, String viewName, String mode, Object data, int options, boolean doSuppressBusRules) {
        this(name, task, "");
        this.viewSetName = viewSetName;
        this.viewName = viewName;
        this.data = data;
        this.doSuppressBusRules = doSuppressBusRules;
        this.createForm(viewSetName, viewName, AltView.parseMode(mode, AltViewIFace.CreationMode.VIEW), data, options, null);
    }

    public FormPane(String name, Taskable task, String viewSetName, String viewName, String mode, Object data, int options, FormPaneAdjusterIFace adjuster) {
        this(name, task, "");
        this.viewSetName = viewSetName;
        this.viewName = viewName;
        this.data = data;
        this.createForm(viewSetName, viewName, AltView.parseMode(mode, AltViewIFace.CreationMode.VIEW), data, options, adjuster);
    }

    public FormPane(String name, Taskable task, ViewIFace view, String mode, Object data, int options, boolean doSuppressBusRules) {
        this(name, task, "");
        this.viewSetName = view.getViewSetName();
        this.viewName = view.getName();
        this.data = data;
        this.doSuppressBusRules = doSuppressBusRules;
        UsageTracker.incrUsageCount("DE.VIEW." + this.viewName);
        this.createForm(view, AltView.parseMode(mode, AltViewIFace.CreationMode.VIEW), data, options, null);
    }

    public FormPane(String name, Taskable task, ViewIFace view, String mode, Object data, int options) {
        this(name, task, view, mode, data, options, false);
    }

    @Override
    public void setVisible(boolean visible) {
        boolean isVis = super.isVisible();
        if (isVis != visible) {
            super.setVisible(visible);
            if (this.multiView != null && (this.isShuttingDown && !visible || !this.isShuttingDown)) {
                this.multiView.aboutToShow(visible);
                FormViewObj fvo = this.multiView.getCurrentViewAsFormViewObj();
                if (fvo != null) {
                    if (visible) {
                        ResultSetController.setBackStopRS(fvo.getRsController());
                    } else {
                        ResultSetController.setBackStopRS(null);
                    }
                }
                if (this.isNewObj && visible && this.firstTimeShown) {
                    this.firstTimeShown = false;
                    this.multiView.setIsNewForm(true, false);
                }
            }
        }
    }

    public FormProcessor getFormProcessor() {
        return this.formProcessor;
    }

    public void setFormProcessor(FormProcessor formProcessor) {
        this.formProcessor = formProcessor;
        formProcessor.setViewable(this);
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    @Override
    public RecordSetIFace getRecordSet() {
        return this.recordSet;
    }

    public void setRecordSet(RecordSetIFace recordSet) {
        this.recordSet = recordSet;
        UsageTracker.incrUsageCount("DE.VIEW." + this.viewName + ".RS");
        this.multiView.getCurrentView().setRecordSet(recordSet);
    }

    @Override
    public MultiView getMultiView() {
        return this.multiView;
    }

    @Override
    public void shutdown() {
        this.recordSet = null;
        if (this.multiView != null) {
            this.multiView.aboutToShutdown();
            this.multiView.shutdown();
            this.multiView = null;
        }
        super.shutdown();
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
    }

    @Override
    public void doAction(GhostActionable src) {
        Object srcData;
        if (src != null && (srcData = src.getData()) != null && srcData instanceof DroppableFormObject) {
            DroppableFormObject dfo = (DroppableFormObject)srcData;
            this.createForm(dfo.getViewSetName(), DBTableIdMgr.getInstance().getDefaultFormNameById(dfo.getFormId()), AltViewIFace.CreationMode.VIEW, dfo.getData(), 2, null);
        }
    }

    public void createForm(String viewSetNameArg, String viewNameArg, AltViewIFace.CreationMode mode, Object dataArg, int options, FormPaneAdjusterIFace adjuster) {
        this.viewSetName = viewSetNameArg;
        this.viewName = viewNameArg;
        this.createForm(AppContextMgr.getInstance().getView(this.viewSetName, this.viewName), mode, dataArg, options, adjuster);
    }

    public void createForm(ViewIFace view, AltViewIFace.CreationMode mode, Object dataArg, int options, FormPaneAdjusterIFace adjuster) {
        if (view != null) {
            this.name = view.getName();
            DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
            if (ti != null) {
                this.name = ti.getTitle();
            }
            int opts = options;
            this.multiView = new MultiView(null, null, view, mode, opts |= dataArg != null && (dataArg instanceof List || dataArg instanceof Set) ? 1 : 0);
            if (this.multiView != null) {
                this.isNewObj = MultiView.isOptionOn(options, 4);
                this.data = dataArg;
                this.removeAll();
                this.multiView.invalidate();
                this.add((Component)this.multiView, "Center");
                if (adjuster != null && this.multiView.getCurrentViewAsFormViewObj() != null) {
                    adjuster.adjustForm(this.multiView.getCurrentViewAsFormViewObj());
                }
                if (this.data != null) {
                    if (this.isNewObj) {
                        BusinessRulesIFace busRule;
                        Collection col;
                        Object newDataObj = this.data;
                        if (this.data instanceof Collection && !(col = (Collection)this.data).isEmpty()) {
                            newDataObj = col.iterator().next();
                        }
                        if ((busRule = DBTableIdMgr.getInstance().getBusinessRule(newDataObj)) != null && !this.doSuppressBusRules) {
                            busRule.addChildrenToNewDataObjects(newDataObj);
                        }
                    }
                    if (this.data instanceof RecordSetIFace) {
                        this.setRecordSet((RecordSetIFace)this.data);
                    } else {
                        this.multiView.setData(this.data);
                    }
                }
                if (this.isNewObj) {
                    this.multiView.setIsNewForm(true, false);
                }
                if (this.multiView != null && this.multiView.getCurrentView() != null && this.multiView.getCurrentView().getValidator() != null) {
                    this.multiView.getCurrentView().getValidator().validateForm();
                }
                this.cacheDesc = this.desc;
                this.desc = null;
                this.doLayout();
                UIRegistry.forceTopFrameRepaint();
            }
        } else {
            throw new RuntimeException("The View was null!");
        }
    }

    public void focusFirstFormControl() {
        if (this.multiView != null) {
            this.multiView.focus();
        }
    }

    public void initSubViews() {
        if (this.multiView != null) {
            this.multiView.initSubViews();
        }
    }

    public void clearForm() {
        this.removeAll();
        this.desc = this.cacheDesc;
        this.data = null;
        if (this.formProcessor != null) {
            this.formProcessor.setViewable(null);
            this.formProcessor = null;
        }
        this.doLayout();
        UIRegistry.forceTopFrameRepaint();
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getViewSetName() {
        return this.viewSetName;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setActive(boolean isActive) {
    }

    public Viewable getViewable() {
        return this.multiView != null ? this.multiView.getCurrentView() : null;
    }

    @Override
    public boolean aboutToShutdown() {
        FormViewObj formViewObj;
        this.isShuttingDown = true;
        if (this.multiView != null && (formViewObj = this.multiView.getCurrentViewAsFormViewObj()) != null) {
            this.isShuttingDown = formViewObj.isDataCompleteAndValid(true);
        }
        return this.isShuttingDown;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public Component getFirstFocusable() {
        return this.multiView != null ? this.multiView.getFirstFocusable() : null;
    }

    public void setDoSuppressBusRules(boolean doSuppressBusRules) {
        this.doSuppressBusRules = doSuppressBusRules;
    }

    public static interface FormPaneAdjusterIFace {
        public void adjustForm(FormViewObj var1);
    }
}

